/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.roi.EllipseRegionOfInterest;
import org.scijava.Context;

public class EllipseOverlay
extends AbstractROIOverlay<EllipseRegionOfInterest> {
    private static final long serialVersionUID = 1L;

    public EllipseOverlay() {
        super(new EllipseRegionOfInterest(2));
    }

    public EllipseOverlay(Context context) {
        super(context, new EllipseRegionOfInterest(2));
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        EllipseRegionOfInterest roi = (EllipseRegionOfInterest)this.getRegionOfInterest();
        out.writeDouble(roi.getOrigin(0));
        out.writeDouble(roi.getOrigin(1));
        out.writeDouble(roi.getRadius(0));
        out.writeDouble(roi.getRadius(1));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        EllipseRegionOfInterest roi = (EllipseRegionOfInterest)this.getRegionOfInterest();
        roi.setOrigin(in.readDouble(), 0);
        roi.setOrigin(in.readDouble(), 1);
        roi.setRadius(in.readDouble(), 0);
        roi.setRadius(in.readDouble(), 1);
    }

    @Override
    public void move(double[] deltas) {
        ((EllipseRegionOfInterest)this.getRegionOfInterest()).move(deltas);
    }

    public double getOrigin(int dim) {
        return ((EllipseRegionOfInterest)this.getRegionOfInterest()).getOrigin(dim);
    }

    public double getRadius(int dim) {
        return ((EllipseRegionOfInterest)this.getRegionOfInterest()).getRadius(dim);
    }

    public void setOrigin(double val, int dim) {
        ((EllipseRegionOfInterest)this.getRegionOfInterest()).setOrigin(val, dim);
    }

    public void setRadius(double val, int dim) {
        ((EllipseRegionOfInterest)this.getRegionOfInterest()).setRadius(val, dim);
    }
}

