/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.AbstractUnaryBlockOperator;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.type.NativeType;
import net.imglib2.util.Cast;

public class DefaultUnaryBlockOperator<S extends NativeType<S>, T extends NativeType<T>>
extends AbstractUnaryBlockOperator<S, T> {
    private final BlockProcessor blockProcessor;

    public DefaultUnaryBlockOperator(S sourceType, T targetType, int numSourceDimensions, int numTargetDimensions, BlockProcessor<?, ?> blockProcessor) {
        super(sourceType, targetType, numSourceDimensions, numTargetDimensions);
        this.blockProcessor = blockProcessor;
    }

    private DefaultUnaryBlockOperator(DefaultUnaryBlockOperator<S, T> op) {
        super(op);
        this.blockProcessor = op.blockProcessor.independentCopy();
    }

    @Override
    public void compute(BlockSupplier<S> src, Interval interval, Object dest) {
        this.blockProcessor.setTargetInterval(interval);
        Object buf = this.blockProcessor.getSourceBuffer();
        src.copy(this.blockProcessor.getSourceInterval(), buf);
        this.blockProcessor.compute(buf, dest);
    }

    @Override
    public UnaryBlockOperator<S, T> independentCopy() {
        return new DefaultUnaryBlockOperator<S, T>(this);
    }

    public <I, O> BlockProcessor<I, O> blockProcessor() {
        return (BlockProcessor)Cast.unchecked((Object)this.blockProcessor);
    }
}

