/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.componenttree;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.PriorityQueue;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.componenttree.PartialComponent;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;

public final class BuildComponentTree<T extends Type<T>, C extends PartialComponent<T, C>> {
    private final ArrayDeque<BoundaryPixel> reusableBoundaryPixels = new ArrayDeque();
    private final PartialComponent.Generator<T, C> componentGenerator;
    private final PartialComponent.Handler<C> componentOutput;
    private final Neighborhood neighborhood;
    private final RandomAccessible<BitType> visited;
    private final RandomAccess<BitType> visitedRandomAccess;
    private final PriorityQueue<BoundaryPixel> boundaryPixels;
    private final ArrayDeque<C> componentStack;
    private final Comparator<T> comparator;

    public static <T extends Type<T>, C extends PartialComponent<T, C>> void buildComponentTree(RandomAccessibleInterval<T> input, PartialComponent.Generator<T, C> componentGenerator, PartialComponent.Handler<C> componentHandler, Comparator<T> comparator) {
        new BuildComponentTree<T, C>(input, componentGenerator, componentHandler, comparator);
    }

    public static <T extends Type<T> & Comparable<T>, C extends PartialComponent<T, C>> void buildComponentTree(RandomAccessibleInterval<T> input, PartialComponent.Generator<T, C> componentGenerator, PartialComponent.Handler<C> componentHandler, boolean darkToBright) {
        new BuildComponentTree<T, C>(input, componentGenerator, componentHandler, darkToBright ? new DarkToBright() : new BrightToDark());
    }

    private BoundaryPixel createBoundaryPixel(Localizable position, T value, int nextNeighborIndex) {
        if (this.reusableBoundaryPixels.isEmpty()) {
            return new BoundaryPixel(this, position, value, nextNeighborIndex);
        }
        BoundaryPixel p = this.reusableBoundaryPixels.pop();
        p.setPosition(position);
        p.value.set(value);
        p.nextNeighborIndex = nextNeighborIndex;
        return p;
    }

    private void freeBoundaryPixel(BoundaryPixel p) {
        this.reusableBoundaryPixels.push(p);
    }

    private BuildComponentTree(RandomAccessibleInterval<T> input, PartialComponent.Generator<T, C> componentGenerator, PartialComponent.Handler<C> componentOutput, Comparator<T> comparator) {
        this.componentGenerator = componentGenerator;
        this.componentOutput = componentOutput;
        long[] dimensions = new long[input.numDimensions()];
        input.dimensions(dimensions);
        ArrayImgFactory imgFactory = new ArrayImgFactory((NativeType)new BitType());
        this.visited = imgFactory.create(dimensions);
        this.visitedRandomAccess = this.visited.randomAccess();
        this.neighborhood = new Neighborhood(dimensions);
        this.boundaryPixels = new PriorityQueue();
        this.componentStack = new ArrayDeque();
        this.componentStack.push(componentGenerator.createMaxComponent());
        this.comparator = comparator;
        this.run(input);
    }

    private void run(RandomAccessibleInterval<T> input) {
        RandomAccess current = input.randomAccess();
        RandomAccess neighbor = input.randomAccess();
        input.min((Positionable)current);
        neighbor.setPosition((Localizable)current);
        this.visitedRandomAccess.setPosition((Localizable)current);
        Type currentLevel = ((Type)current.get()).createVariable();
        Type neighborLevel = ((Type)current.get()).createVariable();
        ((BitType)this.visitedRandomAccess.get()).set(true);
        currentLevel.set((Type)current.get());
        this.componentStack.push(this.componentGenerator.createComponent(currentLevel));
        while (true) {
            if (this.neighborhood.hasNext()) {
                if (!this.neighborhood.next((Localizable)current, (Positionable)neighbor, (Positionable)this.visitedRandomAccess) || ((BitType)this.visitedRandomAccess.get()).get()) continue;
                ((BitType)this.visitedRandomAccess.get()).set(true);
                neighborLevel.set((Type)neighbor.get());
                if (this.comparator.compare(neighborLevel, currentLevel) >= 0) {
                    this.boundaryPixels.add(this.createBoundaryPixel((Localizable)neighbor, neighborLevel, 0));
                    continue;
                }
                this.boundaryPixels.add(this.createBoundaryPixel((Localizable)current, currentLevel, this.neighborhood.getNextNeighborIndex()));
                current.setPosition((Localizable)neighbor);
                currentLevel.set(neighborLevel);
                this.componentStack.push(this.componentGenerator.createComponent(currentLevel));
                this.neighborhood.reset();
                continue;
            }
            PartialComponent component = (PartialComponent)this.componentStack.peek();
            component.addPosition((Localizable)current);
            if (this.boundaryPixels.isEmpty()) {
                this.processStack(currentLevel);
                return;
            }
            BoundaryPixel p = this.boundaryPixels.poll();
            if (this.comparator.compare((Type)p.get(), currentLevel) != 0) {
                this.processStack(p.get());
            }
            current.setPosition((Localizable)p);
            neighbor.setPosition((Localizable)current);
            this.visitedRandomAccess.setPosition((Localizable)current);
            currentLevel.set(p.get());
            this.neighborhood.setNextNeighborIndex(p.getNextNeighborIndex());
            this.freeBoundaryPixel(p);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processStack(T value) {
        while (true) {
            PartialComponent component = (PartialComponent)this.componentStack.pop();
            this.componentOutput.emit(component);
            PartialComponent secondComponent = (PartialComponent)this.componentStack.peek();
            try {
                int c = this.comparator.compare(value, secondComponent.getValue());
                if (c < 0) {
                    component.setValue(value);
                    this.componentStack.push(component);
                    return;
                }
                secondComponent.merge(component);
                if (c <= 0) return;
            }
            catch (NullPointerException e) {
                this.componentStack.push(component);
                return;
            }
        }
    }

    private final class BoundaryPixel
    extends Point
    implements Comparable<BoundaryPixel> {
        private final T value;
        private int nextNeighborIndex;
        final /* synthetic */ BuildComponentTree this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public BoundaryPixel(Localizable position, T value, int nextNeighborIndex) {
            this.this$0 = (BuildComponentTree)n;
            super(position);
            this.nextNeighborIndex = nextNeighborIndex;
            this.value = value.copy();
        }

        public int getNextNeighborIndex() {
            return this.nextNeighborIndex;
        }

        public T get() {
            return this.value;
        }

        @Override
        public int compareTo(BoundaryPixel o) {
            return this.this$0.comparator.compare(this.value, o.value);
        }
    }

    private static final class Neighborhood {
        private int n = 0;
        private final int nBound;
        final long[] dimensions;

        public Neighborhood(long[] dim) {
            this.nBound = dim.length * 2;
            this.dimensions = dim;
        }

        public int getNextNeighborIndex() {
            return this.n;
        }

        public void setNextNeighborIndex(int n) {
            this.n = n;
        }

        public void reset() {
            this.n = 0;
        }

        public boolean hasNext() {
            return this.n < this.nBound;
        }

        public boolean next(Localizable current, Positionable neighbor, Positionable neighbor2) {
            int d = this.n / 2;
            boolean bck = this.n == 2 * d;
            ++this.n;
            if (bck) {
                if (d > 0) {
                    neighbor.setPosition(current.getLongPosition(d - 1), d - 1);
                    neighbor2.setPosition(current.getLongPosition(d - 1), d - 1);
                }
                long dpos = current.getLongPosition(d) - 1L;
                neighbor.setPosition(dpos, d);
                neighbor2.setPosition(dpos, d);
                return dpos >= 0L;
            }
            long dpos = current.getLongPosition(d) + 1L;
            neighbor.setPosition(dpos, d);
            neighbor2.setPosition(dpos, d);
            return dpos < this.dimensions[d];
        }
    }

    public static final class BrightToDark<T extends Comparable<T>>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            return o2.compareTo(o1);
        }
    }

    public static final class DarkToBright<T extends Comparable<T>>
    implements Comparator<T> {
        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    }
}

