/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.interpolation.randomaccess;

import java.util.Arrays;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolator;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolatorEven;
import net.imglib2.algorithm.bspline.BSplineCoefficientsInterpolatorOdd;
import net.imglib2.algorithm.bspline.BSplineDecomposition;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class BSplineCoefficientsInterpolatorFactory<T extends RealType<T>, S extends RealType<S>>
implements InterpolatorFactory<S, RandomAccessible<T>> {
    protected final int order;
    protected final boolean clipping;
    protected final RandomAccessibleInterval<S> coefficients;
    protected OutOfBoundsFactory<?, ?> oobFactory;

    public BSplineCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, boolean clipping, ImgFactory<S> coefficientFactory, OutOfBoundsFactory<? extends RealType<?>, ?> oobFactory) {
        this.order = order;
        this.clipping = clipping;
        this.oobFactory = oobFactory;
        ExtendedRandomAccessibleInterval extendedImg = Views.extend((RandomAccessibleInterval)Views.interval(img, (Interval)interval), oobFactory);
        BSplineDecomposition decomp = new BSplineDecomposition(order, extendedImg);
        long[] min = Intervals.minAsLongArray((Interval)interval);
        if (Arrays.stream(min).allMatch(x -> x == 0L)) {
            this.coefficients = coefficientFactory.create((Dimensions)interval);
        } else {
            Img coefficientsBase = coefficientFactory.create((Dimensions)interval);
            this.coefficients = Views.translate((RandomAccessibleInterval)coefficientsBase, (long[])min);
        }
        decomp.accept(this.coefficients);
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, boolean clipping, S coefficientType) {
        this(img, interval, order, clipping, (ImgFactory<S>)Util.getSuitableImgFactory((Dimensions)interval, coefficientType), (OutOfBoundsFactory<RealType<?>, ?>)new OutOfBoundsConstantValueFactory(Util.getTypeFromInterval((Interval)Views.interval(img, (Interval)interval))));
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order, boolean clipping) {
        this(img, interval, order, clipping, new DoubleType());
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval, int order) {
        this(img, interval, order, true, new DoubleType());
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessible<T> img, Interval interval) {
        this(img, interval, 3, true, new DoubleType());
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img) {
        this((RandomAccessible<T>)img, (Interval)img, 3, true, new DoubleType());
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int order, boolean clipping, S coefficientType) {
        this((RandomAccessible<T>)img, (Interval)img, order, clipping, (ImgFactory<S>)Util.getSuitableImgFactory(img, coefficientType), (OutOfBoundsFactory<RealType<?>, ?>)new OutOfBoundsConstantValueFactory(Util.getTypeFromInterval(img)));
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int order, boolean clipping) {
        this((RandomAccessible<T>)img, (Interval)img, order, clipping, new DoubleType());
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessibleInterval<T> img, int order) {
        this((RandomAccessible<T>)img, (Interval)img, order, true, new DoubleType());
    }

    public BSplineCoefficientsInterpolatorFactory(RandomAccessibleInterval<S> coefficients, int order, boolean clipping, OutOfBoundsFactory<? extends RealType<?>, ?> oobFactory) {
        this.order = order;
        this.clipping = clipping;
        this.coefficients = coefficients;
        this.oobFactory = oobFactory;
    }

    public BSplineCoefficientsInterpolator<S> create(RandomAccessible<T> f) {
        ExtendedRandomAccessibleInterval coefExt = Views.extend(this.coefficients, this.oobFactory);
        RealType type = (RealType)this.coefficients.getType();
        if (this.order % 2 == 0) {
            return new BSplineCoefficientsInterpolatorEven<RealType>(this.order, (RandomAccessible<RealType>)coefExt, (RealType)type.createVariable());
        }
        return new BSplineCoefficientsInterpolatorOdd<RealType>(this.order, (RandomAccessible<RealType>)coefExt, (RealType)type.createVariable());
    }

    public RealRandomAccess<S> create(RandomAccessible<T> f, RealInterval interval) {
        return this.create(f);
    }
}

