/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import java.util.Collection;
import java.util.function.Function;
import org.scijava.collections.ObjectArray;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;

public class PrimitiveArrayConverters<N extends Number>
implements OpCollection {
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<N[], ObjectArray<Number>> fromNumber = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((Number[])arr).length);
        for (int i = 0; i < ((Number[])arr).length; ++i) {
            oa.set(i, arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<byte[], ObjectArray<Number>> fromPrimitiveByte = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((byte[])arr).length);
        for (int i = 0; i < ((byte[])arr).length; ++i) {
            oa.set(i, arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<short[], ObjectArray<Number>> fromPrimitiveShort = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((short[])arr).length);
        for (int i = 0; i < ((short[])arr).length; ++i) {
            oa.set(i, arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<int[], ObjectArray<Number>> fromPrimitiveInt = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((int[])arr).length);
        for (int i = 0; i < ((int[])arr).length; ++i) {
            oa.set(i, arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<long[], ObjectArray<Number>> fromPrimitiveLong = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((long[])arr).length);
        for (int i = 0; i < ((long[])arr).length; ++i) {
            oa.set(i, arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<float[], ObjectArray<Number>> fromPrimitiveFloat = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((float[])arr).length);
        for (int i = 0; i < ((float[])arr).length; ++i) {
            oa.set(i, Float.valueOf(arr[i]));
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<double[], ObjectArray<Number>> fromPrimitiveDouble = arr -> {
        ObjectArray<Number> oa = new ObjectArray<Number>(Number.class, ((double[])arr).length);
        for (int i = 0; i < ((double[])arr).length; ++i) {
            oa.set(i, arr[i]);
        }
        return oa;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, Byte[]> toByte = o -> (Byte[])o.stream().map(b -> b == null ? null : Byte.valueOf(b.byteValue())).toArray(Byte[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, Integer[]> toInteger = o -> (Integer[])o.stream().map(i -> i == null ? null : Integer.valueOf(i.intValue())).toArray(Integer[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, Short[]> toShort = o -> (Short[])o.stream().map(s -> s == null ? null : Short.valueOf(s.shortValue())).toArray(Short[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, Long[]> toLong = o -> (Long[])o.stream().map(l -> l == null ? null : Long.valueOf(l.longValue())).toArray(Long[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, Float[]> toFloat = o -> (Float[])o.stream().map(f -> f == null ? null : Float.valueOf(f.floatValue())).toArray(Float[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, Double[]> toDouble = o -> (Double[])o.stream().map(d -> d == null ? null : Double.valueOf(d.doubleValue())).toArray(Double[]::new);
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, byte[]> toPrimitiveByte = o -> {
        byte[] arr = new byte[o.size()];
        int i = 0;
        for (Number num : o) {
            arr[i++] = num.byteValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, short[]> toPrimitiveShort = o -> {
        short[] arr = new short[o.size()];
        int i = 0;
        for (Number num : o) {
            arr[i++] = num.shortValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, int[]> toPrimitiveInt = o -> {
        int[] arr = new int[o.size()];
        int i = 0;
        for (Number num : o) {
            arr[i++] = num.intValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, long[]> toPrimitiveLong = o -> {
        long[] arr = new long[o.size()];
        int i = 0;
        for (Number num : o) {
            arr[i++] = num.longValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, float[]> toPrimitiveFloat = o -> {
        float[] arr = new float[o.size()];
        int i = 0;
        for (Number num : o) {
            arr[i++] = num.floatValue();
        }
        return arr;
    };
    @OpHints(hints={"conversion.FORBIDDEN"})
    @OpField(names="engine.convert")
    public final Function<Collection<Number>, double[]> toPrimitiveDouble = o -> {
        double[] arr = new double[o.size()];
        int i = 0;
        for (Number num : o) {
            arr[i++] = num.doubleValue();
        }
        return arr;
    };
}

