/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.math;

import java.util.function.BiFunction;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class Power
implements OpCollection {
    public static final String NAMES = "math.pow, math.power";
    @OpField(names="math.pow, math.power", params={"number, exponent, result"})
    public static final BiFunction<Double, Double, Double> MathPowerDoubleFunction = (base, exp) -> Math.pow(base, exp);
    @OpField(names="math.pow, math.power", params={"array, power, resultArray"})
    public static final Computers.Arity2<double[], Double, double[]> MathPointwisePowerDoubleArrayComputer = (in, pow, out) -> {
        for (int i = 0; i < ((double[])in).length; ++i) {
            out[i] = Math.pow(in[i], pow);
        }
    };
}

