/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.scijava.common3.Classes;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.exceptions.impl.FunctionalTypeOpException;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.engine.util.Lambdas;
import org.scijava.ops.spi.OpDependency;
import org.scijava.struct.Member;
import org.scijava.struct.StructInstance;
import org.scijava.types.infer.FunctionalInterfaces;
import org.scijava.types.infer.GenericAssignability;

public final class OpMethodUtils {
    private OpMethodUtils() {
    }

    public static Type getOpMethodType(Class<?> opClass, Method opMethod) {
        Method abstractMethod;
        try {
            abstractMethod = FunctionalInterfaces.functionalMethodOf(opClass);
        }
        catch (IllegalArgumentException e) {
            throw new FunctionalTypeOpException((Object)opMethod, (Throwable)e);
        }
        Type[] typeMethodParams = abstractMethod.getGenericParameterTypes();
        Parameter[] opMethodParams = OpMethodUtils.getOpParams(opMethod.getParameters());
        if (typeMethodParams.length != opMethodParams.length) {
            throw new FunctionalTypeOpException((Object)opMethod, opClass);
        }
        HashMap typeVarAssigns = new HashMap();
        GenericAssignability.inferTypeVariables((Type[])typeMethodParams, (Type[])OpMethodUtils.getOpParamTypes(opMethodParams), typeVarAssigns);
        if (abstractMethod.getReturnType() != Void.TYPE) {
            Type returnType = opMethod.getGenericReturnType();
            if (Types.raw((Type)returnType).isPrimitive()) {
                returnType = Classes.box((Class)Types.raw((Type)returnType));
            }
            GenericAssignability.inferTypeVariables((Type[])new Type[]{abstractMethod.getGenericReturnType()}, (Type[])new Type[]{returnType}, typeVarAssigns);
        }
        return Types.parameterize(opClass, typeVarAssigns);
    }

    public static Parameter[] getOpParams(Parameter[] methodParams) {
        return (Parameter[])Arrays.stream(methodParams).filter(param -> param.getAnnotation(OpDependency.class) == null).toArray(Parameter[]::new);
    }

    public static Type[] getOpParamTypes(Parameter[] methodParams) {
        return (Type[])Arrays.stream(methodParams).filter(param -> param.getAnnotation(OpDependency.class) == null).map(Parameter::getParameterizedType).map(param -> Types.raw((Type)param).isPrimitive() ? Classes.box((Class)Types.raw((Type)param)) : param).toArray(Type[]::new);
    }

    public static StructInstance<?> createOpInstance(OpInfo info, Method method, List<?> dependencies) {
        Module methodModule = method.getDeclaringClass().getModule();
        Module opsEngine = OpMethodUtils.class.getModule();
        opsEngine.addReads(methodModule);
        try {
            method.setAccessible(true);
            MethodHandle handle = MethodHandles.lookup().unreflect(method);
            Object op = Lambdas.lambdaize(Types.raw((Type)info.opType()), handle, (Class[])Infos.dependencies(info).stream().map(Member::rawType).toArray(Class[]::new), dependencies.toArray());
            return info.struct().createInstance(op);
        }
        catch (Throwable exc) {
            throw new IllegalStateException("Failed to invoke Op method: " + method, exc);
        }
    }
}

