/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.fits;

import net.imglib2.RandomAccessibleInterval;
import org.janelia.thickness.inference.fits.AbstractCorrelationFit;
import org.janelia.thickness.inference.fits.GlobalCorrelationFitAverage;

public class GlobalCorrelationFitAverageRegularized
extends AbstractCorrelationFit {
    private double[] reg;
    private final double lambda;
    private final GlobalCorrelationFitAverage fit = new GlobalCorrelationFitAverage();

    public GlobalCorrelationFitAverageRegularized(double[] reg, double lambda) {
        this.reg = reg;
        this.lambda = lambda;
    }

    @Override
    protected void add(int z, int dz, double value, double weight) {
        this.fit.add(z, dz, value, weight);
    }

    @Override
    protected void init(int size) {
        this.fit.init(size);
    }

    @Override
    protected RandomAccessibleInterval<double[]> estimate(int size) {
        RandomAccessibleInterval<double[]> rai = this.fit.estimate(size);
        double oneMinusLambda = 1.0 - this.lambda;
        double[] current = (double[])rai.randomAccess().get();
        for (int i = 0; i < Math.min(current.length, this.reg.length); ++i) {
            double v1 = current[i];
            double v2 = this.reg[i];
            current[i] = Double.isNaN(v1) ? v2 : (Double.isNaN(v2) ? v1 : oneMinusLambda * v1 + this.lambda * v2);
        }
        this.reg = current;
        return rai;
    }
}

