/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ops.flim.FitResults;

public class AmplitudeFractions {
    public static Img<FloatType> defaultAmplitudeFraction(FitResults rslt, int index) {
        Img<FloatType> paramMap = rslt.paramMap;
        int nComp = (int)(paramMap.dimension(rslt.ltAxis) - 1L) / 2;
        long[] dim = new long[paramMap.numDimensions() - 1];
        Views.hyperSlice(paramMap, (int)rslt.ltAxis, (long)0L).dimensions(dim);
        ArrayImg APercent = ArrayImgs.floats((long[])dim);
        ArrayImg ASum = ArrayImgs.floats((long[])dim);
        for (int c = 0; c < nComp; ++c) {
            LoopBuilder.setImages((RandomAccessibleInterval)ASum, AmplitudeFractions.getSlice(rslt, c * 2 + 1)).forEachPixel(FloatType::add);
        }
        FloatType f = new FloatType();
        f.setReal(Float.MIN_VALUE);
        LoopBuilder.setImages((RandomAccessibleInterval)ASum, (RandomAccessibleInterval)APercent, AmplitudeFractions.getSlice(rslt, index * 2 + 1)).forEachPixel((aS, aP, s) -> {
            aP.set(s);
            aP.div(aS);
        });
        return APercent;
    }

    private static IntervalView<FloatType> getSlice(FitResults rslt, int index) {
        return Views.hyperSlice(rslt.paramMap, (int)rslt.ltAxis, (long)index);
    }
}

