/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.reflect.TypeToken;
import flimlib.FitFunc;
import flimlib.NoiseType;
import flimlib.RestrainType;
import java.util.Arrays;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.RealMask;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class FitParams<I extends RealType<I>> {
    @Expose
    public static final int UNINIT = -1;
    @Expose
    public float xInc = -1.0f;
    public float[] trans;
    @Expose
    public int ltAxis = -1;
    public RandomAccessibleInterval<I> transMap;
    public RealMask roiMask;
    @Expose
    public int fitStart = -1;
    @Expose
    public int fitEnd = -1;
    @Expose
    public float[] instr;
    @Expose
    public NoiseType noise = NoiseType.NOISE_POISSON_FIT;
    @Expose
    public float[] sig;
    @Expose
    public int nComp = 1;
    @Expose
    public float[] param;
    public RandomAccessibleInterval<FloatType> paramMap;
    @Expose
    public boolean[] paramFree;
    @Expose
    public RestrainType restrain = RestrainType.ECF_RESTRAIN_DEFAULT;
    @Expose
    public float[] restraintMin;
    @Expose
    public float[] restraintMax;
    @Expose
    public FitFunc fitFunc = FitFunc.GCI_MULTIEXP_TAU;
    @Expose
    public float chisq_target = 1.0f;
    @Expose
    public float chisq_delta = 1.0E-4f;
    @Expose
    public int chisq_percent = 95;
    @Expose
    public float iThresh = 0.0f;
    @Expose
    public float iThreshPercent = 0.0f;
    @Expose
    public boolean multithread = true;
    @Expose
    public boolean dropBad = true;
    @Expose
    public boolean getReturnCodeMap = false;
    @Expose
    public boolean getParamMap = true;
    @Expose
    public boolean getFittedMap = false;
    @Expose
    public boolean getResidualsMap = false;
    @Expose
    public boolean getChisqMap = false;

    public FitParams<I> copy() {
        FitParams<I> newParams = new FitParams<I>();
        newParams.xInc = this.xInc;
        newParams.trans = this.trans;
        newParams.ltAxis = this.ltAxis;
        newParams.transMap = this.transMap;
        newParams.roiMask = this.roiMask;
        newParams.fitStart = this.fitStart;
        newParams.fitEnd = this.fitEnd;
        newParams.instr = this.instr;
        newParams.noise = this.noise;
        newParams.sig = this.sig;
        newParams.nComp = this.nComp;
        newParams.param = this.param;
        newParams.paramMap = this.paramMap;
        newParams.paramFree = this.paramFree;
        newParams.restrain = this.restrain;
        newParams.restraintMin = this.restraintMin;
        newParams.restraintMax = this.restraintMax;
        newParams.fitFunc = this.fitFunc;
        newParams.chisq_target = this.chisq_target;
        newParams.chisq_delta = this.chisq_delta;
        newParams.chisq_percent = this.chisq_percent;
        newParams.iThresh = this.iThresh;
        newParams.iThreshPercent = this.iThreshPercent;
        newParams.multithread = this.multithread;
        newParams.dropBad = this.dropBad;
        newParams.getParamMap = this.getParamMap;
        newParams.getFittedMap = this.getFittedMap;
        newParams.getResidualsMap = this.getResidualsMap;
        newParams.getChisqMap = this.getChisqMap;
        newParams.getReturnCodeMap = this.getReturnCodeMap;
        return newParams;
    }

    public String toJSON() {
        JsonSerializer fitFuncSerializer = (elem, type, ctx) -> {
            String name;
            if (elem.equals(FitFunc.GCI_MULTIEXP_LAMBDA)) {
                name = "GCI_MULTIEXP_LAMBDA";
            } else if (elem.equals(FitFunc.GCI_MULTIEXP_TAU)) {
                name = "GCI_MULTIEXP_TAU";
            } else if (elem.equals(FitFunc.GCI_STRETCHEDEXP)) {
                name = "GCI_STRETCHEDEXP";
            } else {
                throw new IllegalArgumentException("Cannot serialize custom fitFunc: " + this.fitFunc);
            }
            return new JsonPrimitive(name);
        };
        Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(FitFunc.class, (Object)fitFuncSerializer).setPrettyPrinting().create();
        return gson.toJson((Object)this);
    }

    public static <I extends RealType<I>> FitParams<I> fromJSON(String jsonString) {
        JsonDeserializer fitfuncDeserializer = (elem, type, ctx) -> {
            switch (elem.getAsString()) {
                case "GCI_MULTIEXP_LAMBDA": {
                    return FitFunc.GCI_MULTIEXP_LAMBDA;
                }
                case "GCI_MULTIEXP_TAU": {
                    return FitFunc.GCI_MULTIEXP_TAU;
                }
                case "GCI_STRETCHEDEXP": {
                    return FitFunc.GCI_STRETCHEDEXP;
                }
            }
            throw new IllegalArgumentException("Unrecognized fitFunc: " + elem.getAsString());
        };
        Gson gson = new GsonBuilder().registerTypeAdapter(FitFunc.class, (Object)fitfuncDeserializer).create();
        return (FitParams)gson.fromJson(jsonString, new TypeToken<FitParams<I>>(){}.getType());
    }

    public String toString() {
        String str = String.format("xInc: %f, interval: [%d, %d), intensity threshold: %f, instr: %s, noise: %s, sig: %s, param: %s, paramFree: %s, restrain: %s, fitFunc: %s, chisq_target: %f, chisq_delta: %f, chisq_percent: %d", Float.valueOf(this.xInc), this.fitStart, this.fitEnd, Float.valueOf(this.iThresh), Arrays.toString(this.instr), this.noise.name(), Arrays.toString(this.sig), Arrays.toString(this.param), Arrays.toString(this.paramFree), this.restrain.name(), this.fitFunc, Float.valueOf(this.chisq_target), Float.valueOf(this.chisq_delta), this.chisq_percent);
        return str;
    }
}

