/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.imglib2.type.numeric.RealType;
import org.scijava.concurrent.Parallelization;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.impl.AbstractFitWorker;
import org.scijava.ops.flim.util.RAHelper;

public abstract class AbstractSingleFitWorker<I extends RealType<I>>
extends AbstractFitWorker<I> {
    protected final float[] paramBuffer;
    protected final float[] transBuffer;
    protected final float[] chisqBuffer;
    protected final float[] fittedBuffer;
    protected final float[] residualBuffer;

    public AbstractSingleFitWorker(FitParams<I> params, FitResults results) {
        super(params, results);
        if (results.param == null || results.param.length != this.nParam) {
            results.param = new float[this.nParam];
        }
        if (params.trans == null || params.trans.length != this.nDataTotal) {
            params.trans = new float[this.nDataTotal];
        }
        this.paramBuffer = results.param;
        this.transBuffer = params.trans;
        this.chisqBuffer = new float[1];
        if (results.fitted == null || results.fitted.length != this.nDataTotal) {
            results.fitted = new float[this.nDataTotal];
        }
        if (results.residuals == null || results.residuals.length != this.nDataTotal) {
            results.residuals = new float[this.nDataTotal];
        }
        this.fittedBuffer = results.fitted;
        this.residualBuffer = results.residuals;
    }

    protected void beforeFit() {
        this.chisqBuffer[0] = -1.0f;
    }

    protected abstract void doFit();

    protected void afterFit() {
        this.results.chisq = this.chisqBuffer[0] / (float)(this.nData - this.nParam);
    }

    public void fitSingle() {
        this.beforeFit();
        this.doFit();
        this.afterFit();
    }

    protected abstract AbstractSingleFitWorker<I> duplicate(FitParams<I> var1, FitResults var2);

    protected void onThreadInit() {
    }

    protected boolean runMultiThreaded() {
        return this.params.multithread;
    }

    @Override
    public void fitBatch(List<int[]> pos, FitWorker.FitEventHandler<I> handler) {
        AbstractSingleFitWorker thisWorker = this;
        Consumer<int[]> worker = data -> {
            AbstractSingleFitWorker fitWorker;
            FitResults lResults;
            FitParams lParams;
            int start = data[0];
            int size = data[1];
            if (!this.runMultiThreaded()) {
                if (start != 0) {
                    return;
                }
                size = pos.size();
            }
            if (!this.runMultiThreaded() || pos.size() == 1) {
                lParams = this.params;
                lResults = this.results;
                fitWorker = thisWorker;
            } else {
                lParams = this.params.copy();
                lResults = this.results.copy();
                lResults.residuals = null;
                lResults.fitted = null;
                lResults.param = null;
                lParams.trans = null;
                lParams.param = null;
                fitWorker = this.duplicate(lParams, lResults);
            }
            fitWorker.onThreadInit();
            RAHelper helper = new RAHelper(this.params, this.results);
            for (int i = start; i < start + size; ++i) {
                int[] xytPos = (int[])pos.get(i);
                if (!helper.loadData(fitWorker.transBuffer, fitWorker.paramBuffer, this.params, xytPos)) {
                    lResults.retCode = -4;
                } else {
                    fitWorker.fitSingle();
                    float chisq = lResults.chisq;
                    if (this.params.dropBad && lResults.retCode == 0 && (chisq < 0.0f || (double)chisq > 100000.0 || Float.isNaN(chisq))) {
                        lResults.retCode = -2;
                    }
                }
                helper.commitRslts(lParams, lResults, xytPos);
                if (handler == null) continue;
                handler.onSingleComplete(xytPos, this.params, this.results);
            }
        };
        int n = Parallelization.getTaskExecutor().suggestNumberOfTasks();
        int s = pos.size() / n;
        int r = pos.size() % n;
        ArrayList<int[]> list = new ArrayList<int[]>(n);
        int start = 0;
        int size = s + 1;
        for (int i = 0; i < n; ++i) {
            if (i == r) {
                // empty if block
            }
            list.add(new int[]{start, --size});
            start += size;
        }
        Parallelization.getTaskExecutor().forEach(list, worker);
        if (handler != null) {
            handler.onComplete(this.params, this.results);
        }
    }
}

