/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import flimlib.FLIMLib;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ops.flim.AbstractFitRAI;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.impl.AbstractSingleFitWorker;
import org.scijava.ops.spi.OpDependency;

public class BayesFit {

    public static class BayesFitWorker<I extends RealType<I>>
    extends AbstractSingleFitWorker<I> {
        private final float[] error;
        private final float[] minusLogProb;
        private final int[] nPhotons;
        private final Function<FitParams<I>, FitResults> rldFitter;
        private final BiFunction<Img<FloatType>, Integer, FloatType> percentileOp;
        private float laserPeriod;
        private float[] gridMin;
        private float[] gridMax;

        public BayesFitWorker(FitParams<I> params, FitResults results, Function<FitParams<I>, FitResults> rldFitter, BiFunction<Img<FloatType>, Integer, FloatType> percentileOp) {
            super(params, results);
            this.rldFitter = rldFitter;
            this.percentileOp = percentileOp;
            if (this.nParam != 3) {
                throw new IllegalArgumentException("Bayesian analysis is currently single-component (3 parameters) only");
            }
            this.error = new float[this.nParam];
            this.minusLogProb = new float[1];
            this.nPhotons = new int[1];
            if (this.gridMin == null || this.gridMax == null) {
                this.estimateGrid();
            }
        }

        private void estimateGrid() {
            this.gridMin = new float[this.nParam];
            this.gridMax = new float[this.nParam];
            FitParams copyParams = this.params.copy();
            copyParams.getChisqMap = true;
            copyParams.param = null;
            FitResults estResults = this.rldFitter.apply(this.params);
            Img<FloatType> paramMap = estResults.paramMap;
            Img<FloatType> chisqMap = estResults.chisqMap;
            float chisqCutoff = this.percentileOp.apply(chisqMap, 20).getRealFloat();
            int i = 0;
            while ((long)i <= paramMap.max(this.params.ltAxis)) {
                double mean = 0.0;
                double std = 0.0;
                double count = 0.0;
                IntervalView paramPlane = Views.hyperSlice(paramMap, (int)this.params.ltAxis, (long)i);
                Cursor ppCursor = paramPlane.cursor();
                Cursor xmCursor = chisqMap.cursor();
                while (ppCursor.hasNext()) {
                    float pf = ((FloatType)ppCursor.next()).getRealFloat();
                    float xf = ((FloatType)xmCursor.next()).getRealFloat();
                    if (!(xf <= chisqCutoff) || !Float.isFinite(pf)) continue;
                    mean += (double)pf;
                    std += (double)(pf * pf);
                    count += 1.0;
                }
                std /= count;
                double tauStdCompensation = i == 2 || i == 4 ? 10.0 : 0.0;
                std = Math.sqrt(std - (mean /= count) * mean + tauStdCompensation);
                this.gridMin[i] = 0.0f;
                this.gridMax[i] = (float)Math.max(mean + std * 2.0, 0.0);
                ++i;
            }
        }

        @Override
        protected void beforeFit() {
            super.beforeFit();
            this.laserPeriod = this.params.xInc * (float)(this.adjFitEnd - this.adjFitStart);
        }

        @Override
        public void doFit() {
            int retCode = FLIMLib.Bayes_fitting_engine((float)this.params.xInc, (float[])this.transBuffer, (int)this.adjFitStart, (int)this.adjFitEnd, (float)this.laserPeriod, (float[])this.params.instr, (float[])this.paramBuffer, (boolean[])this.params.paramFree, (float[])this.fittedBuffer, (float[])this.residualBuffer, (float[])this.error, (float[])this.minusLogProb, (int[])this.nPhotons, (float[])this.chisqBuffer);
            switch (retCode) {
                case -14: 
                case -8: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    this.results.retCode = -3;
                    break;
                }
                case -99: 
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -7: {
                    this.results.retCode = -1;
                    break;
                }
                default: {
                    this.results.retCode = retCode >= 0 ? 0 : -6;
                }
            }
        }

        @Override
        protected void onThreadInit() {
            FLIMLib.Bayes_set_search_grid((float[])this.gridMin, (float[])this.gridMax);
        }

        @Override
        protected AbstractSingleFitWorker<I> duplicate(FitParams<I> params, FitResults rslts) {
            BayesFitWorker<I> child = new BayesFitWorker<I>(params, rslts, this.rldFitter, this.percentileOp);
            child.gridMin = this.gridMin;
            child.gridMax = this.gridMax;
            return child;
        }

        @Override
        protected boolean runMultiThreaded() {
            return false;
        }
    }

    public static class BayesSingleFitRAI<I extends RealType<I>, K extends RealType<K>>
    extends AbstractFitRAI<I, K> {
        @OpDependency(name="flim.fitRLD")
        private Function<FitParams<I>, FitResults> rldFitter;
        @OpDependency(name="stats.percentile")
        private BiFunction<Img<FloatType>, Integer, FloatType> percentileOp;

        @Override
        public FitWorker<I> createWorker(FitParams<I> params, FitResults results) {
            return new BayesFitWorker<I>(params, results, this.rldFitter, this.percentileOp);
        }
    }
}

