/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.flim.impl;

import flimlib.FLIMLib;
import flimlib.FitType;
import flimlib.Float2DMatrix;
import flimlib.NoiseType;
import flimlib.RestrainType;
import java.util.List;
import net.imglib2.type.numeric.RealType;
import org.scijava.ops.flim.AbstractFitRAI;
import org.scijava.ops.flim.FitParams;
import org.scijava.ops.flim.FitResults;
import org.scijava.ops.flim.FitWorker;
import org.scijava.ops.flim.impl.AbstractFitWorker;
import org.scijava.ops.flim.util.RAHelper;

public class GlobalFit {

    public static class GlobalFitWorker<I extends RealType<I>>
    extends AbstractFitWorker<I> {
        public GlobalFitWorker(FitParams<I> params, FitResults results) {
            super(params, results);
        }

        @Override
        public void fitBatch(List<int[]> pos, FitWorker.FitEventHandler<I> handler) {
            int nTrans = pos.size();
            float[][] trans = new float[nTrans][this.nDataTotal];
            float[][] param = new float[nTrans][this.nParam];
            boolean[] transSkipped = new boolean[nTrans];
            RAHelper helper = new RAHelper(this.params, this.results);
            for (int i = 0; i < nTrans; ++i) {
                transSkipped[i] = !helper.loadData(trans[i], param[i], this.params, pos.get(i));
            }
            Float2DMatrix transMat = new Float2DMatrix(trans);
            Float2DMatrix paramMat = new Float2DMatrix(param);
            Float2DMatrix fittedMat = new Float2DMatrix(1, this.nDataTotal);
            Float2DMatrix residualMat = new Float2DMatrix(1, this.nDataTotal);
            float[] chisq = new float[nTrans];
            float[] chisqGlobal = new float[1];
            int[] df = new int[1];
            int retCode = FLIMLib.GCI_marquardt_global_exps_instr((float)this.params.xInc, (Float2DMatrix)transMat, (int)this.adjFitStart, (int)this.adjFitEnd, (float[])this.params.instr, (NoiseType)this.params.noise, (float[])this.params.sig, (FitType)FitType.FIT_GLOBAL_MULTIEXP, (Float2DMatrix)paramMat, (boolean[])this.params.paramFree, (RestrainType)this.params.restrain, (float)this.params.chisq_delta, (Float2DMatrix)fittedMat, (Float2DMatrix)residualMat, (float[])chisq, (float[])chisqGlobal, (int[])df, (int)(this.params.dropBad ? 1 : 0));
            float[][] fittedParam = this.params.getParamMap ? paramMat.asArray() : null;
            float[][] fitted = this.params.getFittedMap ? fittedMat.asArray() : null;
            float[][] residual = this.params.getResidualsMap ? residualMat.asArray() : null;
            for (int i = 0; i < nTrans; ++i) {
                this.results.param = this.params.getParamMap ? fittedParam[i] : null;
                this.results.fitted = this.params.getFittedMap ? fitted[i] : null;
                this.results.residuals = this.params.getResidualsMap ? residual[i] : null;
                this.results.chisq = chisq[i];
                int n = this.results.retCode = transSkipped[i] ? -4 : this.convertRetCode(retCode);
                if (this.params.dropBad && this.results.retCode == 0) {
                    if (this.results.chisq < 0.0f) {
                        this.results.retCode = -1;
                    } else if (Float.isNaN(this.results.chisq) || (double)this.results.chisq > 100000.0) {
                        this.results.retCode = -2;
                    }
                }
                helper.commitRslts(this.params, this.results, pos.get(i));
            }
            this.results.chisq = chisqGlobal[0];
            if (handler != null) {
                handler.onComplete(this.params, this.results);
            }
        }

        private int convertRetCode(int retCode) {
            int convertedretCode;
            switch (retCode) {
                case -32: 
                case -31: 
                case -22: 
                case -21: 
                case -12: 
                case -1: {
                    convertedretCode = -3;
                    break;
                }
                case -11: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    convertedretCode = -5;
                    break;
                }
                case -13: {
                    convertedretCode = -1;
                    break;
                }
                default: {
                    convertedretCode = retCode >= 0 ? 0 : -6;
                }
            }
            return convertedretCode;
        }
    }

    public static class GlobalSingleFitRAI<I extends RealType<I>, K extends RealType<K>>
    extends AbstractFitRAI<I, K> {
        @Override
        public FitWorker<I> createWorker(FitParams<I> params, FitResults results) {
            return new GlobalFitWorker<I>(params, results);
        }
    }
}

