/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.Filter;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Filter.class)
public class MinMaxFilter
extends AbstractReaderFilter {
    private List<Map<AxisType, double[]>> planarAxisMin;
    private List<Map<AxisType, double[]>> planarAxisMax;
    private double[][] planeMins;
    private double[][] planeMaxs;
    private int[] minMaxDone;

    public Double getAxisGlobalMinimum(int imageIndex, AxisType type, int index) throws FormatException {
        return this.getAxisGlobalValue(imageIndex, type, index, this.planarAxisMin);
    }

    public Double getAxisGlobalMaximum(int imageIndex, AxisType type, int index) throws FormatException {
        return this.getAxisGlobalValue(imageIndex, type, index, this.planarAxisMax);
    }

    public Double getAxisKnownMinimum(int imageIndex, AxisType type, int index) {
        return this.getAxisKnownValue(imageIndex, type, index, this.planarAxisMin);
    }

    public Double getAxisKnownMaximum(int imageIndex, AxisType type, int index) {
        return this.getAxisKnownValue(imageIndex, type, index, this.planarAxisMax);
    }

    public Double getPlaneMinimum(int imageIndex, long planeIndex) {
        return this.getPlaneValue(imageIndex, planeIndex, this.planeMins);
    }

    public Double getPlaneMaximum(int imageIndex, long planeIndex) {
        return this.getPlaneValue(imageIndex, planeIndex, this.planeMaxs);
    }

    public boolean isMinMaxPopulated(int imageIndex) {
        return this.minMaxDone != null && this.minMaxDone[imageIndex] == this.getImageCount();
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return this.getMetadata().get(imageIndex).getPlaneCount();
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        FinalInterval bounds = new FinalInterval(this.getMetadata().get(imageIndex).getAxesLengthsPlanar());
        return this.openPlane(imageIndex, planeIndex, (Interval)bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        FinalInterval bounds = new FinalInterval(this.getMetadata().get(imageIndex).getAxesLengthsPlanar());
        return this.openPlane(imageIndex, planeIndex, plane, (Interval)bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        Plane plane = this.createPlane(bounds);
        return this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        super.openPlane(imageIndex, planeIndex, plane, bounds, config);
        int bytesPerPixel = FormatTools.getBytesPerPixel(this.getMetadata().get(imageIndex).getPixelType());
        int len = (int)((long)bytesPerPixel * Intervals.numElements((Dimensions)bounds));
        this.updateMinMax(imageIndex, planeIndex, plane.getBytes(), len);
        return plane;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.planarAxisMin = null;
            this.planarAxisMax = null;
            this.planeMins = null;
            this.planeMaxs = null;
            this.minMaxDone = null;
        }
    }

    public Class<?> getNativeDataType() {
        return byte[].class;
    }

    private void updateMinMax(int imageIndex, long planeIndex, byte[] buf, int len) {
        if (buf == null) {
            return;
        }
        this.initMinMax();
        Metadata m = this.getMetadata();
        ImageMetadata iMeta = m.get(imageIndex);
        int pixelType = iMeta.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(pixelType);
        long planeSize = iMeta.getPlaneSize();
        if ((long)len == planeSize && !Double.isNaN(this.planeMins[imageIndex][(int)planeIndex])) {
            return;
        }
        boolean little = iMeta.isLittleEndian();
        int pixels = len / bpp;
        this.planeMins[imageIndex][(int)planeIndex] = Double.POSITIVE_INFINITY;
        this.planeMaxs[imageIndex][(int)planeIndex] = Double.NEGATIVE_INFINITY;
        boolean signed = FormatTools.isSigned(pixelType);
        long threshold = (long)Math.pow(2.0, bpp * 8 - 1);
        for (int i = 0; i < pixels; ++i) {
            int idx = bpp * i;
            long bits = Bytes.toLong((byte[])buf, (int)idx, (int)bpp, (boolean)little);
            if (signed && bits >= threshold) {
                bits -= 2L * threshold;
            }
            double v = bits;
            if (pixelType == 6) {
                v = Float.intBitsToFloat((int)bits);
            } else if (pixelType == 7) {
                v = Double.longBitsToDouble(bits);
            }
            long[] planarPositions = FormatTools.rasterToPosition(iMeta.getAxesLengthsPlanar(), i);
            for (int axis = 0; axis < planarPositions.length; ++axis) {
                double[] planarMax;
                AxisType type = iMeta.getAxis(axis).type();
                double[] planarMin = this.planarAxisMin.get(imageIndex).get(type);
                if (planarMin[(int)planarPositions[axis]] > v) {
                    planarMin[(int)planarPositions[axis]] = v;
                }
                if (!((planarMax = this.planarAxisMax.get(imageIndex).get(type))[(int)planarPositions[axis]] < v)) continue;
                planarMax[(int)planarPositions[axis]] = v;
            }
            if (v > this.planeMaxs[imageIndex][(int)planeIndex]) {
                this.planeMaxs[imageIndex][(int)planeIndex] = v;
            }
            if (!(v < this.planeMins[imageIndex][(int)planeIndex])) continue;
            this.planeMins[imageIndex][(int)planeIndex] = v;
        }
        this.minMaxDone[imageIndex] = Math.max(this.minMaxDone[imageIndex], (int)planeIndex + 1);
    }

    private void initMinMax() {
        double[] values;
        ImageMetadata iMeta;
        int i;
        Metadata m = this.getMetadata();
        int imageCount = m.getImageCount();
        if (this.planarAxisMin == null) {
            this.planarAxisMin = new ArrayList<Map<AxisType, double[]>>();
            for (i = 0; i < imageCount; ++i) {
                HashMap<AxisType, double[]> minMap = new HashMap<AxisType, double[]>();
                iMeta = m.get(i);
                for (CalibratedAxis axis : iMeta.getAxesPlanar()) {
                    values = new double[(int)iMeta.getAxisLength(axis.type())];
                    Arrays.fill(values, Double.POSITIVE_INFINITY);
                    minMap.put(axis.type(), values);
                }
                this.planarAxisMin.add(minMap);
            }
        }
        if (this.planarAxisMax == null) {
            this.planarAxisMax = new ArrayList<Map<AxisType, double[]>>();
            for (i = 0; i < imageCount; ++i) {
                HashMap<AxisType, double[]> maxMap = new HashMap<AxisType, double[]>();
                iMeta = m.get(i);
                for (CalibratedAxis axis : iMeta.getAxesPlanar()) {
                    values = new double[(int)iMeta.getAxisLength(axis.type())];
                    Arrays.fill(values, Double.NEGATIVE_INFINITY);
                    maxMap.put(axis.type(), values);
                }
                this.planarAxisMax.add(maxMap);
            }
        }
        if (this.planeMins == null) {
            this.planeMins = new double[imageCount][];
            for (i = 0; i < imageCount; ++i) {
                this.planeMins[i] = new double[(int)this.getPlaneCount(i)];
                Arrays.fill(this.planeMins[i], Double.NaN);
            }
        }
        if (this.planeMaxs == null) {
            this.planeMaxs = new double[imageCount][];
            for (i = 0; i < imageCount; ++i) {
                this.planeMaxs[i] = new double[(int)this.getPlaneCount(i)];
                Arrays.fill(this.planeMaxs[i], Double.NaN);
            }
        }
        if (this.minMaxDone == null) {
            this.minMaxDone = new int[imageCount];
        }
    }

    private Double getAxisGlobalValue(int imageIndex, AxisType type, int index, List<Map<AxisType, double[]>> planarAxisValues) throws FormatException {
        if (index < 0 || (long)index >= this.getMetadata().get(imageIndex).getAxisLength(type)) {
            throw new FormatException("Invalid " + type.getLabel() + " index: " + index);
        }
        if (this.minMaxDone == null || (long)this.minMaxDone[imageIndex] < this.getPlaneCount(imageIndex)) {
            return null;
        }
        return this.getAxisValue(planarAxisValues.get(imageIndex).get(type), index);
    }

    private Double getAxisKnownValue(int imageIndex, AxisType type, int index, List<Map<AxisType, double[]>> planarAxisValues) {
        return planarAxisValues == null ? null : this.getAxisValue(planarAxisValues.get(imageIndex).get(type), index);
    }

    private Double getAxisValue(double[] values, int index) {
        return values == null ? null : new Double(values[index]);
    }

    private Double getPlaneValue(int imageIndex, long planeIndex, double[][] planeValues) {
        if (planeValues == null) {
            return null;
        }
        if (Double.isNaN(planeValues[imageIndex][(int)planeIndex])) {
            return null;
        }
        return planeValues[imageIndex][(int)planeIndex];
    }
}

