/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.CFF;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Head;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.Loca;
import org.jpedal.fonts.tt.Mapx;
import org.jpedal.fonts.tt.Post;
import org.jpedal.fonts.tt.TTGlyph;

public class TTGlyphs
extends PdfJavaGlyphs {
    protected boolean hasGIDtoCID;
    protected int[] CIDToGIDMap;
    private CMAP currentCMAP;
    private Post currentPost;
    private Glyf currentGlyf;
    private Hmtx currentHmtx;
    private FontFile2 currentFontFile;
    private CFF currentCFF;
    int glyphCount = 0;
    private int unitsPerEm;
    private boolean hasCFF;

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        PdfGlyph pdfGlyph;
        int n2 = n;
        if (this.hasGIDtoCID) {
            n = this.CIDToGIDMap[n];
        }
        if (this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.cachedShapes = null;
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n2)) == null) {
            try {
                pdfGlyph = this.getTTGlyph(string, n, string2, f);
            }
            catch (Exception exception) {
                pdfGlyph = null;
            }
            this.setEmbeddedCachedShape(n2, pdfGlyph);
        }
        return pdfGlyph;
    }

    public PdfGlyph getTTGlyph(String string, int n, String string2, float f) {
        TTGlyph tTGlyph = null;
        try {
            int n2;
            int n3 = n;
            if (this.currentCMAP != null) {
                n3 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted);
            }
            if (n3 < 1) {
                n3 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            if (n3 != -1 && (n2 = this.currentGlyf.getCharString(n3)) != -1) {
                if (this.hasCFF) {
                    System.out.println(n2);
                } else {
                    this.currentFontFile.setPointer(n2);
                    tTGlyph = new TTGlyph(string, false, this.currentGlyf, this.currentFontFile, this.currentHmtx, n3, (float)this.unitsPerEm / 1000.0f);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return tTGlyph;
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
        if (this.currentCMAP != null) {
            this.currentCMAP.setEncodingToUse(bl, n, bl2, bl3);
        }
    }

    public float getTTWidth(String string, int n, String string2, boolean bl) {
        int n2 = n;
        float f = 0.0f;
        try {
            if (!bl) {
                n2 = this.currentCMAP.convertIndexToCharacterCode(string, n, this.remapFont, this.isSubsetted);
            }
            if (n2 < 1) {
                n2 = this.currentPost.convertGlyphToCharacterCode(string);
            }
            f = this.currentHmtx.getWidth(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public void setGIDtoCID(int[] nArray) {
        this.hasGIDtoCID = true;
        this.CIDToGIDMap = nArray;
    }

    public void readEmbeddedFont(boolean bl, byte[] byArray) {
        int n;
        this.currentFontFile = new FontFile2(byArray);
        Head head = new Head(this.currentFontFile);
        this.currentPost = new Post(this.currentFontFile);
        Mapx mapx = new Mapx(this.currentFontFile);
        this.glyphCount = mapx.getGlyphCount();
        Loca loca = new Loca(this.currentFontFile, this.glyphCount, head.getFormat());
        this.currentGlyf = new Glyf(this.currentFontFile, this.glyphCount, loca.getIndices());
        this.currentCFF = new CFF(this.currentFontFile);
        this.hasCFF = this.currentCFF.hasCFFData();
        Hhea hhea = new Hhea(this.currentFontFile);
        int[] nArray = head.getMatrix();
        int n2 = nArray[3];
        this.currentHmtx = new Hmtx(this.currentFontFile, this.glyphCount, hhea.getNumberOfHMetrics(), n2);
        if (!bl && (n = this.currentFontFile.selectTable(2)) != 0) {
            this.currentCMAP = new CMAP(this.currentFontFile, n, this.currentGlyf);
        }
        this.unitsPerEm = head.getUnitsPerEm();
    }
}

