/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.Metadata;
import io.scif.formats.NRRDFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.translators.ToOMETranslator;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.scijava.plugin.Plugin;

public class NRRDTranslator {

    @Plugin(type=ToOMETranslator.class, priority=100.0)
    public static class NRRDOMETranslator
    extends ToOMETranslator<NRRDFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return NRRDFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(NRRDFormat.Metadata source, OMEMetadata dest) {
            String[] pixelSizes = source.getPixelSizes();
            if (pixelSizes != null) {
                for (int i = 0; i < pixelSizes.length; ++i) {
                    if (pixelSizes[i] == null) continue;
                    try {
                        Double d = new Double(pixelSizes[i].trim());
                        if (d > 0.0) {
                            if (i == 0) {
                                dest.getRoot().setPixelsPhysicalSizeX(new Length((Number)d, UNITS.MICROMETER), 0);
                                continue;
                            }
                            if (i == 1) {
                                dest.getRoot().setPixelsPhysicalSizeY(new Length((Number)d, UNITS.MICROMETER), 0);
                                continue;
                            }
                            if (i != 2) continue;
                            dest.getRoot().setPixelsPhysicalSizeZ(new Length((Number)d, UNITS.MICROMETER), 0);
                            continue;
                        }
                        this.log().warn((Object)("Expected positive value for PhysicalSize; got " + d));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

