/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class ShortArray
extends AbstractPrimitiveArray<short[], Short> {
    private short[] array;

    public ShortArray() {
        super(Short.TYPE);
    }

    public ShortArray(int size) {
        super(Short.TYPE, size);
    }

    public ShortArray(short[] array) {
        super(Short.TYPE, array);
    }

    public void addValue(short value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(short value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public short getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public short setValue(int index, short value) {
        this.checkBounds(index);
        short oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, short value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(short value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(short value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public short[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(short[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Short get(int index) {
        return this.getValue(index);
    }

    @Override
    public Short set(int index, Short element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, Short element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Short)) {
            return -1;
        }
        short value = (Short)o;
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Short)) {
            return -1;
        }
        short value = (Short)o;
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Short)) {
            return false;
        }
        short value = (Short)o;
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Short)) {
            return false;
        }
        short value = (Short)o;
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Short)) {
                return false;
            }
            short value = (Short)o;
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Short> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Short> iterator = c.iterator();
        while (iterator.hasNext()) {
            short e = iterator.next();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            short value;
            boolean result;
            if (!(o instanceof Short) || !(result = this.removeValue(value = ((Short)o).shortValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Short defaultValue() {
        return (short)0;
    }
}

