/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TranslationResultPanel {
    private float fontScale = 1.0f;
    private JTextArea original;
    private JTextArea translated;
    private static final int OUTER_PAD = 8;
    private static final int BUTTON_PAD = 3;
    private static final int MID_PAD = 5;
    private final ObjectMapper objMapper;
    private final DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();

    public TranslationResultPanel() {
        DefaultIndenter i = new DefaultIndenter("  ", "\n");
        this.prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)i);
        this.prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)i);
        this.objMapper = new ObjectMapper();
        this.objMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objMapper.setDefaultPrettyPrinter((PrettyPrinter)this.prettyPrinter);
    }

    public JTextArea getOriginal() {
        return this.original;
    }

    public JTextArea getTranslated() {
        return this.translated;
    }

    private String prettyJson(Gson gson, Object obj) {
        String jsonTxt;
        String jsonPretty = jsonTxt = gson.toJson(obj);
        try {
            HashMap tmpObj = (HashMap)this.objMapper.readValue(jsonTxt, HashMap.class);
            jsonPretty = this.objMapper.writer((PrettyPrinter)this.prettyPrinter).writeValueAsString((Object)tmpObj);
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return jsonPretty;
    }

    public void set(Gson gson, Object orig, Object xlated) {
        this.original.setText(this.prettyJson(gson, orig));
        this.translated.setText(this.prettyJson(gson, xlated));
    }

    public JPanel buildPanel() {
        this.original = new JTextArea();
        this.original.setFont(this.original.getFont().deriveFont(this.fontScale * 18.0f));
        this.original.setText("");
        this.translated = new JTextArea();
        this.translated.setFont(this.translated.getFont().deriveFont(this.fontScale * 18.0f));
        this.translated.setText("");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 8, 5, 3);
        gbc.anchor = 21;
        panel.add((Component)new JLabel("Original"), gbc);
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        panel.add((Component)new JScrollPane(this.original), gbc);
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        gbc.anchor = 21;
        panel.add((Component)new JLabel("Translated"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.translated), gbc);
        return panel;
    }
}

