/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.base;

import java.util.HashMap;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.ViewSetupAttributeIo;
import mpicbg.spim.data.generic.base.XmlIoEntity;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;

public class ViewSetupAttributes {
    private static final HashMap<Class<? extends Entity>, String> attributeClass_to_name = new HashMap();
    private static final HashMap<String, String> name_to_XmlIoClassName = new HashMap();
    private static boolean buildWasCalled = false;

    private static void build() {
        buildWasCalled = true;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Index annotationIndex = Index.load(ViewSetupAttributeIo.class, (ClassLoader)classLoader);
            for (IndexItem item : annotationIndex) {
                name_to_XmlIoClassName.put(((ViewSetupAttributeIo)item.annotation()).name(), item.className());
                attributeClass_to_name.put(((ViewSetupAttributeIo)item.annotation()).type(), ((ViewSetupAttributeIo)item.annotation()).name());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("problem accessing annotation index", e);
        }
    }

    public static String getNameForClass(Class<? extends Entity> klass) {
        if (!buildWasCalled) {
            ViewSetupAttributes.build();
        }
        for (Class<? extends Entity> k = klass; k != null && Entity.class.isAssignableFrom(k); k = k.getSuperclass()) {
            String name = attributeClass_to_name.get(k);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public static XmlIoEntity<?> createXmlIoForName(String name) {
        String className;
        if (!buildWasCalled) {
            ViewSetupAttributes.build();
        }
        if ((className = name_to_XmlIoClassName.get(name)) != null) {
            try {
                return (XmlIoEntity)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new XmlIoEntity<Entity>(name, Entity.class);
    }

    public static void registerManually(Class<? extends XmlIoEntity<?>> xmlIoClass) {
        ViewSetupAttributeIo annotation = xmlIoClass.getAnnotation(ViewSetupAttributeIo.class);
        if (annotation != null) {
            String attributeName = annotation.name();
            Class<? extends Entity> attributeClass = annotation.type();
            name_to_XmlIoClassName.put(attributeName, xmlIoClass.getName());
            attributeClass_to_name.put(attributeClass, attributeName);
        }
    }
}

