/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.jogamp.java3d.J3DBuffer;

public abstract class BufferWrapper {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_UNKNOWN = 1;
    public static final int TYPE_BYTE = 2;
    public static final int TYPE_FLOAT = 3;
    public static final int TYPE_DOUBLE = 4;

    abstract Buffer getBuffer();

    public Object getBufferAsObject() {
        return this.getBuffer();
    }

    public int capacity() {
        return this.getBuffer().capacity();
    }

    public int limit() {
        return this.getBuffer().limit();
    }

    public int position() {
        return this.getBuffer().position();
    }

    public BufferWrapper position(int newPosition) {
        this.getBuffer().position(newPosition);
        return this;
    }

    public BufferWrapper rewind() {
        this.getBuffer().rewind();
        return this;
    }

    public static int getBufferType(J3DBuffer b) {
        Buffer buffer = b.getBuffer();
        int bufferType = buffer == null ? 0 : (buffer instanceof ByteBuffer ? 2 : (buffer instanceof FloatBuffer ? 3 : (buffer instanceof DoubleBuffer ? 4 : 1)));
        return bufferType;
    }
}

