/*
 * Decompiled with CFR 0.152.
 */
package bdv;

import bdv.AbstractViewerSetupImgLoader;
import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.VolatileCachedCellImg;
import bdv.img.cache.VolatileGlobalCellCache;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;

public abstract class AbstractCachedViewerSetupImgLoader<T extends NativeType<T>, V extends Volatile<T>, A extends VolatileAccess & DataAccess>
extends AbstractViewerSetupImgLoader<T, V> {
    protected final long[][] dimensions;
    protected final int[][] cellDimensions;
    protected final double[][] resolutions;
    protected final AffineTransform3D[] mipmapTransforms;
    protected VolatileGlobalCellCache cache;
    protected final CacheArrayLoader<A> loader;
    protected final int setupId;

    public AbstractCachedViewerSetupImgLoader(int setupId, long[][] dimensions, int[][] cellDimensions, double[][] resolutions, T type, V vType, CacheArrayLoader<A> loader, VolatileGlobalCellCache cache) {
        super(type, vType);
        this.setupId = setupId;
        this.loader = loader;
        this.cellDimensions = cellDimensions;
        this.dimensions = dimensions;
        this.resolutions = resolutions;
        this.mipmapTransforms = new AffineTransform3D[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            AffineTransform3D mipmapTransform = new AffineTransform3D();
            mipmapTransform.set(resolutions[i][0], 0, 0);
            mipmapTransform.set(resolutions[i][1], 1, 1);
            mipmapTransform.set(resolutions[i][2], 2, 2);
            this.mipmapTransforms[i] = mipmapTransform;
        }
        this.cache = cache;
    }

    public double[][] getMipmapResolutions() {
        return this.resolutions;
    }

    public int numMipmapLevels() {
        return this.resolutions.length;
    }

    protected <S extends NativeType<S>> VolatileCachedCellImg<S, A> prepareCachedImage(int timepointId, int level, LoadingStrategy loadingStrategy, S t) {
        int priority = this.resolutions.length - 1 - level;
        CacheHints cacheHints = new CacheHints(loadingStrategy, priority, false);
        CellGrid grid = new CellGrid(this.dimensions[level], this.cellDimensions[level]);
        return this.cache.createImg(grid, timepointId, this.setupId, level, cacheHints, this.loader, t);
    }

    public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.prepareCachedImage(timepointId, level, LoadingStrategy.BLOCKING, (NativeType)this.type);
    }

    @Override
    public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.prepareCachedImage(timepointId, level, LoadingStrategy.VOLATILE, (NativeType)this.volatileType);
    }

    public AffineTransform3D[] getMipmapTransforms() {
        return this.mipmapTransforms;
    }
}

