/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import bdv.tools.boundingbox.RenderBoxHelper;
import bdv.tools.boundingbox.TransformedBox;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.TransformListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.listeners.ChangeListener;
import org.scijava.listeners.ListenableVar;

public class TransformedBoxOverlay
implements OverlayRenderer,
TransformListener<AffineTransform3D> {
    private static final double DISTANCE_TOLERANCE = 20.0;
    private static final double HANDLE_RADIUS = 10.0;
    private final TransformedBox bbSource;
    private final Color backColor = new Color(0x994499);
    private final Color frontColor = Color.GREEN;
    private final Stroke normalStroke = new BasicStroke();
    private final Stroke intersectionStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
    private final Color intersectionColor = Color.WHITE.darker();
    private Color intersectionFillColor = new Color(-2003221351, true);
    private final AffineTransform3D viewerTransform;
    private final AffineTransform3D transform;
    final RenderBoxHelper renderBoxHelper;
    private final CornerHighlighter cornerHighlighter;
    private double sourceSize = 5000.0;
    private double perspective = 0.5;
    private int canvasWidth;
    private int canvasHeight;
    private final ListenableVar<BoxDisplayMode, ChangeListener> displayMode = ListenableVar.create((Object)((Object)BoxDisplayMode.FULL));
    private boolean showCornerHandles = true;
    private boolean fillIntersection = true;
    private int cornerId = -1;
    private HighlightedCornerListener highlightedCornerListener;

    public TransformedBoxOverlay(final Interval interval) {
        this(new TransformedBox(){

            public Interval getInterval() {
                return interval;
            }

            @Override
            public void getTransform(AffineTransform3D transform) {
                transform.identity();
            }
        });
    }

    public TransformedBoxOverlay(TransformedBox bbSource) {
        this.bbSource = bbSource;
        this.viewerTransform = new AffineTransform3D();
        this.transform = new AffineTransform3D();
        this.renderBoxHelper = new RenderBoxHelper();
        this.cornerHighlighter = new CornerHighlighter(20.0);
    }

    public void setPerspective(double perspective) {
        this.perspective = perspective;
    }

    public void showCornerHandles(boolean showCornerHandles) {
        this.showCornerHandles = showCornerHandles;
    }

    public void fillIntersection(boolean fillIntersection) {
        this.fillIntersection = fillIntersection;
    }

    public boolean getFillIntersection() {
        return this.fillIntersection;
    }

    public void setIntersectionFillColor(Color intersectionFillColor) {
        this.intersectionFillColor = intersectionFillColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOverlays(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        GeneralPath front = new GeneralPath();
        GeneralPath back = new GeneralPath();
        GeneralPath intersection = new GeneralPath();
        RealInterval interval = this.bbSource.getInterval();
        double ox = this.canvasWidth / 2;
        double oy = this.canvasHeight / 2;
        AffineTransform3D affineTransform3D = this.viewerTransform;
        synchronized (affineTransform3D) {
            this.bbSource.getTransform(this.transform);
            this.transform.preConcatenate(this.viewerTransform);
        }
        this.renderBoxHelper.setPerspectiveProjection(this.perspective > 0.0);
        this.renderBoxHelper.setDepth(this.perspective * this.sourceSize);
        this.renderBoxHelper.setOrigin(ox, oy);
        this.renderBoxHelper.setScale(1.0);
        this.renderBoxHelper.renderBox(interval, this.transform, front, back, intersection);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.displayMode.get() == BoxDisplayMode.FULL) {
            graphics.setStroke(this.normalStroke);
            graphics.setPaint(this.backColor);
            graphics.draw(back);
        }
        if (this.fillIntersection) {
            graphics.setPaint(this.intersectionFillColor);
            graphics.fill(intersection);
        }
        graphics.setPaint(this.intersectionColor);
        graphics.setStroke(this.intersectionStroke);
        graphics.draw(intersection);
        if (this.displayMode.get() == BoxDisplayMode.FULL) {
            int id;
            graphics.setStroke(this.normalStroke);
            graphics.setPaint(this.frontColor);
            graphics.draw(front);
            if (this.showCornerHandles && (id = this.getHighlightedCornerIndex()) >= 0) {
                double[] p = this.renderBoxHelper.projectedCorners[id];
                Ellipse2D.Double cornerHandle = new Ellipse2D.Double(p[0] - 10.0, p[1] - 10.0, 20.0, 20.0);
                double z = this.renderBoxHelper.corners[this.cornerId][2];
                Color cornerColor = z > 0.0 ? this.backColor : this.frontColor;
                graphics.setColor(cornerColor);
                graphics.fill(cornerHandle);
                graphics.setColor(cornerColor.darker().darker());
                graphics.draw(cornerHandle);
            }
        }
    }

    @Override
    public void setCanvasSize(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transformChanged(AffineTransform3D t) {
        AffineTransform3D affineTransform3D = this.viewerTransform;
        synchronized (affineTransform3D) {
            this.viewerTransform.set(t);
        }
    }

    public ListenableVar<BoxDisplayMode, ChangeListener> boxDisplayMode() {
        return this.displayMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBoxToViewerTransform(AffineTransform3D t) {
        AffineTransform3D affineTransform3D = this.viewerTransform;
        synchronized (affineTransform3D) {
            t.set(this.transform);
        }
    }

    public int getHighlightedCornerIndex() {
        return this.cornerId;
    }

    public MouseMotionListener getCornerHighlighter() {
        return this.cornerHighlighter;
    }

    public void setHighlightedCornerListener(HighlightedCornerListener highlightedCornerListener) {
        this.highlightedCornerListener = highlightedCornerListener;
    }

    private void setHighlightedCorner(int id) {
        int oldId = this.cornerId;
        int n = this.cornerId = id >= 0 && id < 8 ? id : -1;
        if (this.cornerId != oldId && this.highlightedCornerListener != null && this.displayMode.get() == BoxDisplayMode.FULL) {
            this.highlightedCornerListener.highlightedCornerChanged();
        }
    }

    public void setSourceSize(double sourceSize) {
        this.sourceSize = sourceSize;
    }

    private class CornerHighlighter
    extends MouseMotionAdapter {
        private final double squTolerance;

        CornerHighlighter(double tolerance) {
            this.squTolerance = tolerance * tolerance;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            for (int i = 0; i < 8; ++i) {
                double[] corner = TransformedBoxOverlay.this.renderBoxHelper.projectedCorners[i];
                double dx = (double)x - corner[0];
                double dy = (double)y - corner[1];
                double dr2 = dx * dx + dy * dy;
                if (!(dr2 < this.squTolerance)) continue;
                TransformedBoxOverlay.this.setHighlightedCorner(i);
                return;
            }
            TransformedBoxOverlay.this.setHighlightedCorner(-1);
        }
    }

    public static interface HighlightedCornerListener {
        public void highlightedCornerChanged();
    }

    public static enum BoxDisplayMode {
        FULL,
        SECTION;

    }
}

