/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.appearance;

import bdv.ui.UIUtils;
import bdv.ui.appearance.Appearance;
import bdv.ui.appearance.AppearanceIO;
import bdv.util.Prefs;
import java.awt.Component;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class AppearanceManager {
    private static final String CONFIG_FILE_NAME = "appearance.yaml";
    private final String configFile;
    private final List<WeakReference<Component>> components = new CopyOnWriteArrayList<WeakReference<Component>>();
    private final Appearance appearance;

    public AppearanceManager() {
        this(null);
    }

    public AppearanceManager(String configDir) {
        this.configFile = configDir == null ? null : configDir + "/" + CONFIG_FILE_NAME;
        this.appearance = new Appearance();
        this.fromPrefs();
        this.load();
        this.toPrefs();
    }

    public Appearance appearance() {
        return this.appearance;
    }

    public void addLafComponent(Component component) {
        this.components.add(new WeakReference<Component>(component));
    }

    public void updateLookAndFeel() {
        UIManager.LookAndFeelInfo laf = this.appearance.lookAndFeel();
        if (laf == Appearance.DONT_MODIFY_LOOK_AND_FEEL) {
            return;
        }
        if (UIManager.getLookAndFeel().getName().equals(laf.getName())) {
            return;
        }
        try {
            UIUtils.resetPropertyCaches();
            UIManager.setLookAndFeel(laf.getClassName());
            for (Window window : Window.getWindows()) {
                SwingUtilities.updateComponentTreeUI(window);
            }
            ArrayList<WeakReference<Component>> remove = new ArrayList<WeakReference<Component>>();
            for (WeakReference<Component> ref : this.components) {
                Component component = (Component)ref.get();
                if (component == null) {
                    remove.add(ref);
                    continue;
                }
                SwingUtilities.updateComponentTreeUI(component);
            }
            this.components.removeAll(remove);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void load() {
        this.load(this.configFile);
    }

    void load(String filename) {
        try {
            Appearance a = AppearanceIO.load(filename);
            this.appearance.set(a);
        }
        catch (FileNotFoundException e) {
            System.out.println("Appearance settings file " + filename + " not found. Using defaults.");
        }
        catch (Exception e) {
            System.out.println("Error while reading appearance settings file " + filename + ". Using defaults.");
        }
    }

    void save() {
        this.save(this.configFile);
    }

    void save(String filename) {
        try {
            AppearanceIO.save(this.appearance, filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error while reading appearance settings file " + filename + ". Using defaults.");
        }
    }

    @Deprecated
    public void toPrefs() {
        Prefs.showScaleBar(this.appearance.showScaleBar());
        Prefs.showScaleBarInMovie(this.appearance.showScaleBarInMovie());
        Prefs.showMultibox(this.appearance.showMultibox());
        Prefs.showTextOverlay(this.appearance.showTextOverlay());
        Prefs.sourceNameOverlayPosition(this.appearance.sourceNameOverlayPosition());
        Prefs.scaleBarColor(this.appearance.scaleBarColor());
        Prefs.scaleBarBgColor(this.appearance.scaleBarBgColor());
    }

    @Deprecated
    public void fromPrefs() {
        this.appearance.setShowScaleBar(Prefs.showScaleBar());
        this.appearance.setShowScaleBarInMovie(Prefs.showScaleBarInMovie());
        this.appearance.setShowMultibox(Prefs.showMultibox());
        this.appearance.setShowTextOverlay(Prefs.showTextOverlay());
        this.appearance.setSourceNameOverlayPosition(Prefs.sourceNameOverlayPosition());
        this.appearance.setScaleBarColor(Prefs.scaleBarColor());
        this.appearance.setScaleBarBgColor(Prefs.scaleBarBgColor());
    }
}

