/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.cache.SharedQueue;
import bdv.util.AbstractSource;
import bdv.util.VolatileRandomAccessibleIntervalMipmapSource;
import bdv.util.volatiles.VolatileTypeMatcher;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;

public class RandomAccessibleIntervalMipmapSource<T extends NumericType<T>>
extends AbstractSource<T> {
    protected final RandomAccessibleInterval<T>[] mipmapSources;
    protected final AffineTransform3D[] mipmapTransforms;

    public RandomAccessibleIntervalMipmapSource(RandomAccessibleInterval<T>[] imgs, T type, AffineTransform3D[] mipmapTransforms, VoxelDimensions voxelDimensions, String name, boolean doBoundingBoxCulling) {
        super(type, name, voxelDimensions, doBoundingBoxCulling);
        assert (imgs.length == mipmapTransforms.length) : "Number of mipmaps and scale factors do not match.";
        this.mipmapSources = imgs;
        this.mipmapTransforms = mipmapTransforms;
    }

    public RandomAccessibleIntervalMipmapSource(RandomAccessibleInterval<T>[] imgs, T type, double[][] mipmapScales, VoxelDimensions voxelDimensions, AffineTransform3D sourceTransform, String name, boolean doBoundingBoxCulling) {
        super(type, name, voxelDimensions, doBoundingBoxCulling);
        assert (imgs.length == mipmapScales.length) : "Number of mipmaps and scale factors do not match.";
        this.mipmapSources = imgs;
        this.mipmapTransforms = new AffineTransform3D[mipmapScales.length];
        for (int s = 0; s < mipmapScales.length; ++s) {
            AffineTransform3D mipmapTransform = new AffineTransform3D();
            mipmapTransform.set(mipmapScales[s][0], 0.0, 0.0, 0.5 * (mipmapScales[s][0] - 1.0), 0.0, mipmapScales[s][1], 0.0, 0.5 * (mipmapScales[s][1] - 1.0), 0.0, 0.0, mipmapScales[s][2], 0.5 * (mipmapScales[s][2] - 1.0));
            mipmapTransform.preConcatenate(sourceTransform);
            this.mipmapTransforms[s] = mipmapTransform;
        }
    }

    public RandomAccessibleIntervalMipmapSource(RandomAccessibleInterval<T>[] imgs, T type, double[][] mipmapScales, VoxelDimensions voxelDimensions, AffineTransform3D sourceTransform, String name) {
        this(imgs, type, mipmapScales, voxelDimensions, sourceTransform, name, true);
    }

    public RandomAccessibleIntervalMipmapSource(RandomAccessibleInterval<T>[] imgs, T type, double[][] mipmapScales, VoxelDimensions voxelDimensions, String name) {
        this(imgs, type, mipmapScales, voxelDimensions, new AffineTransform3D(), name);
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return this.mipmapSources[level];
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.mipmapTransforms[level]);
    }

    @Override
    public int getNumMipmapLevels() {
        return this.mipmapSources.length;
    }

    public <V extends Volatile<T>> VolatileRandomAccessibleIntervalMipmapSource<T, V> asVolatile(V vType, SharedQueue queue) {
        return new VolatileRandomAccessibleIntervalMipmapSource(this, vType, queue);
    }

    public <V extends Volatile<T>> VolatileRandomAccessibleIntervalMipmapSource<T, V> asVolatile(Supplier<V> vTypeSupplier, SharedQueue queue) {
        return new VolatileRandomAccessibleIntervalMipmapSource(this, vTypeSupplier, queue);
    }

    public <V extends Volatile<T>> VolatileRandomAccessibleIntervalMipmapSource<T, V> asVolatile(SharedQueue queue) {
        Object t = this.getType();
        if (t instanceof NativeType) {
            return new VolatileRandomAccessibleIntervalMipmapSource(this, (Volatile)VolatileTypeMatcher.getVolatileTypeForType((NativeType)this.getType()), queue);
        }
        throw new UnsupportedOperationException("This method only works for sources of NativeType.");
    }
}

