/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.AbstractSource;
import bdv.viewer.Interpolation;
import java.util.Arrays;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class RandomAccessibleIntervalSource4D<T extends NumericType<T>>
extends AbstractSource<T> {
    private final RandomAccessibleInterval<T> source;
    protected int currentTimePointIndex;
    private RandomAccessibleInterval<T> currentSource;
    private final RealRandomAccessible<T>[] currentInterpolatedSources;
    private final AffineTransform3D sourceTransform;

    public RandomAccessibleIntervalSource4D(RandomAccessibleInterval<T> img, T type, String name) {
        this(img, type, new AffineTransform3D(), name);
    }

    public RandomAccessibleIntervalSource4D(RandomAccessibleInterval<T> img, T type, AffineTransform3D sourceTransform, String name) {
        super(type, name);
        this.source = img;
        this.sourceTransform = sourceTransform;
        this.currentInterpolatedSources = new RealRandomAccessible[Interpolation.values().length];
        this.loadTimepoint(0);
    }

    private void loadTimepoint(int timepointIndex) {
        this.currentTimePointIndex = timepointIndex;
        if (this.isPresent(timepointIndex)) {
            NumericType zero = (NumericType)this.getType().createVariable();
            zero.setZero();
            this.currentSource = Views.hyperSlice(this.source, (int)3, (long)timepointIndex);
            for (Interpolation method : Interpolation.values()) {
                this.currentInterpolatedSources[method.ordinal()] = Views.interpolate((EuclideanSpace)Views.extendValue(this.currentSource, (Type)zero), this.interpolators.get(method));
            }
        } else {
            this.currentSource = null;
            Arrays.fill(this.currentInterpolatedSources, null);
        }
    }

    @Override
    public boolean isPresent(int t) {
        return this.source.min(3) <= (long)t && (long)t <= this.source.max(3);
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentSource;
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        if (t != this.currentTimePointIndex) {
            this.loadTimepoint(t);
        }
        return this.currentInterpolatedSources[method.ordinal()];
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.sourceTransform);
    }
}

