/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.TransformEventHandler;
import bdv.TransformState;
import bdv.cache.CacheControl;
import bdv.ui.UIUtils;
import bdv.util.Prefs;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.BasicViewerState;
import bdv.viewer.DisplayMode;
import bdv.viewer.InteractiveDisplayCanvas;
import bdv.viewer.Interpolation;
import bdv.viewer.InterpolationModeListener;
import bdv.viewer.NavigationActions;
import bdv.viewer.OverlayRenderer;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import bdv.viewer.VisibilityAndGrouping;
import bdv.viewer.animate.AbstractTransformAnimator;
import bdv.viewer.animate.MessageOverlayAnimator;
import bdv.viewer.animate.OverlayAnimator;
import bdv.viewer.animate.TextOverlayAnimator;
import bdv.viewer.overlay.MultiBoxOverlayRenderer;
import bdv.viewer.overlay.ScaleBarOverlayRenderer;
import bdv.viewer.overlay.SourceInfoOverlayRenderer;
import bdv.viewer.render.DebugTilingOverlay;
import bdv.viewer.render.MultiResolutionRenderer;
import bdv.viewer.render.PainterThread;
import bdv.viewer.render.awt.BufferedImageOverlayRenderer;
import bdv.viewer.state.SourceGroup;
import bdv.viewer.state.ViewerState;
import bdv.viewer.state.XmlIoViewerState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.imglib2.Interval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import org.jdom2.Element;
import org.scijava.listeners.Listeners;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class ViewerPanel
extends AbstractViewerPanel
implements OverlayRenderer,
PainterThread.Paintable,
ViewerStateChangeListener {
    private static final long serialVersionUID = 1L;
    private final SynchronizedViewerState state;
    private final ViewerState deprecatedState;
    private final MultiResolutionRenderer imageRenderer;
    private final BufferedImageOverlayRenderer renderTarget;
    private final MultiBoxOverlayRenderer multiBoxOverlayRenderer;
    private final SourceInfoOverlayRenderer sourceInfoOverlayRenderer;
    private final ScaleBarOverlayRenderer scaleBarOverlayRenderer;
    private final TransformEventHandler transformEventHandler;
    private final InteractiveDisplayCanvas display;
    private final JSlider sliderTime;
    private boolean blockSliderTimeEvents;
    private ThreadGroup threadGroup;
    private final PainterThread painterThread;
    private final ForkJoinPool renderingExecutorService;
    private final VisibilityAndGrouping visibilityAndGrouping;
    private final Listeners.List<TransformListener<AffineTransform3D>> transformListeners;
    private final Listeners.List<TimePointListener> timePointListeners;
    private final Listeners.List<InterpolationModeListener> interpolationModeListeners;
    private AbstractTransformAnimator currentAnimator = null;
    private final ArrayList<OverlayAnimator> overlayAnimators;
    private final MessageOverlayAnimator msgOverlay;
    private final ViewerOptions.Values options;
    protected static final AtomicInteger panelNumber = new AtomicInteger(1);

    public ViewerPanel(List<SourceAndConverter<?>> sources, int numTimePoints, CacheControl cacheControl) {
        this(sources, numTimePoints, cacheControl, ViewerOptions.options());
    }

    public ViewerPanel(List<SourceAndConverter<?>> sources, int numTimepoints, CacheControl cacheControl, ViewerOptions optional) {
        super(new BorderLayout(), false);
        this.options = optional.values;
        this.state = ViewerPanel.setupState(sources, numTimepoints, this.options.getNumSourceGroups());
        this.deprecatedState = new ViewerState(this.state);
        this.multiBoxOverlayRenderer = new MultiBoxOverlayRenderer();
        this.sourceInfoOverlayRenderer = new SourceInfoOverlayRenderer();
        this.scaleBarOverlayRenderer = new ScaleBarOverlayRenderer();
        this.threadGroup = new ThreadGroup(this.toString());
        this.painterThread = new PainterThread(this.threadGroup, this);
        this.painterThread.setDaemon(true);
        this.transformEventHandler = this.options.getTransformEventHandlerFactory().create(TransformState.from(this.state::getViewerTransform, this.state::setViewerTransform));
        this.renderTarget = new BufferedImageOverlayRenderer();
        this.display = new InteractiveDisplayCanvas(this.options.getWidth(), this.options.getHeight());
        this.display.setTransformEventHandler(this.transformEventHandler);
        this.display.overlays().add((Object)this.renderTarget);
        this.display.overlays().add((Object)this);
        this.renderingExecutorService = new ForkJoinPool(this.options.getNumRenderingThreads());
        this.imageRenderer = new MultiResolutionRenderer(this.renderTarget, this.painterThread, this.options.getScreenScales(), this.options.getTargetRenderNanos(), this.options.getNumRenderingThreads(), this.renderingExecutorService, this.options.isUseVolatileIfAvailable(), this.options.getAccumulateProjectorFactory(), cacheControl);
        this.display.addHandler(this.mouseCoordinates);
        this.sliderTime = new JSlider(0, 0, numTimepoints - 1, 0);
        this.sliderTime.addChangeListener(e -> {
            if (!this.blockSliderTimeEvents) {
                this.state.setCurrentTimepoint(this.sliderTime.getValue());
            }
        });
        this.add((Component)this.display, "Center");
        if (numTimepoints > 1) {
            this.add((Component)this.sliderTime, "South");
        }
        this.setFocusable(false);
        this.visibilityAndGrouping = new VisibilityAndGrouping(this.deprecatedState);
        this.transformListeners = new Listeners.SynchronizedList(l -> l.transformChanged(this.state.getViewerTransform()));
        this.timePointListeners = new Listeners.SynchronizedList(l -> l.timePointChanged(this.state.getCurrentTimepoint()));
        this.interpolationModeListeners = new Listeners.SynchronizedList();
        this.msgOverlay = this.options.getMsgOverlay();
        this.overlayAnimators = new ArrayList();
        this.overlayAnimators.add(this.msgOverlay);
        this.overlayAnimators.add(new TextOverlayAnimator("Press <F1> for help.", 3000L, TextOverlayAnimator.TextPosition.CENTER));
        this.display.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ViewerPanel.this.requestRepaint();
                ViewerPanel.this.display.removeComponentListener(this);
            }
        });
        this.state.changeListeners().add((Object)this);
        this.painterThread.start();
    }

    private static SynchronizedViewerState setupState(List<SourceAndConverter<?>> sources, int numTimepoints, int numGroups) {
        SynchronizedViewerState state = new SynchronizedViewerState(new BasicViewerState());
        state.addSources(sources);
        state.setSourcesActive(sources, true);
        for (int i = 0; i < numGroups; ++i) {
            bdv.viewer.SourceGroup handle = new bdv.viewer.SourceGroup();
            state.addGroup(handle);
            state.setGroupName(handle, "group " + (i + 1));
            state.setGroupActive(handle, true);
            if (i >= sources.size()) continue;
            state.addSourceToGroup(sources.get(i), handle);
        }
        state.setNumTimepoints(numTimepoints);
        state.setInterpolation(Interpolation.NEARESTNEIGHBOR);
        state.setDisplayMode(DisplayMode.SINGLE);
        state.setCurrentSource(sources.isEmpty() ? null : sources.get(0));
        state.setCurrentGroup(numGroups <= 0 ? null : state.getGroups().get(0));
        return state;
    }

    @Deprecated
    public void addSource(SourceAndConverter<?> sourceAndConverter) {
        this.state.addSource(sourceAndConverter);
        this.state.setSourceActive(sourceAndConverter, true);
    }

    @Deprecated
    public void addSources(Collection<SourceAndConverter<?>> sourceAndConverter) {
        this.state.addSources(sourceAndConverter);
    }

    @Deprecated
    private SourceAndConverter<?> soc(Source<?> source) {
        for (SourceAndConverter<?> soc : this.state.getSources()) {
            if (soc.getSpimSource() != source) continue;
            return soc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeSource(Source<?> source) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.removeSource(this.soc(source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeSources(Collection<Source<?>> sources) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.state.removeSources(sources.stream().map(this::soc).collect(Collectors.toList()));
        }
    }

    @Deprecated
    public void removeAllSources() {
        this.state.clearSources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addGroup(SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.deprecatedState.addGroup(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeGroup(SourceGroup group) {
        SynchronizedViewerState synchronizedViewerState = this.state;
        synchronized (synchronizedViewerState) {
            this.deprecatedState.removeGroup(group);
        }
    }

    public void displayToGlobalCoordinates(double[] gPos) {
        assert (gPos.length >= 3);
        this.state.getViewerTransform().applyInverse(gPos, gPos);
    }

    public <P extends RealLocalizable & RealPositionable> void displayToGlobalCoordinates(P gPos) {
        assert (gPos.numDimensions() >= 3);
        this.state.getViewerTransform().applyInverse((RealPositionable)gPos, gPos);
    }

    public void displayToGlobalCoordinates(double x, double y, RealPositionable gPos) {
        assert (gPos.numDimensions() >= 3);
        RealPoint lPos = new RealPoint(3);
        lPos.setPosition(x, 0);
        lPos.setPosition(y, 1);
        this.state.getViewerTransform().applyInverse(gPos, (RealLocalizable)lPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint() {
        this.imageRenderer.paint(this.state);
        this.display.repaint();
        ViewerPanel viewerPanel = this;
        synchronized (viewerPanel) {
            if (this.currentAnimator != null) {
                AffineTransform3D transform = this.currentAnimator.getCurrent(System.currentTimeMillis());
                this.state.setViewerTransform(transform);
                if (this.currentAnimator.isComplete()) {
                    this.currentAnimator = null;
                } else {
                    this.requestRepaint();
                }
            }
        }
    }

    @Override
    public void requestRepaint() {
        this.imageRenderer.requestRepaint();
    }

    public void requestRepaint(Interval screenInterval) {
        this.imageRenderer.requestRepaint(screenInterval);
    }

    @Override
    protected void onMouseMoved() {
        if (Prefs.showTextOverlay()) {
            this.getDisplayComponent().repaint();
        }
    }

    @Override
    public void drawOverlays(Graphics g) {
        boolean requiresRepaint = false;
        if (Prefs.showMultibox()) {
            this.multiBoxOverlayRenderer.setViewerState(this.state);
            this.multiBoxOverlayRenderer.updateVirtualScreenSize(this.display.getWidth(), this.display.getHeight());
            this.multiBoxOverlayRenderer.paint((Graphics2D)g);
            requiresRepaint = this.multiBoxOverlayRenderer.isHighlightInProgress();
        }
        if (Prefs.showTextOverlay()) {
            Font font = UIUtils.getFont("monospaced.small.font");
            this.sourceInfoOverlayRenderer.setViewerState(this.state);
            this.sourceInfoOverlayRenderer.setSourceNameOverlayPosition(Prefs.sourceNameOverlayPosition());
            this.sourceInfoOverlayRenderer.paint((Graphics2D)g);
            double[] gPos = new double[3];
            this.getGlobalMouseCoordinates((RealPositionable)RealPoint.wrap((double[])gPos));
            String mousePosGlobalString = this.options.is2D() ? String.format(Locale.ROOT, "%6.1f, %6.1f", gPos[0], gPos[1]) : String.format(Locale.ROOT, "%6.1f, %6.1f, %6.1f", gPos[0], gPos[1], gPos[2]);
            g.setFont(font);
            UIUtils.drawString(g, UIUtils.TextPosition.TOP_RIGHT, 1, mousePosGlobalString);
        }
        if (Prefs.showScaleBar()) {
            this.scaleBarOverlayRenderer.setViewerState(this.state);
            this.scaleBarOverlayRenderer.paint((Graphics2D)g);
        }
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<OverlayAnimator> overlayAnimatorsToRemove = new ArrayList<OverlayAnimator>();
        for (OverlayAnimator animator : this.overlayAnimators) {
            animator.paint((Graphics2D)g, currentTimeMillis);
            requiresRepaint |= animator.requiresRepaint();
            if (!animator.isComplete()) continue;
            overlayAnimatorsToRemove.add(animator);
        }
        this.overlayAnimators.removeAll(overlayAnimatorsToRemove);
        if (requiresRepaint) {
            this.display.repaint();
        }
    }

    @Override
    public void viewerStateChanged(ViewerStateChange change) {
        switch (change) {
            case CURRENT_SOURCE_CHANGED: {
                this.multiBoxOverlayRenderer.highlight(this.state.getSources().indexOf(this.state.getCurrentSource()));
                this.display.repaint();
                break;
            }
            case DISPLAY_MODE_CHANGED: {
                this.showMessage(this.state.getDisplayMode().getName());
                this.display.repaint();
                break;
            }
            case GROUP_NAME_CHANGED: {
                this.display.repaint();
                break;
            }
            case CURRENT_GROUP_CHANGED: {
                break;
            }
            case SOURCE_ACTIVITY_CHANGED: {
                break;
            }
            case GROUP_ACTIVITY_CHANGED: {
                break;
            }
            case VISIBILITY_CHANGED: {
                this.requestRepaint();
                break;
            }
            case INTERPOLATION_CHANGED: {
                Interpolation interpolation = this.state.getInterpolation();
                this.showMessage(interpolation.getName());
                this.interpolationModeListeners.list.forEach(l -> l.interpolationModeChanged(interpolation));
                this.requestRepaint();
                break;
            }
            case NUM_TIMEPOINTS_CHANGED: {
                int numTimepoints = this.state.getNumTimepoints();
                int timepoint = Math.max(0, Math.min(this.state.getCurrentTimepoint(), numTimepoints - 1));
                SwingUtilities.invokeLater(() -> {
                    boolean sliderVisible = Arrays.asList(this.getComponents()).contains(this.sliderTime);
                    if (numTimepoints > 1 && !sliderVisible) {
                        this.add((Component)this.sliderTime, "South");
                    } else if (numTimepoints == 1 && sliderVisible) {
                        this.remove(this.sliderTime);
                    }
                    this.sliderTime.setModel(new DefaultBoundedRangeModel(timepoint, 0, 0, numTimepoints - 1));
                    this.revalidate();
                });
                break;
            }
            case CURRENT_TIMEPOINT_CHANGED: {
                int timepoint = this.state.getCurrentTimepoint();
                SwingUtilities.invokeLater(() -> {
                    this.blockSliderTimeEvents = true;
                    if (this.sliderTime.getValue() != timepoint) {
                        this.sliderTime.setValue(timepoint);
                    }
                    this.blockSliderTimeEvents = false;
                });
                this.timePointListeners.list.forEach(l -> l.timePointChanged(timepoint));
                this.requestRepaint();
                break;
            }
            case VIEWER_TRANSFORM_CHANGED: {
                AffineTransform3D transform = this.state.getViewerTransform();
                this.transformListeners.list.forEach(l -> l.transformChanged(transform));
                this.requestRepaint();
            }
        }
    }

    @Override
    public synchronized void setTransformAnimator(AbstractTransformAnimator animator) {
        this.currentAnimator = animator;
        this.currentAnimator.setTime(System.currentTimeMillis());
        this.requestRepaint();
    }

    public synchronized void toggleInterpolation() {
        NavigationActions.toggleInterpolation(this.state);
    }

    public synchronized void setInterpolation(Interpolation mode) {
        this.state.setInterpolation(mode);
    }

    public synchronized void setDisplayMode(DisplayMode displayMode) {
        this.state.setDisplayMode(displayMode);
    }

    @Deprecated
    public void setCurrentViewerTransform(AffineTransform3D viewerTransform) {
        this.state.setViewerTransform(viewerTransform);
    }

    public synchronized void setTimepoint(int timepoint) {
        this.state.setCurrentTimepoint(timepoint);
    }

    public synchronized void nextTimePoint() {
        NavigationActions.nextTimePoint(this.state);
    }

    public synchronized void previousTimePoint() {
        NavigationActions.previousTimePoint(this.state);
    }

    public void setNumTimepoints(int numTimepoints) {
        this.state.setNumTimepoints(numTimepoints);
    }

    @Deprecated
    public ViewerState getState() {
        return this.deprecatedState.copy();
    }

    @Override
    public SynchronizedViewerState state() {
        return this.state;
    }

    @Override
    public InteractiveDisplayCanvas getDisplay() {
        return this.display;
    }

    @Override
    public Component getDisplayComponent() {
        return this.display;
    }

    public TransformEventHandler getTransformEventHandler() {
        return this.transformEventHandler;
    }

    @Override
    public void showMessage(String msg) {
        this.msgOverlay.add(msg);
        this.display.repaint();
    }

    @Override
    public void addOverlayAnimator(OverlayAnimator animator) {
        this.overlayAnimators.add(animator);
        this.display.repaint();
    }

    public Listeners<InterpolationModeListener> interpolationModeListeners() {
        return this.interpolationModeListeners;
    }

    @Deprecated
    public void addInterpolationModeListener(InterpolationModeListener listener) {
        this.interpolationModeListeners().add((Object)listener);
    }

    @Deprecated
    public void removeInterpolationModeListener(InterpolationModeListener listener) {
        this.interpolationModeListeners().remove((Object)listener);
    }

    @Override
    public Listeners<TransformListener<AffineTransform3D>> renderTransformListeners() {
        return this.renderTarget.transformListeners();
    }

    @Deprecated
    public void addRenderTransformListener(TransformListener<AffineTransform3D> listener) {
        this.renderTransformListeners().add(listener);
    }

    @Deprecated
    public void addRenderTransformListener(TransformListener<AffineTransform3D> listener, int index) {
        this.renderTransformListeners().add(index, listener);
    }

    @Override
    public Listeners<TransformListener<AffineTransform3D>> transformListeners() {
        return this.transformListeners;
    }

    @Deprecated
    public void addTransformListener(TransformListener<AffineTransform3D> listener) {
        this.transformListeners().add(listener);
    }

    @Deprecated
    public void addTransformListener(TransformListener<AffineTransform3D> listener, int index) {
        this.transformListeners().add(index, listener);
    }

    @Deprecated
    public void removeTransformListener(TransformListener<AffineTransform3D> listener) {
        this.transformListeners().remove(listener);
        this.renderTransformListeners().remove(listener);
    }

    public Listeners<TimePointListener> timePointListeners() {
        return this.timePointListeners;
    }

    @Deprecated
    public void addTimePointListener(TimePointListener listener) {
        this.timePointListeners().add((Object)listener);
    }

    @Deprecated
    public void addTimePointListener(TimePointListener listener, int index) {
        this.timePointListeners().add(index, (Object)listener);
    }

    @Deprecated
    public void removeTimePointListener(TimePointListener listener) {
        this.timePointListeners().remove((Object)listener);
    }

    public synchronized Element stateToXml() {
        return new XmlIoViewerState().toXml(this.deprecatedState);
    }

    public synchronized void stateFromXml(Element parent) {
        XmlIoViewerState io = new XmlIoViewerState();
        io.restoreFromXml(parent.getChild(io.getTagName()), this.deprecatedState);
    }

    @Deprecated
    public VisibilityAndGrouping getVisibilityAndGrouping() {
        return this.visibilityAndGrouping;
    }

    public ViewerOptions.Values getOptionValues() {
        return this.options;
    }

    @Override
    public InputTriggerConfig getInputTriggerConfig() {
        return this.options.getInputTriggerConfig();
    }

    public SourceInfoOverlayRenderer getSourceInfoOverlayRenderer() {
        return this.sourceInfoOverlayRenderer;
    }

    public void stop() {
        this.painterThread.interrupt();
        try {
            this.painterThread.join(0L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.renderingExecutorService.shutdown();
        this.state.clearGroups();
        this.state.clearSources();
        this.imageRenderer.kill();
        this.renderTarget.kill();
    }

    public DebugTilingOverlay showDebugTileOverlay() {
        DebugTilingOverlay overlay = new DebugTilingOverlay(this.imageRenderer);
        this.display.overlays().add((Object)overlay);
        return overlay;
    }

    protected static class RenderThreadFactory
    implements ThreadFactory {
        private final ThreadGroup threadGroup;
        private final String threadNameFormat = String.format("bdv-panel-%d-thread-%%d", panelNumber.getAndIncrement());
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        protected RenderThreadFactory(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadGroup, r, String.format(this.threadNameFormat, this.threadNumber.getAndIncrement()), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

