/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.meta;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Attributes;
import org.scijava.common3.Classes;
import org.scijava.common3.Versioned;
import org.scijava.meta.XML;

public class Manifest
implements Versioned {
    private final java.util.jar.Manifest manifest;

    private Manifest(java.util.jar.Manifest manifest) {
        this.manifest = manifest;
    }

    public String archiverVersion() {
        return this.get("Archiver-Version");
    }

    public String buildJdk() {
        return this.get("Build-Jdk");
    }

    public String builtBy() {
        return this.get("Built-By");
    }

    public String createdBy() {
        return this.get("Created-By");
    }

    public String implementationBuild() {
        return this.get("Implementation-Build");
    }

    public String implementationDate() {
        return this.get("Implementation-Date");
    }

    public String implementationTitle() {
        return this.get("Implementation-Title");
    }

    public String implementationVendor() {
        return this.get("Implementation-Vendor");
    }

    public String implementationVendorId() {
        return this.get("Implementation-Vendor-Id");
    }

    public String implementationVersion() {
        return this.get("Implementation-Version");
    }

    public String manifestVersion() {
        return this.get("Manifest-Version");
    }

    public String package_() {
        return this.get("Package");
    }

    public String specificationTitle() {
        return this.get("Specification-Title");
    }

    public String specificationVendor() {
        return this.get("Specification-Vendor");
    }

    public String specificationVersion() {
        return this.get("Specification-Version");
    }

    public String get(String key) {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttrs = this.manifest.getMainAttributes();
        if (mainAttrs == null) {
            return null;
        }
        return mainAttrs.getValue(key);
    }

    public Map<Object, Object> getAll() {
        if (this.manifest == null) {
            return null;
        }
        Attributes mainAttrs = this.manifest.getMainAttributes();
        if (mainAttrs == null) {
            return null;
        }
        return Collections.unmodifiableMap(mainAttrs);
    }

    public static Manifest manifest(Class<?> c) {
        try {
            return Manifest.manifest(new URL("jar:" + Classes.location(c) + "!/"));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Manifest manifest(XML xml) throws IOException {
        String path = xml.path();
        if (path == null || !path.startsWith("file:")) {
            return null;
        }
        int dotJAR = path.indexOf(".jar!/");
        return Manifest.manifest(new File(path.substring(5, dotJAR + 4)));
    }

    public static Manifest manifest(File jarFile) throws IOException {
        if (!jarFile.exists()) {
            throw new FileNotFoundException();
        }
        return Manifest.manifest(new URL("jar:file:" + jarFile.getAbsolutePath() + "!/"));
    }

    private static Manifest manifest(URL jarURL) throws IOException {
        JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
        return new Manifest(conn.getManifest());
    }

    @Override
    public String version() {
        String v = this.baseVersion();
        if (v == null || !v.endsWith("-SNAPSHOT")) {
            return v;
        }
        String buildNumber = this.implementationBuild();
        return buildNumber == null ? v : v + "-" + buildNumber;
    }

    private String baseVersion() {
        String manifestVersion = this.implementationVersion();
        if (manifestVersion != null) {
            return manifestVersion;
        }
        return this.specificationVersion();
    }
}

