/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components.tracker;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.tracking.overlap.OverlapTracker;
import fiji.plugin.trackmate.tracking.overlap.OverlapTrackerFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OverlapTrackerSettingsPanel
extends ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JFormattedTextField ftfScaleFactor;
    private final JFormattedTextField ftfMinIoU;
    private final JRadioButton rdbtnFast;
    private final JRadioButton rdbtnPrecise;

    public OverlapTrackerSettingsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{164, 59, 0};
        gridBagLayout.rowHeights = new int[]{0, 20, 225, 0, 0, 20, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblSettingsForTracker = new JLabel();
        lblSettingsForTracker.setFont(Fonts.FONT);
        GridBagConstraints gbc_lblSettingsForTracker = new GridBagConstraints();
        gbc_lblSettingsForTracker.fill = 1;
        gbc_lblSettingsForTracker.insets = new Insets(5, 5, 5, 5);
        gbc_lblSettingsForTracker.gridwidth = 2;
        gbc_lblSettingsForTracker.gridx = 0;
        gbc_lblSettingsForTracker.gridy = 0;
        this.add((Component)lblSettingsForTracker, gbc_lblSettingsForTracker);
        JLabel labelTracker = new JLabel("Overlap tracker", OverlapTrackerFactory.ICON, 0);
        labelTracker.setFont(Fonts.BIG_FONT);
        GridBagConstraints gbc_labelTracker = new GridBagConstraints();
        gbc_labelTracker.fill = 1;
        gbc_labelTracker.insets = new Insets(5, 5, 5, 5);
        gbc_labelTracker.gridwidth = 2;
        gbc_labelTracker.gridx = 0;
        gbc_labelTracker.gridy = 1;
        this.add((Component)labelTracker, gbc_labelTracker);
        JLabel labelTrackerDescription = new JLabel("<tracker description>");
        labelTrackerDescription.setFont(Fonts.FONT.deriveFont(2));
        labelTrackerDescription.setText("<html> This tracker is a simple extension of the Intersection - over - Union (IoU) tracker. <p> <p> It generates links between spots whose shapes overlap between consecutive frames. When several spots are eligible as a source for a target, the one with the largest IoU is chosen.<p> <p> The minimal IoU parameter sets a threshold below which links won't be created. The scale factor allows for enlarging (&gt;1) or shrinking (&lt;1) the spot shapes before computing their IoU. Two methods can be used to compute IoU: The <it>Fast</it> one approximates  the spot shapes by their rectangular bounding-box. The <it>Precise</it> one uses the actual spot polygon. <p> <p> This tracker works in 2D and 3D. However in 3D, the IoU is computed from the bounding-boxes regardless of the choice of the IoU computation method. The <it>Precise</it> method is not implemented.</html>".replace("<br>", "").replace("<p>", "<p align=\"justify\">").replace("<html>", "<html><p align=\"justify\">"));
        GridBagConstraints gbc_labelTrackerDescription = new GridBagConstraints();
        gbc_labelTrackerDescription.fill = 1;
        gbc_labelTrackerDescription.insets = new Insets(5, 5, 5, 5);
        gbc_labelTrackerDescription.gridwidth = 2;
        gbc_labelTrackerDescription.gridx = 0;
        gbc_labelTrackerDescription.gridy = 2;
        this.add((Component)labelTrackerDescription, gbc_labelTrackerDescription);
        JPanel panelMethod = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panelMethod.getLayout();
        flowLayout.setHgap(10);
        flowLayout.setAlignment(4);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.gridwidth = 2;
        gbc_panel.insets = new Insets(5, 5, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 3;
        this.add((Component)panelMethod, gbc_panel);
        JLabel lblIouCalculation = new JLabel("IoU calculation:");
        lblIouCalculation.setFont(Fonts.FONT);
        panelMethod.add(lblIouCalculation);
        this.rdbtnFast = new JRadioButton(OverlapTracker.IoUCalculation.FAST.toString());
        this.rdbtnFast.setFont(Fonts.FONT);
        this.rdbtnFast.setToolTipText(OverlapTracker.IoUCalculation.FAST.getInfoText());
        panelMethod.add(this.rdbtnFast);
        this.rdbtnPrecise = new JRadioButton(OverlapTracker.IoUCalculation.PRECISE.toString());
        this.rdbtnPrecise.setFont(Fonts.FONT);
        this.rdbtnPrecise.setToolTipText(OverlapTracker.IoUCalculation.PRECISE.getInfoText());
        panelMethod.add(this.rdbtnPrecise);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdbtnPrecise);
        buttonGroup.add(this.rdbtnFast);
        JLabel lblMinIoU = new JLabel("Min IoU:");
        lblMinIoU.setFont(Fonts.FONT);
        GridBagConstraints gbc_lblMinIoU = new GridBagConstraints();
        gbc_lblMinIoU.fill = 3;
        gbc_lblMinIoU.anchor = 13;
        gbc_lblMinIoU.insets = new Insets(5, 5, 5, 5);
        gbc_lblMinIoU.gridx = 0;
        gbc_lblMinIoU.gridy = 4;
        this.add((Component)lblMinIoU, gbc_lblMinIoU);
        this.ftfMinIoU = new JFormattedTextField();
        this.ftfMinIoU.setText("0");
        this.ftfMinIoU.setFont(Fonts.FONT);
        this.ftfMinIoU.setHorizontalAlignment(0);
        GridBagConstraints gbc_ftfMinIoU = new GridBagConstraints();
        gbc_ftfMinIoU.insets = new Insets(5, 5, 5, 5);
        gbc_ftfMinIoU.fill = 1;
        gbc_ftfMinIoU.gridx = 1;
        gbc_ftfMinIoU.gridy = 4;
        this.add((Component)this.ftfMinIoU, gbc_ftfMinIoU);
        JLabel lblScaleFactor = new JLabel("Scale factor:");
        lblScaleFactor.setFont(Fonts.FONT);
        GridBagConstraints gbc_lblScaleFactor = new GridBagConstraints();
        gbc_lblScaleFactor.anchor = 13;
        gbc_lblScaleFactor.fill = 3;
        gbc_lblScaleFactor.insets = new Insets(5, 5, 5, 5);
        gbc_lblScaleFactor.gridx = 0;
        gbc_lblScaleFactor.gridy = 5;
        this.add((Component)lblScaleFactor, gbc_lblScaleFactor);
        this.ftfScaleFactor = new JFormattedTextField(new DecimalFormat("#.##"));
        this.ftfScaleFactor.setText("1");
        this.ftfScaleFactor.setHorizontalAlignment(0);
        this.ftfScaleFactor.setValue(1.0);
        this.ftfScaleFactor.setFont(Fonts.FONT);
        GridBagConstraints gbc_ftfScaleFactor = new GridBagConstraints();
        gbc_ftfScaleFactor.fill = 1;
        gbc_ftfScaleFactor.insets = new Insets(5, 5, 5, 5);
        gbc_ftfScaleFactor.gridx = 1;
        gbc_ftfScaleFactor.gridy = 5;
        this.add((Component)this.ftfScaleFactor, gbc_ftfScaleFactor);
        GuiUtils.selectAllOnFocus(this.ftfMinIoU);
        GuiUtils.selectAllOnFocus(this.ftfScaleFactor);
    }

    @Override
    public Map<String, Object> getSettings() {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("SCALE_FACTOR", ((Number)this.ftfScaleFactor.getValue()).doubleValue());
        settings.put("MIN_IOU", ((Number)this.ftfMinIoU.getValue()).doubleValue());
        OverlapTracker.IoUCalculation method = this.rdbtnFast.isSelected() ? OverlapTracker.IoUCalculation.FAST : OverlapTracker.IoUCalculation.PRECISE;
        settings.put("IOU_CALCULATION", method.name());
        return settings;
    }

    @Override
    public void setSettings(Map<String, Object> settings) {
        this.ftfScaleFactor.setValue(settings.get("SCALE_FACTOR") == null ? OverlapTrackerFactory.DEFAULT_SCALE_FACTOR : settings.get("SCALE_FACTOR"));
        this.ftfMinIoU.setValue(settings.get("MIN_IOU") == null ? OverlapTrackerFactory.DEFAULT_MIN_IOU : settings.get("MIN_IOU"));
        Object obj = settings.get("IOU_CALCULATION");
        boolean isFast = obj != null ? ((String)obj).equalsIgnoreCase(OverlapTracker.IoUCalculation.FAST.name()) : false;
        this.rdbtnFast.setSelected(isFast);
        this.rdbtnPrecise.setSelected(!isFast);
    }

    @Override
    public void clean() {
    }
}

