/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard;

import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.wizard.TransitionAnimator;
import fiji.plugin.trackmate.gui.wizard.WizardPanel;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import fiji.plugin.trackmate.util.Threads;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.scijava.Cancelable;

public class WizardController {
    private final WizardSequence sequence;
    private final WizardPanel wizardPanel;

    public WizardController(WizardSequence sequence) {
        this.sequence = sequence;
        this.wizardPanel = new WizardPanel();
        this.wizardPanel.btnSave.setAction(this.getSaveAction());
        this.wizardPanel.btnLog.setAction(this.getLogAction());
        this.wizardPanel.btnDisplayConfig.setAction(this.getDisplayConfigAction());
        this.wizardPanel.btnNext.setAction(this.getNextAction());
        this.wizardPanel.btnPrevious.setAction(this.getPreviousAction());
        this.wizardPanel.btnCancel.setAction(this.getCancelAction());
        this.wizardPanel.btnResume.setAction(this.getResumeAction());
        this.wizardPanel.btnCancel.setVisible(false);
        this.wizardPanel.btnResume.setVisible(false);
    }

    public WizardPanel getWizardPanel() {
        return this.wizardPanel;
    }

    protected void log(boolean show) {
        if (show) {
            this.sequence.logDescriptor().targetPanel.setSize(this.sequence.current().targetPanel.getSize());
            this.display(this.sequence.logDescriptor(), this.sequence.current(), TransitionAnimator.Direction.TOP);
            this.wizardPanel.btnNext.setEnabled(false);
            this.wizardPanel.btnPrevious.setEnabled(false);
            this.wizardPanel.btnDisplayConfig.setEnabled(false);
            this.wizardPanel.btnCancel.setEnabled(false);
            this.wizardPanel.btnSave.setEnabled(false);
        } else {
            this.sequence.current().targetPanel.setSize(this.sequence.logDescriptor().targetPanel.getSize());
            this.display(this.sequence.current(), this.sequence.logDescriptor(), TransitionAnimator.Direction.BOTTOM);
            this.wizardPanel.btnDisplayConfig.setEnabled(true);
            this.wizardPanel.btnCancel.setEnabled(true);
            this.wizardPanel.btnSave.setEnabled(true);
        }
    }

    protected void displayConfig(boolean show) {
        if (show) {
            this.sequence.configDescriptor().targetPanel.setSize(this.sequence.current().targetPanel.getSize());
            this.display(this.sequence.configDescriptor(), this.sequence.current(), TransitionAnimator.Direction.BOTTOM);
            this.wizardPanel.btnNext.setEnabled(false);
            this.wizardPanel.btnPrevious.setEnabled(false);
            this.wizardPanel.btnLog.setEnabled(false);
            this.wizardPanel.btnCancel.setEnabled(false);
            this.wizardPanel.btnSave.setEnabled(false);
        } else {
            this.sequence.current().targetPanel.setSize(this.sequence.configDescriptor().targetPanel.getSize());
            this.display(this.sequence.current(), this.sequence.configDescriptor(), TransitionAnimator.Direction.TOP);
            this.wizardPanel.btnLog.setEnabled(true);
            this.wizardPanel.btnCancel.setEnabled(true);
            this.wizardPanel.btnSave.setEnabled(true);
        }
    }

    protected synchronized void previous() {
        try {
            WizardPanelDescriptor current = this.sequence.current();
            if (current == null) {
                return;
            }
            current.aboutToHidePanel();
            WizardPanelDescriptor back = this.sequence.previous();
            if (null == back) {
                return;
            }
            back.targetPanel.setSize(current.targetPanel.getSize());
            back.aboutToDisplayPanel();
            this.display(back, current, TransitionAnimator.Direction.LEFT);
            back.displayingPanel();
            this.exec(back.getBackwardRunnable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected synchronized void next() {
        try {
            WizardPanelDescriptor current = this.sequence.current();
            if (current == null) {
                return;
            }
            current.aboutToHidePanel();
            WizardPanelDescriptor next = this.sequence.next();
            if (null == next) {
                return;
            }
            next.targetPanel.setSize(current.targetPanel.getSize());
            next.aboutToDisplayPanel();
            this.display(next, current, TransitionAnimator.Direction.RIGHT);
            next.displayingPanel();
            this.exec(next.getForwardRunnable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void cancel() {
        Cancelable cancelable = this.sequence.current().getCancelable();
        if (null != cancelable) {
            cancelable.cancel("User pressed cancel button.");
        }
    }

    protected void finish() {
        Container container = this.wizardPanel;
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        ((Frame)container).dispose();
    }

    private void exec(Runnable runnable) {
        if (null == runnable) {
            return;
        }
        EverythingDisablerAndReenabler reenabler = new EverythingDisablerAndReenabler(this.wizardPanel.panelButtons, new Class[]{JLabel.class});
        Threads.run("Wizard exec thread", () -> {
            try {
                reenabler.disable();
                Thread.sleep(200L);
                this.wizardPanel.btnNext.setVisible(false);
                this.wizardPanel.btnCancel.setVisible(true);
                this.wizardPanel.btnCancel.setEnabled(true);
                runnable.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.wizardPanel.btnCancel.setVisible(false);
                this.wizardPanel.btnNext.setVisible(true);
                this.wizardPanel.btnNext.requestFocusInWindow();
                reenabler.reenable();
            }
        });
    }

    public void init() {
        WizardPanelDescriptor descriptor = this.sequence.current();
        this.wizardPanel.btnPrevious.setEnabled(this.sequence.hasPrevious());
        this.wizardPanel.btnNext.setEnabled(this.sequence.hasNext());
        descriptor.aboutToDisplayPanel();
        this.wizardPanel.display(descriptor);
        descriptor.displayingPanel();
        SwingUtilities.invokeLater(() -> this.wizardPanel.btnNext.requestFocusInWindow());
    }

    protected void save() {
        WizardPanelDescriptor saveDescriptor = this.sequence.save();
        saveDescriptor.targetPanel.setSize(this.sequence.current().targetPanel.getSize());
        this.wizardPanel.btnSave.setVisible(false);
        this.wizardPanel.btnPrevious.setVisible(false);
        this.wizardPanel.btnDisplayConfig.setVisible(false);
        this.wizardPanel.btnLog.setVisible(false);
        this.wizardPanel.btnNext.setVisible(false);
        this.wizardPanel.btnResume.setVisible(true);
        this.display(saveDescriptor, this.sequence.current(), TransitionAnimator.Direction.BOTTOM);
        Threads.run(() -> {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            saveDescriptor.aboutToDisplayPanel();
            saveDescriptor.displayingPanel();
        });
    }

    protected void resume() {
        WizardPanelDescriptor saveDescriptor = this.sequence.save();
        try {
            saveDescriptor.aboutToHidePanel();
        }
        finally {
            this.wizardPanel.btnResume.setVisible(false);
            this.wizardPanel.btnSave.setVisible(true);
            this.wizardPanel.btnPrevious.setVisible(true);
            this.wizardPanel.btnDisplayConfig.setVisible(true);
            this.wizardPanel.btnLog.setVisible(true);
            this.wizardPanel.btnNext.setVisible(true);
            this.sequence.current().targetPanel.setSize(saveDescriptor.targetPanel.getSize());
            this.display(this.sequence.current(), saveDescriptor, TransitionAnimator.Direction.TOP);
        }
    }

    private void display(WizardPanelDescriptor to, WizardPanelDescriptor from, TransitionAnimator.Direction direction) {
        if (null == to) {
            return;
        }
        this.wizardPanel.btnPrevious.setEnabled(this.sequence.hasPrevious());
        this.wizardPanel.btnNext.setEnabled(this.sequence.hasNext());
        this.wizardPanel.transition(to, from, direction);
    }

    private Action getNextAction() {
        AbstractAction nextAction = new AbstractAction("Next"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.next();
            }
        };
        nextAction.putValue("SmallIcon", Icons.NEXT_ICON);
        return nextAction;
    }

    private Action getPreviousAction() {
        AbstractAction previousAction = new AbstractAction("Previous"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.previous();
            }
        };
        previousAction.putValue("Name", "");
        previousAction.putValue("SmallIcon", Icons.PREVIOUS_ICON);
        return previousAction;
    }

    private Action getLogAction() {
        AbstractAction logAction = new AbstractAction("Log"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.log(WizardController.this.wizardPanel.btnLog.isSelected());
            }
        };
        logAction.putValue("SmallIcon", Icons.LOG_ICON);
        logAction.putValue("Name", "");
        return logAction;
    }

    private Action getCancelAction() {
        AbstractAction cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.cancel();
            }
        };
        cancelAction.putValue("SmallIcon", Icons.CANCEL_ICON);
        return cancelAction;
    }

    private Action getSaveAction() {
        AbstractAction saveAction = new AbstractAction("Save"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.save();
            }
        };
        saveAction.putValue("SmallIcon", Icons.SAVE_ICON);
        return saveAction;
    }

    private Action getResumeAction() {
        AbstractAction resumeAction = new AbstractAction("Resume"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.resume();
            }
        };
        resumeAction.putValue("SmallIcon", Icons.REVERT_ICON);
        return resumeAction;
    }

    private Action getDisplayConfigAction() {
        AbstractAction configAction = new AbstractAction("DisplayConfig"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardController.this.displayConfig(WizardController.this.wizardPanel.btnDisplayConfig.isSelected());
            }
        };
        configAction.putValue("SmallIcon", Icons.DISPLAY_CONFIG_ICON);
        configAction.putValue("Name", "");
        return configAction;
    }
}

