/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.gui.components.FeatureDisplaySelector;
import fiji.plugin.trackmate.gui.components.FilterGuiPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import java.awt.Container;
import java.util.List;
import javax.swing.JLabel;

public class TrackFilterDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "TrackFilter";
    private final TrackMate trackmate;
    private final DisplaySettings displaySettings;

    public TrackFilterDescriptor(TrackMate trackmate, List<FeatureFilter> filters, FeatureDisplaySelector featureSelector, DisplaySettings displaySettings) {
        super(KEY);
        this.trackmate = trackmate;
        this.displaySettings = displaySettings;
        FilterGuiPanel component = new FilterGuiPanel(trackmate.getModel(), trackmate.getSettings(), DisplaySettings.TrackMateObject.TRACKS, filters, "NUMBER_SPOTS", featureSelector);
        component.addChangeListener(e -> this.filterTracks());
        this.targetPanel = component;
    }

    private void filterTracks() {
        FilterGuiPanel component = (FilterGuiPanel)this.targetPanel;
        this.trackmate.getSettings().setTrackFilters(component.getFeatureFilters());
        this.trackmate.execTrackFiltering(false);
    }

    @Override
    public Runnable getForwardRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler((Container)TrackFilterDescriptor.this.targetPanel, new Class[]{JLabel.class});
                disabler.disable();
                try {
                    Model model = TrackFilterDescriptor.this.trackmate.getModel();
                    Logger logger = model.getLogger();
                    FilterGuiPanel panel = (FilterGuiPanel)TrackFilterDescriptor.this.targetPanel;
                    panel.showProgressBar(true);
                    logger.log("\n");
                    long start = System.currentTimeMillis();
                    Logger oldLogger = TrackFilterDescriptor.this.trackmate.getModel().getLogger();
                    TrackFilterDescriptor.this.trackmate.getModel().setLogger(panel.getLogger());
                    TrackFilterDescriptor.this.trackmate.computeEdgeFeatures(true);
                    TrackFilterDescriptor.this.trackmate.computeTrackFeatures(true);
                    long end = System.currentTimeMillis();
                    TrackFilterDescriptor.this.trackmate.getModel().setLogger(oldLogger);
                    if (TrackFilterDescriptor.this.trackmate.isCanceled()) {
                        logger.log("Spot feature calculation canceled.\nSome spots will have missing feature values.\n");
                    }
                    logger.log(String.format("Calculating features done in %.1f s.\n", Float.valueOf((float)(end - start) / 1000.0f)));
                    panel.showProgressBar(false);
                    TrackFilterDescriptor.this.displaySettings.setSpotColorBy(DisplaySettings.TrackMateObject.TRACKS, "TRACK_INDEX");
                    panel.refreshValues();
                    TrackFilterDescriptor.this.filterTracks();
                }
                finally {
                    disabler.reenable();
                }
            }
        };
    }

    @Override
    public void displayingPanel() {
        FilterGuiPanel component = (FilterGuiPanel)this.targetPanel;
        this.trackmate.getSettings().setTrackFilters(component.getFeatureFilters());
        this.trackmate.execTrackFiltering(false);
    }

    @Override
    public void aboutToHidePanel() {
        Logger logger = this.trackmate.getModel().getLogger();
        logger.log("\nPerforming track filtering on the following features:\n", Logger.BLUE_COLOR);
        Model model = this.trackmate.getModel();
        FilterGuiPanel component = (FilterGuiPanel)this.targetPanel;
        List<FeatureFilter> featureFilters = component.getFeatureFilters();
        this.trackmate.getSettings().setTrackFilters(featureFilters);
        this.trackmate.execTrackFiltering(false);
        int ntotal = model.getTrackModel().nTracks(false);
        if (featureFilters == null || featureFilters.isEmpty()) {
            logger.log("No feature threshold set, kept the " + ntotal + " tracks.\n");
        } else {
            for (FeatureFilter ft : featureFilters) {
                String str = "  - on " + this.trackmate.getModel().getFeatureModel().getTrackFeatureNames().get(ft.feature);
                str = ft.isAbove ? str + " above " : str + " below ";
                str = str + String.format("%.1f", ft.value);
                str = str + "\n";
                logger.log(str);
            }
            int nselected = model.getTrackModel().nTracks(true);
            logger.log("Kept " + nselected + " spots out of " + ntotal + ".\n");
        }
        SettingsPersistence.saveLastUsedSettings(this.trackmate.getSettings(), logger);
    }
}

