/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.jaqaman;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.ConfigurationPanel;
import fiji.plugin.trackmate.gui.components.tracker.SimpleLAPTrackerSettingsPanel;
import fiji.plugin.trackmate.tracking.SpotTrackerFactory;
import fiji.plugin.trackmate.tracking.jaqaman.SparseLAPTrackerFactory;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

@Plugin(type=SpotTrackerFactory.class)
public class SimpleSparseLAPTrackerFactory
extends SparseLAPTrackerFactory {
    public static final String THIS2_TRACKER_KEY = "SIMPLE_SPARSE_LAP_TRACKER";
    public static final String THIS2_NAME = "Simple LAP tracker";
    public static final String THIS2_INFO_TEXT = "<html>This tracker is identical to the sparse LAP tracker present in this trackmate, except that it <br>proposes fewer tuning options. Namely, only gap closing is allowed, based solely on <br>a distance and time condition. Track splitting and merging are not allowed, resulting <br>in having non-branching tracks. </html>";
    public static final String DOC_URL = "https://imagej.net/plugins/trackmate/trackers/lap-trackers";
    public static final ImageIcon ICON = new ImageIcon(Icons.class.getResource("images/SimpleLAPtracker-icon-64px.png"));

    @Override
    public String getKey() {
        return THIS2_TRACKER_KEY;
    }

    @Override
    public String getName() {
        return THIS2_NAME;
    }

    @Override
    public String getInfoText() {
        return THIS2_INFO_TEXT;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public String getUrl() {
        return DOC_URL;
    }

    @Override
    public ConfigurationPanel getTrackerConfigurationPanel(Model model) {
        String spaceUnits = model.getSpaceUnits();
        return new SimpleLAPTrackerSettingsPanel(this.getName(), THIS2_INFO_TEXT, spaceUnits);
    }
}

