/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.links;

import java.net.URI;
import java.util.Map;
import org.scijava.links.AbstractLinkHandler;
import org.scijava.links.LinkHandler;
import org.scijava.links.Links;
import org.scijava.log.LogLevel;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=LinkHandler.class)
public class HelloLinkHandler
extends AbstractLinkHandler {
    @Parameter(required=false)
    private LogService log;
    @Parameter(required=false)
    private UIService ui;

    public boolean supports(URI uri) {
        return "fiji".equals(uri.getScheme()) && uri.getHost().equals("hello");
    }

    public void handle(URI uri) {
        if (!this.supports(uri)) {
            throw new UnsupportedOperationException(String.valueOf(uri));
        }
        String operation = Links.operation((URI)uri);
        Map query = Links.query((URI)uri);
        String greeting = query.getOrDefault("greeting", "Hello!");
        String levelStr = query.getOrDefault("level", "info");
        int level = LogLevel.value(levelStr);
        if ("print".equals(operation)) {
            System.out.println(greeting);
        } else if ("log".equals(operation)) {
            if (this.log != null) {
                this.log.log(level, greeting);
            }
        } else if ("dialog".equals(operation)) {
            if (this.ui != null) {
                this.ui.showDialog(greeting);
            }
        } else {
            throw new UnsupportedOperationException("Unknown hello operation: " + operation);
        }
    }

    public static void main(String[] args) throws Exception {
        String s = "fiji://run/plugin?p=Bio-Formats&arg=open%3D%2Fhome%2Fcurtis%2Fdata%2Fimagej%2FFluorescentCells.jpg%20color_mode%3DDefault%20rois_import%3D%5BROI%20manager%5D%20view%3DHyperstack%20stack_order%3DXYCZT%20use_virtual_stack";
        URI uri = new URI(s);
        Map query = Links.query((URI)uri);
        System.out.println((String)query.get("arg"));
    }
}

