/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.links;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.scijava.io.IOService;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.io.location.URLLocation;
import org.scijava.links.AbstractLinkHandler;
import org.scijava.links.LinkHandler;
import org.scijava.links.Links;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=LinkHandler.class)
public class OpenLinkHandler
extends AbstractLinkHandler {
    @Parameter(required=false)
    private LogService log;
    @Parameter(required=false)
    private LocationService loc;
    @Parameter
    private IOService io;
    @Parameter(required=false)
    private UIService ui;

    public boolean supports(URI uri) {
        List<String> operations = Arrays.asList("file", "url", "source");
        return "fiji".equals(uri.getScheme()) && uri.getHost().equals("open") && operations.contains(Links.operation((URI)uri));
    }

    public void handle(URI uri) {
        block13: {
            if (!this.supports(uri)) {
                throw new UnsupportedOperationException(String.valueOf(uri));
            }
            String operation = Links.operation((URI)uri);
            Map query = Links.query((URI)uri);
            String p = (String)query.get("p");
            if (p == null) {
                if (this.log != null) {
                    this.log.error("No path given for URI: " + String.valueOf(uri));
                }
                return;
            }
            try {
                if ("file".equals(operation)) {
                    this.handleOpen(new FileLocation(p));
                    break block13;
                }
                if ("url".equals(operation)) {
                    Location location;
                    URL url = new URL(p);
                    if (this.loc == null) {
                        if (this.log != null) {
                            this.log.warn("No location service; falling back to hardcoded URLLocation for URI: " + String.valueOf(uri));
                        }
                        location = new URLLocation(url);
                    } else {
                        location = this.loc.resolve(url.toString());
                    }
                    this.handleOpen(location);
                    break block13;
                }
                if ("source".equals(operation)) {
                    if (this.loc == null) {
                        if (this.log != null) {
                            this.log.error("No location service; cannot resolve source string from URI: " + String.valueOf(uri));
                        }
                        return;
                    }
                    this.handleOpen(this.loc.resolve(p));
                    break block13;
                }
                throw new UnsupportedOperationException("Unknown open operation: " + operation);
            }
            catch (IOException | URISyntaxException e) {
                if (this.log == null) break block13;
                this.log.error(e);
            }
        }
    }

    private void handleOpen(Location location) throws IOException {
        Object result = this.io.open(location);
        if (this.ui != null) {
            this.ui.show(result);
        }
    }
}

