/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.mirror;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;

public class MirrorImage<T extends Type<T>>
implements Algorithm,
Benchmark,
MultiThreaded {
    String errorMessage = "";
    int numThreads;
    long processingTime = -1L;
    final Image<T> image;
    final int dimension;
    final int numDimensions;

    public MirrorImage(Image<T> image, int dimension) {
        this.image = image;
        this.dimension = dimension;
        this.numDimensions = image.getNumDimensions();
        this.setNumThreads();
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        long imageSize = this.image.getNumPixels();
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
        final int maxMirror = this.image.getDimension(this.dimension) - 1;
        final int sizeMirrorH = this.image.getDimension(this.dimension) / 2;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    LocalizableCursor cursorIn = MirrorImage.this.image.createLocalizableCursor();
                    LocalizableByDimCursor cursorOut = MirrorImage.this.image.createLocalizableByDimCursor();
                    Object temp = MirrorImage.this.image.createType();
                    int[] position = new int[MirrorImage.this.numDimensions];
                    long startPosition = myChunk.getStartPosition();
                    long loopSize = myChunk.getLoopSize();
                    if (startPosition > 0L) {
                        cursorIn.fwd(startPosition);
                    }
                    for (long i = 0L; i < loopSize; ++i) {
                        cursorIn.fwd();
                        cursorIn.getPosition(position);
                        if (position[MirrorImage.this.dimension] > sizeMirrorH) continue;
                        position[MirrorImage.this.dimension] = maxMirror - position[MirrorImage.this.dimension];
                        cursorOut.setPosition(position);
                        Object in = cursorIn.getType();
                        Object out = cursorOut.getType();
                        temp.set(in);
                        in.set(out);
                        out.set(temp);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public boolean checkInput() {
        if (this.image == null) {
            this.errorMessage = "Input image is null.";
            return false;
        }
        if (this.dimension < 0 || this.dimension >= this.numDimensions) {
            this.errorMessage = "Dimension to mirror is invalid: " + this.dimension;
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }
}

