/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.projection;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;

public class MaxProjection<T extends Comparable<T> & Type<T>>
implements OutputAlgorithm<T>,
Benchmark,
MultiThreaded {
    long processingTime;
    int numThreads;
    String errorMessage = "";
    final Image<T> image;
    final int projDim;
    Image<T> proj;

    public MaxProjection(Image<T> image, int dim) {
        this.image = image;
        this.projDim = dim;
        this.setNumThreads();
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        if (this.image.getNumDimensions() == 1) {
            int[] projImageSize = new int[]{1};
            this.proj = this.image.getImageFactory().createImage(projImageSize);
            LocalizableByDimCursor<T> inputIterator = this.image.createLocalizableByDimCursor();
            LocalizableCursor<T> projIterator = this.proj.createLocalizableCursor();
            Comparable maxValue = (Comparable)this.image.createType();
            Comparable tmpValue = (Comparable)this.image.createType();
            projIterator.fwd();
            inputIterator.fwd();
            ((Type)((Object)maxValue)).set(inputIterator.getType());
            while (inputIterator.hasNext()) {
                inputIterator.fwd();
                ((Type)((Object)tmpValue)).set(inputIterator.getType());
                if (tmpValue.compareTo(maxValue) <= 0) continue;
                ((Type)((Object)maxValue)).set((Type)((Object)tmpValue));
            }
            ((Type)((Object)((Comparable)projIterator.getType()))).set((Type)((Object)maxValue));
        } else {
            final int[] dimensions = this.image.getDimensions();
            int[] projImageSize = new int[dimensions.length - 1];
            int dim = 0;
            final int sizeProjection = dimensions[this.projDim];
            for (int d = 0; d < dimensions.length; ++d) {
                if (d == this.projDim) continue;
                projImageSize[dim++] = dimensions[d];
            }
            this.proj = this.image.getImageFactory().createImage(projImageSize);
            long imageSize = this.proj.getNumPixels();
            final AtomicInteger ai = new AtomicInteger(0);
            Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
            final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int myNumber = ai.getAndIncrement();
                        Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                        long start = myChunk.getStartPosition();
                        long loopSize = myChunk.getLoopSize();
                        LocalizableByDimCursor inputIterator = MaxProjection.this.image.createLocalizableByDimCursor();
                        LocalizableCursor projIterator = MaxProjection.this.proj.createLocalizableCursor();
                        int[] tmp = new int[MaxProjection.this.image.getNumDimensions()];
                        Comparable maxValue = (Comparable)MaxProjection.this.image.createType();
                        Comparable tmpValue = (Comparable)MaxProjection.this.image.createType();
                        projIterator.fwd(start);
                        for (long j = 0L; j < loopSize; ++j) {
                            projIterator.fwd();
                            int dim = 0;
                            for (int d = 0; d < dimensions.length; ++d) {
                                if (d == MaxProjection.this.projDim) continue;
                                tmp[d] = projIterator.getPosition(dim++);
                            }
                            tmp[MaxProjection.this.projDim] = 0;
                            inputIterator.setPosition(tmp);
                            ((Type)((Object)maxValue)).set(inputIterator.getType());
                            for (int i = 1; i < sizeProjection; ++i) {
                                inputIterator.fwd(MaxProjection.this.projDim);
                                ((Type)((Object)tmpValue)).set(inputIterator.getType());
                                if (tmpValue.compareTo(maxValue) <= 0) continue;
                                ((Type)((Object)maxValue)).set((Type)((Object)tmpValue));
                            }
                            ((Type)((Object)((Comparable)projIterator.getType()))).set((Type)((Object)maxValue));
                        }
                    }
                });
            }
            SimpleMultiThreading.startAndJoin(threads);
        }
        this.proj.setName("Max(" + this.projDim + ") " + this.image.getName());
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "MaxProjection: [Image<T> image] is null.";
            return false;
        }
        if (this.projDim < 0 || this.projDim >= this.image.getNumDimensions()) {
            this.errorMessage = "Invalid dimensionality for projection: " + this.projDim;
            return false;
        }
        return true;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Image<T> getResult() {
        return this.proj;
    }
}

