/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.util;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.container.basictypecontainer.array.ShortArray;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.type.numeric.real.FloatType;

public final class DevUtil {
    private DevUtil() {
    }

    public static final Image<UnsignedByteType> createImageFromArray(byte[] data, int[] dim) {
        ByteArray byteAccess = new ByteArray(data);
        Array<UnsignedByteType, ByteArray> array = new Array<UnsignedByteType, ByteArray>(new ArrayContainerFactory(), byteAccess, dim, 1);
        UnsignedByteType linkedType = new UnsignedByteType((DirectAccessContainer<UnsignedByteType, ? extends ByteAccess>)array);
        array.setLinkedType(linkedType);
        return new Image<UnsignedByteType>(array, new UnsignedByteType());
    }

    public static final Image<UnsignedShortType> createImageFromArray(short[] data, int[] dim) {
        ShortArray access = new ShortArray(data);
        Array<UnsignedShortType, ShortArray> array = new Array<UnsignedShortType, ShortArray>(new ArrayContainerFactory(), access, dim, 1);
        UnsignedShortType linkedType = new UnsignedShortType((DirectAccessContainer<UnsignedShortType, ? extends ShortAccess>)array);
        array.setLinkedType(linkedType);
        return new Image<UnsignedShortType>(array, new UnsignedShortType());
    }

    public static final Image<FloatType> createImageFromArray(float[] data, int[] dim) {
        FloatArray access = new FloatArray(data);
        Array<FloatType, FloatArray> array = new Array<FloatType, FloatArray>(new ArrayContainerFactory(), access, dim, 1);
        FloatType linkedType = new FloatType(array);
        array.setLinkedType(linkedType);
        return new Image<FloatType>(array, new FloatType());
    }

    public static final Image<DoubleType> createImageFromArray(double[] data, int[] dim) {
        DoubleArray access = new DoubleArray(data);
        Array<DoubleType, DoubleArray> array = new Array<DoubleType, DoubleArray>(new ArrayContainerFactory(), access, dim, 1);
        DoubleType linkedType = new DoubleType(array);
        array.setLinkedType(linkedType);
        return new Image<DoubleType>(array, new DoubleType());
    }
}

