/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.plugin.PlugIn;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class ROI_3D
implements PlugIn {
    public void run(String arg) {
        ImagePlus image = IJ.getImage();
        ImageCanvas canvas = image.getCanvas();
        image.setWindow((ImageWindow)new StackWindowWith3dRoi(image, canvas));
    }

    static class StackWindowWith3dRoi
    extends StackWindow {
        StackWindowWith3dRoi(ImagePlus image, ImageCanvas canvas) {
            super(image, canvas);
            int i = image.getCurrentSlice();
            this.sliceSelector.addAdjustmentListener(new Listener(i));
        }

        class Listener
        implements AdjustmentListener {
            Roi[] rois;
            int oldSlice;

            Listener(int currentSlice) {
                this.rois = new Roi[StackWindowWith3dRoi.this.imp.getStack().getSize() + 1];
                this.oldSlice = currentSlice;
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                this.rois[this.oldSlice] = StackWindowWith3dRoi.this.imp.getRoi();
                this.oldSlice = e.getValue();
                if (this.rois[this.oldSlice] == null) {
                    StackWindowWith3dRoi.this.imp.killRoi();
                } else {
                    StackWindowWith3dRoi.this.imp.setRoi(this.rois[this.oldSlice]);
                }
            }
        }
    }
}

