/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04;

import java.util.Arrays;
import java.util.Optional;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SpatialDatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.SpatialModifiable;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v04.coordinateTransformations.CoordinateTransformation;

public class NgffSingleScaleAxesMetadata
implements AxisMetadata,
N5SpatialDatasetMetadata,
SpatialModifiable<NgffSingleScaleAxesMetadata> {
    public static final String AXIS_KEY = "axes";
    public static final String COORDINATETRANSFORMATIONS_KEY = "coordinateTransformations";
    private final String path;
    private final Axis[] axes;
    private final CoordinateTransformation<?>[] coordinateTransformations;
    private final transient DatasetAttributes datasetAttributes;
    private final transient double[] scale;
    private final transient double[] translation;
    private final transient AffineGet transform;

    public NgffSingleScaleAxesMetadata(String path, double[] scale, double[] translation, DatasetAttributes datasetAttributes) {
        this(path, scale, translation, AxisUtils.defaultAxes(scale != null ? scale.length : translation.length), datasetAttributes);
    }

    public NgffSingleScaleAxesMetadata(String path, double[] scale, double[] translation, Axis[] axes, DatasetAttributes datasetAttributes) {
        this.path = MetadataUtils.normalizeGroupPath(path);
        this.scale = scale != null ? scale : NgffSingleScaleAxesMetadata.ones(axes.length);
        this.translation = translation != null ? translation : new double[axes.length];
        this.axes = axes;
        this.datasetAttributes = datasetAttributes;
        this.coordinateTransformations = MetadataUtils.buildScaleTranslationTransformList(this.scale, this.translation);
        if (Arrays.stream(axes).allMatch(x -> x.getType().equals("space"))) {
            this.transform = MetadataUtils.scaleTranslationTransforms(this.scale, this.translation);
        } else {
            int[] spaceIndexes = AxisUtils.indexes(axes, x -> x.getType().equals("space"));
            double[] spaceScale = AxisUtils.permute(this.scale, spaceIndexes);
            double[] spaceTranslation = AxisUtils.permute(this.translation, spaceIndexes);
            this.transform = MetadataUtils.scaleTranslationTransforms(spaceScale, spaceTranslation);
        }
    }

    private static double[] ones(int N) {
        double[] ones = new double[N];
        Arrays.fill(ones, 1.0);
        return ones;
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    public CoordinateTransformation<?>[] getCoordinateTransformations() {
        return this.coordinateTransformations;
    }

    @Override
    public DatasetAttributes getAttributes() {
        return this.datasetAttributes;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public double[] getScale() {
        return this.scale;
    }

    public double[] getTranslation() {
        return this.translation;
    }

    @Override
    public AffineGet spatialTransform() {
        return this.transform;
    }

    @Override
    public String unit() {
        Optional<Axis> firstSpace = Arrays.stream(this.axes).filter(x -> x.getType().equals("space")).findFirst();
        if (firstSpace.isPresent()) {
            return firstSpace.get().getUnit();
        }
        Optional<String> firstUnit = Arrays.stream(this.axes).filter(x -> {
            String unit = x.getUnit();
            return unit != null && unit.isEmpty();
        }).findFirst().map(x -> x.getUnit());
        return firstUnit.orElse("");
    }

    @Override
    public AffineTransform3D spatialTransform3d() {
        int i;
        int nd = 0;
        int[] spatialIndexes = new int[3];
        for (int i2 = 0; i2 < this.axes.length; ++i2) {
            if (!this.axes[i2].getType().equals("space")) continue;
            spatialIndexes[nd++] = i2;
        }
        AffineTransform3D transform3d = new AffineTransform3D();
        if (this.transform == null) {
            return transform3d;
        }
        if (this.transform instanceof AffineTransform3D) {
            return (AffineTransform3D)this.transform;
        }
        if (this.scale != null) {
            for (i = 0; i < nd; ++i) {
                transform3d.set(this.scale[spatialIndexes[i]], i, i);
            }
        }
        if (this.translation != null) {
            for (i = 0; i < nd; ++i) {
                transform3d.set(this.translation[spatialIndexes[i]], i, 3);
            }
        }
        return transform3d;
    }

    @Override
    public NgffSingleScaleAxesMetadata modifySpatialTransform(String newPath, AffineGet relativeTransformation) {
        int nd = this.axes.length;
        AffineTransform newTransform = new AffineTransform(nd);
        newTransform.preConcatenate(this.spatialTransform());
        newTransform.preConcatenate(relativeTransformation);
        double[] newScale = new double[nd];
        double[] newTranslation = new double[nd];
        int j = 0;
        for (int i = 0; i < nd; ++i) {
            newScale[i] = newTransform.get(j, j);
            newTranslation[i] = newTransform.get(j, nd);
            ++j;
        }
        return new NgffSingleScaleAxesMetadata(newPath, newScale, newTranslation, this.axes, this.datasetAttributes);
    }
}

