/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImageStack;
import ij.VirtualStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageProcessorUtils;
import net.imglib2.img.display.imagej.ImageStackUtils;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public abstract class AbstractVirtualStack
extends VirtualStack {
    private final int width;
    private final int height;
    private int size;
    private int offset;
    private final int bitDepth;
    private ColorModel colorModel;
    private Rectangle roi;
    private double min = 0.0;
    private double max = 1.0;

    public AbstractVirtualStack(int width, int height, int size, int bitDepth) {
        super(10, 10, null, "");
        this.width = width;
        this.height = height;
        this.offset = 0;
        this.size = size;
        this.bitDepth = bitDepth;
        this.colorModel = null;
        this.roi = new Rectangle(0, 0, width, height);
    }

    protected void setMinAndMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public final Object getPixels(int n) {
        return this.getPixelsZeroBasedIndex(this.toZeroBasedIndex(n));
    }

    public final void setPixels(Object pixels, int n) {
        if (this.isWritable()) {
            this.setPixelsZeroBasedIndex(this.toZeroBasedIndex(n), pixels);
        }
    }

    private int toZeroBasedIndex(int n) {
        return n - 1 + this.offset;
    }

    protected boolean isWritable() {
        return true;
    }

    protected abstract Object getPixelsZeroBasedIndex(int var1);

    protected abstract void setPixelsZeroBasedIndex(int var1, Object var2);

    protected RandomAccessibleInterval<?> getSliceZeroBasedIndex(int index) {
        Object pixels = this.getPixelsZeroBasedIndex(index);
        return ImageProcessorUtils.createImg(pixels, this.getWidth(), this.getHeight());
    }

    public ImageProcessor getProcessor(int n) {
        Object pixels = this.getPixels(n);
        ImageProcessor processor = ImageProcessorUtils.createImageProcessor(pixels, this.width, this.height, this.colorModel);
        if (this.min != Double.MAX_VALUE && !(processor instanceof ColorProcessor)) {
            processor.setMinAndMax(this.min, this.max);
        }
        return processor;
    }

    public void addSlice(String name) {
    }

    public void addSlice(String sliceLabel, Object pixels) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    public void deleteSlice(int n) {
        if (n == 1) {
            this.deleteFirstSlice();
        } else if (n == this.size) {
            this.deleteLastSlice();
        } else {
            throw new UnsupportedOperationException("AbstractVirtualStack only supports to delete first or last slice.");
        }
    }

    private void deleteFirstSlice() {
        --this.size;
        ++this.offset;
    }

    public void deleteLastSlice() {
        --this.size;
    }

    public int saveChanges(int n) {
        return -1;
    }

    public int getSize() {
        return this.size;
    }

    public String getSliceLabel(int n) {
        return Integer.toString(this.toZeroBasedIndex(n) + 1);
    }

    public Object[] getImageArray() {
        return null;
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String getDirectory() {
        return "";
    }

    public String getFileName(int n) {
        return "";
    }

    public void setBitDepth(int bitDepth) {
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public ImageStack sortDicom(String[] strings, String[] info, int maxDigits) {
        return this;
    }

    public void addSlice(ImageProcessor ip) {
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRoi(Rectangle roi) {
        this.roi = roi;
    }

    public Rectangle getRoi() {
        return this.roi;
    }

    public void update(ImageProcessor ip) {
        this.colorModel = ip.getColorModel();
    }

    public int size() {
        return this.size;
    }

    public String[] getSliceLabels() {
        return (String[])IntStream.range(0, this.size).mapToObj(this::getSliceLabel).toArray(String[]::new);
    }

    public String getShortSliceLabel(int n) {
        return this.getSliceLabel(n);
    }

    public void setProcessor(ImageProcessor ip, int n) {
        if (ip.getWidth() != this.width || ip.getHeight() != this.height) {
            throw new IllegalArgumentException("Wrong dimensions for this stack");
        }
        if (this.getBitDepth() != ip.getBitDepth()) {
            throw new IllegalArgumentException("Wrong type for this stack");
        }
        this.setPixels(ip.getPixels(), n);
    }

    public void setColorModel(ColorModel cm) {
        this.colorModel = cm;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public boolean isRGB() {
        return false;
    }

    public boolean isHSB() {
        return false;
    }

    public boolean isLab() {
        return false;
    }

    public String toString() {
        return super.toString();
    }

    public float[] getVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels) {
        return this.accessVoxels(x0, y0, z0, w, h, d, voxels, null, false);
    }

    public float[] getVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, int channel) {
        return this.accessVoxels(x0, y0, z0, w, h, d, voxels, channel, false);
    }

    public void setVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels) {
        if (this.isWritable()) {
            this.accessVoxels(x0, y0, z0, w, h, d, voxels, null, true);
        }
    }

    public void setVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, int channel) {
        if (this.isWritable()) {
            this.accessVoxels(x0, y0, z0, w, h, d, voxels, channel, true);
        }
    }

    private float[] accessVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, Integer optionalChannel, boolean setVoxel) {
        this.checkBounds(x0, y0, z0, w, h, d);
        if (!setVoxel) {
            voxels = this.checkResultArray(w, h, d, voxels);
        }
        BiConsumer<Object, FloatType> action = this.voxelAccessAction(optionalChannel, setVoxel);
        this.loopOverVoxels(x0, y0, z0, w, h, d, voxels, action);
        return voxels;
    }

    private void checkBounds(int x0, int y0, int z0, int w, int h, int d) {
        boolean inBounds;
        boolean bl = inBounds = x0 >= 0 && x0 + w <= this.width && y0 >= 0 && y0 + h <= this.height && z0 >= 0 && z0 + d <= this.size;
        if (!inBounds) {
            throw new IndexOutOfBoundsException();
        }
    }

    private float[] checkResultArray(int w, int h, int d, float[] voxels) {
        if (voxels == null || voxels.length != w * h * d) {
            voxels = new float[w * h * d];
        }
        return voxels;
    }

    private void loopOverVoxels(int x0, int y0, int z0, int w, int h, int d, float[] voxels, BiConsumer<Object, FloatType> action) {
        FinalInterval interval = Intervals.createMinSize((long[])new long[]{x0, y0, w, h});
        ArrayCursor output = ArrayImgs.floats((float[])voxels, (long[])new long[]{w, h, d}).cursor();
        for (int z = z0 + this.offset; z < z0 + this.offset + d; ++z) {
            Cursor cursor = Views.flatIterable((RandomAccessibleInterval)Views.interval(this.getSliceZeroBasedIndex(z), (Interval)interval)).cursor();
            while (cursor.hasNext()) {
                action.accept(cursor.next(), (FloatType)output.next());
            }
        }
    }

    private BiConsumer<?, FloatType> voxelAccessAction(Integer channel, boolean isSetVoxels) {
        if (this.bitDepth == 24) {
            return AbstractVirtualStack.arbgVoxelAccessAction(channel, isSetVoxels);
        }
        return isSetVoxels ? (a, b) -> a.setReal(b.getRealFloat()) : (a, b) -> b.setReal(a.getRealFloat());
    }

    private static BiConsumer<ARGBType, FloatType> arbgVoxelAccessAction(Integer channel, boolean isSetVoxel) {
        if (channel == null) {
            return isSetVoxel ? (a, b) -> a.set((int)b.getRealFloat()) : (a, b) -> b.set((float)a.get());
        }
        int shift = 8 * (2 - channel);
        int mask = ~(255 << shift);
        return isSetVoxel ? (a, b) -> a.set(a.get() & mask | ((int)b.get() & 0xFF) << shift) : (a, b) -> b.set((float)(a.get() >> shift & 0xFF));
    }

    public ImageStack duplicate() {
        return ImageStackUtils.duplicate((ImageStack)this);
    }

    public ImageStack crop(int x, int y, int z, int width, int height, int depth) {
        return ImageStackUtils.crop((ImageStack)this, x, y, z, width, height, depth);
    }

    public ImageStack convertToFloat() {
        return ImageStackUtils.convertToFloat((ImageStack)this);
    }
}

