/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation;

import hr.irb.fastRandomForest.FastRandomForest;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.Duplicator;
import ij.process.ByteProcessor;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jogamp.vecmath.Point3f;
import trainableSegmentation.FeatureStack;
import trainableSegmentation.FeatureStack3D;
import trainableSegmentation.FeatureStackArray;
import trainableSegmentation.ReusableDenseInstance;
import trainableSegmentation.Weka_Segmentation;
import trainableSegmentation.utils.Utils;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.classifiers.trees.RandomForest;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.pmml.PMMLFactory;
import weka.core.pmml.PMMLModel;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;
import weka.filters.supervised.instance.Resample;
import weka.gui.explorer.ClassifierPanel;

public class WekaSegmentation {
    public static final int MAX_NUM_CLASSES = 100;
    private Vector<ArrayList<Roi>>[] examples;
    private ImagePlus trainingImage;
    private ImagePlus classifiedImage;
    private FeatureStackArray featureStackArray = null;
    private Instances loadedTrainingData = null;
    private Instances traceTrainingData = null;
    private AbstractClassifier classifier = null;
    private Instances trainHeader = null;
    private FastRandomForest rf;
    private boolean updateFeatures = false;
    private boolean[] featureStackToUpdateTrain;
    private boolean[] featureStackToUpdateTest;
    private int numOfClasses = 0;
    private String[] classLabels = new String[100];
    private int numOfTrees = 200;
    private int randomFeatures = 2;
    private int maxDepth = 0;
    private ArrayList<String> loadedClassNames = null;
    private int membraneThickness = 1;
    private int membranePatchSize = 19;
    private float minimumSigma = 1.0f;
    private float maximumSigma = 16.0f;
    private boolean isProcessing3D = false;
    private FeatureStack3D fs3d = null;
    private boolean[] enabledFeatures = new boolean[]{true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private boolean[] enabled3Dfeatures = FeatureStack3D.getDefaultEnabledFeatures();
    private boolean useNeighbors = false;
    private ArrayList<String> featureNames = null;
    private boolean balanceClasses = false;
    private String projectFolder = null;
    private ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());

    public WekaSegmentation(ImagePlus trainingImage) {
        int i;
        for (i = 0; i < 100; ++i) {
            this.classLabels[i] = new String("class " + (i + 1));
        }
        this.trainingImage = trainingImage;
        this.rf = new FastRandomForest();
        this.rf.setNumTrees(this.numOfTrees);
        this.rf.setNumFeatures(this.randomFeatures);
        this.rf.setSeed(new Random().nextInt());
        this.rf.setNumThreads(Prefs.getThreads());
        this.classifier = this.rf;
        this.featureStackArray = new FeatureStackArray(trainingImage.getImageStackSize(), this.minimumSigma, this.maximumSigma, this.useNeighbors, this.membraneThickness, this.membranePatchSize, this.enabledFeatures);
        this.featureStackToUpdateTrain = new boolean[trainingImage.getImageStackSize()];
        this.featureStackToUpdateTest = new boolean[trainingImage.getImageStackSize()];
        Arrays.fill(this.featureStackToUpdateTest, true);
        this.examples = new Vector[trainingImage.getImageStackSize()];
        for (i = 0; i < trainingImage.getImageStackSize(); ++i) {
            this.examples[i] = new Vector(100);
            for (int j = 0; j < 100; ++j) {
                this.examples[i].add(new ArrayList());
            }
            this.featureStackArray.set(new FeatureStack(trainingImage.getImageStack().getProcessor(i + 1)), i);
        }
        this.addClass();
        this.addClass();
    }

    public WekaSegmentation() {
        for (int i = 0; i < 100; ++i) {
            this.classLabels[i] = new String("class " + (i + 1));
        }
        this.rf = new FastRandomForest();
        this.rf.setNumTrees(this.numOfTrees);
        this.rf.setNumFeatures(this.randomFeatures);
        this.rf.setSeed(new Random().nextInt());
        this.rf.setNumThreads(Prefs.getThreads());
        this.classifier = this.rf;
        this.addClass();
        this.addClass();
    }

    public WekaSegmentation(boolean isProcessing3D) {
        this();
        this.isProcessing3D = isProcessing3D;
        if (isProcessing3D) {
            this.maximumSigma = 8.0f;
        }
    }

    public void setTrainingImage(ImagePlus imp) {
        this.trainingImage = imp;
        this.featureStackArray = new FeatureStackArray(this.trainingImage.getImageStackSize(), this.minimumSigma, this.maximumSigma, this.useNeighbors, this.membraneThickness, this.membranePatchSize, this.enabledFeatures);
        this.featureStackToUpdateTrain = new boolean[this.trainingImage.getImageStackSize()];
        this.featureStackToUpdateTest = new boolean[this.trainingImage.getImageStackSize()];
        Arrays.fill(this.featureStackToUpdateTest, true);
        this.examples = new Vector[this.trainingImage.getImageStackSize()];
        for (int i = 0; i < this.trainingImage.getImageStackSize(); ++i) {
            this.examples[i] = new Vector(100);
            for (int j = 0; j < 100; ++j) {
                this.examples[i].add(new ArrayList());
            }
            if (this.isProcessing3D) continue;
            this.featureStackArray.set(new FeatureStack(this.trainingImage.getImageStack().getProcessor(i + 1)), i);
        }
        if (this.isProcessing3D) {
            this.fs3d = new FeatureStack3D(this.trainingImage);
            this.fs3d.setMaximumSigma(this.maximumSigma);
            this.fs3d.setMinimumSigma(this.minimumSigma);
            this.featureStackArray = this.fs3d.getFeatureStackArray();
        }
    }

    public void addExample(int classNum, Roi roi, int n) {
        if (!this.isProcessing3D && !this.featureStackToUpdateTrain[n - 1]) {
            boolean updated = false;
            for (ArrayList<Roi> list : this.examples[n - 1]) {
                if (list.isEmpty()) continue;
                updated = true;
                break;
            }
            if (!updated && this.featureStackToUpdateTest[n - 1]) {
                this.featureStackToUpdateTrain[n - 1] = true;
                this.featureStackToUpdateTest[n - 1] = false;
                this.updateFeatures = true;
            }
        }
        this.examples[n - 1].get(classNum).add(roi);
    }

    public void deleteExample(int classNum, int nSlice, int index) {
        this.getExamples(classNum, nSlice).remove(index);
    }

    public List<Roi> getExamples(int classNum, int n) {
        return this.examples[n - 1].get(classNum);
    }

    public void setHomogenizeClasses(boolean homogenizeClasses) {
        this.balanceClasses = homogenizeClasses;
    }

    public void setClassBalance(boolean balanceClasses) {
        this.balanceClasses = balanceClasses;
    }

    public void setNumOfClasses(int numOfClasses) {
        this.numOfClasses = numOfClasses;
    }

    public int getNumOfClasses() {
        return this.numOfClasses;
    }

    public void addClass() {
        if (null != this.trainingImage) {
            for (int i = 1; i <= this.trainingImage.getImageStackSize(); ++i) {
                this.examples[i - 1].add(new ArrayList());
            }
        }
        ++this.numOfClasses;
    }

    public void setClassLabel(int classNum, String label) {
        this.classLabels[classNum] = label;
    }

    public String getClassLabel(int classNum) {
        return this.classLabels[classNum];
    }

    public boolean loadTrainingData(String pathname) {
        IJ.log((String)("Loading data from " + pathname + "..."));
        this.loadedTrainingData = this.readDataFromARFF(pathname);
        if (null == this.loadedTrainingData) {
            IJ.log((String)("Unable to load training data from " + pathname));
            return false;
        }
        Enumeration attributes = this.loadedTrainingData.enumerateAttributes();
        String[] availableFeatures = this.isProcessing3D ? FeatureStack3D.availableFeatures : FeatureStack.availableFeatures;
        int numFeatures = availableFeatures.length;
        boolean[] usedFeatures = new boolean[numFeatures];
        while (attributes.hasMoreElements()) {
            Attribute a = (Attribute)attributes.nextElement();
            for (int i = 0; i < numFeatures; ++i) {
                if (!a.name().startsWith((this.isProcessing3D ? FeatureStack3D.availableFeatures : FeatureStack.availableFeatures)[i])) continue;
                usedFeatures[i] = true;
            }
        }
        Attribute classAttribute = this.loadedTrainingData.classAttribute();
        Enumeration classValues = classAttribute.enumerateValues();
        this.loadedClassNames = new ArrayList();
        int j = 0;
        while (classValues.hasMoreElements()) {
            String className = ((String)classValues.nextElement()).trim();
            this.loadedClassNames.add(className);
            IJ.log((String)("Read class name: " + className));
            if (!className.equals(this.getClassLabel(j))) {
                String guiClasses = this.getClassLabel(0);
                for (int i = 1; i < this.numOfClasses; ++i) {
                    guiClasses = guiClasses.concat(", " + this.getClassLabel(i));
                }
                String fileClasses = this.loadedClassNames.get(0);
                for (int i = 1; i < this.loadedClassNames.size(); ++i) {
                    fileClasses = fileClasses + ", " + this.loadedClassNames.get(i);
                }
                while (classValues.hasMoreElements()) {
                    fileClasses = fileClasses + ", " + ((String)classValues.nextElement()).trim();
                }
                IJ.error((String)"WekaSegmentation: load ARFF", (String)("<html><b>Error</b>: Loaded classes and current classes do not match:<ul><li>Expected names: <i>" + guiClasses + "</i><li>ARFF class names: <i>" + fileClasses + "</i></ul>Please adjust names in GUI before loading ARFF."));
                this.loadedTrainingData = null;
                return false;
            }
            ++j;
        }
        if (j != this.numOfClasses) {
            IJ.error((String)"WekaSegmentation: load ARFF", (String)"ERROR: Loaded number of classes and current number do not match!");
            this.loadedTrainingData = null;
            return false;
        }
        boolean featuresChanged = false;
        boolean[] oldEnableFeatures = this.enabledFeatures;
        for (int i = 0; i < numFeatures; ++i) {
            if (usedFeatures[i] == oldEnableFeatures[i]) continue;
            featuresChanged = true;
        }
        if (featuresChanged) {
            this.setEnabledFeatures(usedFeatures);
            this.updateFeatures = true;
        }
        if (!this.adjustSegmentationStateToData(this.loadedTrainingData)) {
            this.loadedTrainingData = null;
        } else {
            IJ.log((String)("Loaded data: " + this.loadedTrainingData.numInstances() + " instances (" + this.loadedTrainingData.numAttributes() + " attributes)"));
        }
        return true;
    }

    public Instances getLoadedTrainingData() {
        return this.loadedTrainingData;
    }

    public Instances getTraceTrainingData() {
        return this.traceTrainingData;
    }

    public ImagePlus getClassifiedImage() {
        return this.classifiedImage;
    }

    public Instances getTrainHeader() {
        return this.trainHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadedClassifier internalLoadClassifier(InputStream classifierInputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(classifierInputStream);
        LoadedClassifier lc = new LoadedClassifier();
        lc.newClassifier = (AbstractClassifier)objectInputStream.readObject();
        try {
            lc.newHeader = (Instances)objectInputStream.readObject();
        }
        finally {
            objectInputStream.close();
        }
        return lc;
    }

    public boolean loadClassifier(InputStream classifierInputStream) {
        assert (classifierInputStream != null);
        try {
            LoadedClassifier loadresult = this.internalLoadClassifier(classifierInputStream);
            return this.checkUpdateClassifier(loadresult.newClassifier, loadresult.newHeader);
        }
        catch (Exception e) {
            IJ.error((String)"Load Failed", (String)"Error while loading classifier");
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadClassifier(String filename) {
        Instances newHeader;
        PMMLClassifier newClassifier;
        block7: {
            newClassifier = null;
            newHeader = null;
            File selected = new File(filename);
            try {
                InputStream is = new FileInputStream(selected);
                if (selected.getName().endsWith(ClassifierPanel.PMML_FILE_EXTENSION)) {
                    PMMLModel model = PMMLFactory.getPMMLModel((InputStream)is, null);
                    if (model instanceof PMMLClassifier) {
                        newClassifier = (PMMLClassifier)model;
                        break block7;
                    }
                    throw new Exception("PMML model is not a classification/regression model!");
                }
                if (selected.getName().endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                try {
                    LoadedClassifier loadresult = this.internalLoadClassifier(is);
                    newHeader = loadresult.newHeader;
                    newClassifier = loadresult.newClassifier;
                }
                catch (Exception e) {
                    IJ.error((String)"Load Failed", (String)"Error while loading train header");
                    e.printStackTrace();
                    return false;
                }
            }
            catch (Exception e) {
                IJ.error((String)"Load Failed", (String)"Error while loading classifier");
                e.printStackTrace();
                return false;
            }
        }
        return this.checkUpdateClassifier((AbstractClassifier)newClassifier, newHeader);
    }

    private boolean checkUpdateClassifier(AbstractClassifier newClassifier, Instances newHeader) {
        try {
            if (null != this.trainingImage) {
                if (this.containsColorFeatures(newHeader)) {
                    if (this.trainingImage.getType() != 4) {
                        IJ.log((String)"Error: new classifier contains color features and training image is grayscale.");
                        return false;
                    }
                } else if (this.trainingImage.getType() == 4) {
                    IJ.log((String)"Error: new classifier was trained on grayscale images and training image is color.");
                    return false;
                }
            }
            if (this.containsExclusive2DFeatures(newHeader) && this.isProcessing3D) {
                IJ.log((String)"Error: new classifier was trained on 2D images and you are using Trainable Weka Segmentation 3D.");
                return false;
            }
            if (this.containsExclusive3DFeatures(newHeader) && !this.isProcessing3D) {
                IJ.log((String)"Error: new classifier was trained on 3D images and you are using Trainable Weka Segmentation 2D.");
                return false;
            }
            if (!this.adjustSegmentationStateToData(newHeader)) {
                IJ.log((String)"Error: current segmentator state could not be updated to loaded data requirements (attributes and classes)");
                return false;
            }
        }
        catch (Exception e) {
            IJ.log((String)"Error while adjusting data!");
            e.printStackTrace();
            return false;
        }
        this.classifier = newClassifier;
        this.trainHeader = newHeader;
        if (null != this.featureStackArray) {
            this.getFeatureStackArray().setOldHessianFormat(this.getModelVersion().startsWith("segment"));
            for (int i = 0; i < this.featureStackArray.getSize(); ++i) {
                if (!this.featureStackToUpdateTrain[i] || !this.featureStackArray.get(i).isEmpty()) continue;
                this.featureStackToUpdateTest[i] = true;
            }
        }
        return true;
    }

    public boolean containsColorFeatures(Instances data) {
        if (data.relationName().contains("RGB")) {
            return true;
        }
        Enumeration attributes = data.enumerateAttributes();
        while (attributes.hasMoreElements()) {
            Attribute a = (Attribute)attributes.nextElement();
            if (!a.name().equals("Hue") && !a.name().equals("Saturation") && !a.name().equals("Brightness")) continue;
            return true;
        }
        return false;
    }

    public boolean containsExclusive2DFeatures(Instances data) {
        int i;
        if (data.relationName().contains("2D")) {
            return true;
        }
        ArrayList<String> names2D = new ArrayList<String>();
        for (i = 0; i < FeatureStack.availableFeatures.length; ++i) {
            names2D.add(FeatureStack.availableFeatures[i]);
        }
        for (i = 0; i < FeatureStack3D.availableFeatures.length; ++i) {
            if (!names2D.contains(FeatureStack3D.availableFeatures[i])) continue;
            names2D.remove(FeatureStack3D.availableFeatures[i]);
        }
        Enumeration attributes = data.enumerateAttributes();
        while (attributes.hasMoreElements()) {
            Attribute a = (Attribute)attributes.nextElement();
            for (String s : names2D) {
                if (!a.name().startsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsExclusive3DFeatures(Instances data) {
        int i;
        if (data.relationName().contains("3D")) {
            return true;
        }
        ArrayList<String> names3D = new ArrayList<String>();
        for (i = 0; i < FeatureStack3D.availableFeatures.length; ++i) {
            names3D.add(FeatureStack3D.availableFeatures[i]);
        }
        for (i = 0; i < FeatureStack.availableFeatures.length; ++i) {
            if (!names3D.contains(FeatureStack.availableFeatures[i])) continue;
            names3D.remove(FeatureStack.availableFeatures[i]);
        }
        Enumeration attributes = data.enumerateAttributes();
        while (attributes.hasMoreElements()) {
            Attribute a = (Attribute)attributes.nextElement();
            for (String s : names3D) {
                if (!a.name().startsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public AbstractClassifier getClassifier() {
        return this.classifier;
    }

    public boolean saveClassifier(String filename) {
        File sFile = null;
        boolean saveOK = true;
        IJ.log((String)"Saving model to file...");
        try {
            sFile = new File(filename);
            OutputStream os = new FileOutputStream(sFile);
            if (sFile.getName().endsWith(".gz")) {
                os = new GZIPOutputStream(os);
            }
            saveOK = this.saveClassifier(os);
        }
        catch (Exception e) {
            IJ.error((String)"Save Failed", (String)"Error when saving classifier into a file");
            saveOK = false;
        }
        if (saveOK) {
            IJ.log((String)("Saved model into " + filename));
        }
        return saveOK;
    }

    public boolean saveClassifier(OutputStream os) {
        boolean saveOK = false;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
            objectOutputStream.writeObject(this.classifier);
            this.trainHeader = this.trainHeader.stringFreeStructure();
            if (this.trainHeader != null) {
                objectOutputStream.writeObject(this.trainHeader);
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            saveOK = true;
        }
        catch (IOException e) {
            IJ.error((String)"Save Failed", (String)"Error when saving classifier into an OutputStream");
        }
        return saveOK;
    }

    public boolean saveData(String pathname) {
        boolean examplesEmpty = true;
        block0: for (int i = 0; i < this.numOfClasses; ++i) {
            for (int n = 0; n < this.trainingImage.getImageStackSize(); ++n) {
                if (this.examples[n].get(i).isEmpty()) continue;
                examplesEmpty = false;
                continue block0;
            }
        }
        if (examplesEmpty && this.loadedTrainingData == null) {
            IJ.log((String)"There is no data to save");
            return false;
        }
        if (this.featureStackArray.isEmpty() || this.updateFeatures) {
            IJ.log((String)"Creating feature stack...");
            if (!this.isProcessing3D && !this.featureStackArray.updateFeaturesMT(this.featureStackToUpdateTrain)) {
                return false;
            }
            if (this.isProcessing3D) {
                if (!this.fs3d.updateFeaturesMT()) {
                    return false;
                }
                this.featureStackArray = this.fs3d.getFeatureStackArray();
            }
            Arrays.fill(this.featureStackToUpdateTrain, false);
            if (null != this.trainHeader) {
                this.featureStackArray.reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        Instances data = null;
        if (!examplesEmpty) {
            data = this.createTrainingInstances();
            data.setClassIndex(data.numAttributes() - 1);
        }
        if (null != this.loadedTrainingData && null != data) {
            IJ.log((String)"Merging data...");
            for (int i = 0; i < this.loadedTrainingData.numInstances(); ++i) {
                data.add(this.loadedTrainingData.instance(i));
            }
            IJ.log((String)("Finished: total number of instances = " + data.numInstances()));
        } else if (null == data) {
            data = this.loadedTrainingData;
        }
        IJ.log((String)("Writing training data: " + data.numInstances() + " instances..."));
        this.writeDataToARFF(data, pathname);
        IJ.log((String)("Saved training data: " + pathname));
        return true;
    }

    public void setUseNeighbors(boolean useNeighbors) {
        this.useNeighbors = useNeighbors;
        if (null != this.featureStackArray) {
            this.featureStackArray.setUseNeighbors(useNeighbors);
        }
    }

    public boolean addBinaryData(ImagePlus labelImage, FeatureStack featureStack, String className) {
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int classIndex = 0;
        for (classIndex = 0; classIndex < this.getClassLabels().length && !className.equalsIgnoreCase(this.getClassLabel(classIndex)); ++classIndex) {
        }
        if (classIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + className + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        ImageProcessor img = labelImage.getProcessor();
        int nl = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!(img.getPixelValue(x, y) > 0.0f)) continue;
                this.loadedTrainingData.add((Instance)featureStack.createInstance(x, y, classIndex));
                ++nl;
            }
        }
        IJ.log((String)("Added " + nl + " instances of '" + className + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addBinaryData(ImagePlus labelImage, FeatureStack featureStack, String className1, String className2) {
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int classIndex1 = 0;
        for (classIndex1 = 0; classIndex1 < this.getClassLabels().length && !className1.equalsIgnoreCase(this.getClassLabel(classIndex1)); ++classIndex1) {
        }
        if (classIndex1 == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + className1 + "' not found."));
            return false;
        }
        int classIndex2 = 0;
        for (classIndex2 = 0; classIndex2 < this.getClassLabels().length && !className2.equalsIgnoreCase(this.getClassLabel(classIndex2)); ++classIndex2) {
        }
        if (classIndex2 == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + className2 + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        ImageProcessor img = labelImage.getProcessor();
        int n1 = 0;
        int n2 = 0;
        int classIndex = -1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (img.getPixelValue(x, y) > 0.0f) {
                    classIndex = classIndex1;
                    ++n1;
                } else {
                    classIndex = classIndex2;
                    ++n2;
                }
                this.loadedTrainingData.add((Instance)featureStack.createInstance(x, y, classIndex));
            }
        }
        IJ.log((String)("Added " + n1 + " instances of '" + className1 + "'."));
        IJ.log((String)("Added " + n2 + " instances of '" + className2 + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addLabeledData(ImagePlus labelImage, FeatureStack featureStack) {
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        ImageProcessor img = labelImage.getProcessor();
        int[] numSamples = new int[this.numOfClasses];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int classIndex = (int)img.getf(x, y);
                if (classIndex < 0 || classIndex >= this.numOfClasses) continue;
                this.loadedTrainingData.add((Instance)featureStack.createInstance(x, y, classIndex));
                int n = classIndex;
                numSamples[n] = numSamples[n] + 1;
            }
        }
        for (int i = 0; i < this.numOfClasses; ++i) {
            IJ.log((String)("Added " + numSamples[i] + " instances of '" + this.loadedClassNames.get(i) + "'."));
        }
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedLabeledData(ImageProcessor labelImage, FeatureStack featureStack, int numSamples) {
        int i;
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (null == this.loadedTrainingData) {
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList[] classCoordinates = new ArrayList[this.numOfClasses];
        for (i = 0; i < this.numOfClasses; ++i) {
            classCoordinates[i] = new ArrayList();
        }
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int classIndex = (int)labelImage.getf(x, y) - 1;
                if (classIndex < 0 || classIndex >= this.numOfClasses) continue;
                classCoordinates[classIndex].add(new Point(x, y));
            }
        }
        Random rand = new Random();
        for (int i2 = 0; i2 < numSamples; ++i2) {
            for (int j = 0; j < this.numOfClasses; ++j) {
                if (classCoordinates[j].isEmpty()) continue;
                int randomSample = rand.nextInt(classCoordinates[j].size());
                this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)classCoordinates[j].get((int)randomSample)).x, ((Point)classCoordinates[j].get((int)randomSample)).y, j));
            }
        }
        for (int j = 0; j < this.numOfClasses; ++j) {
            IJ.log((String)("Added " + numSamples + " instances of '" + this.loadedClassNames.get(j) + "'."));
        }
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedLabeledData(ImageProcessor labelImage, int[] classIndexToLabel, FeatureStack featureStack, int numSamples) {
        int i;
        if (classIndexToLabel.length != this.numOfClasses) {
            IJ.log((String)"Error: number of classes and class/label correspondences do not match.");
            return false;
        }
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (null == this.loadedTrainingData) {
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList[] classCoordinates = new ArrayList[this.numOfClasses];
        for (i = 0; i < this.numOfClasses; ++i) {
            classCoordinates[i] = new ArrayList();
        }
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        HashMap<Integer, Integer> labelToClassIndex = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < classIndexToLabel.length; ++i2) {
            labelToClassIndex.put(classIndexToLabel[i2], i2);
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Integer classIndex = (Integer)labelToClassIndex.get((int)labelImage.getf(x, y));
                if (classIndex == null) continue;
                classCoordinates[classIndex].add(new Point(x, y));
            }
        }
        int[] numClassSamples = new int[this.numOfClasses];
        Random rand = new Random();
        for (int i3 = 0; i3 < numSamples; ++i3) {
            for (int j = 0; j < this.numOfClasses; ++j) {
                if (classCoordinates[j].isEmpty()) continue;
                int randomSample = rand.nextInt(classCoordinates[j].size());
                this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)classCoordinates[j].get((int)randomSample)).x, ((Point)classCoordinates[j].get((int)randomSample)).y, j));
                int n = j;
                numClassSamples[n] = numClassSamples[n] + 1;
            }
        }
        for (int j = 0; j < this.numOfClasses; ++j) {
            IJ.log((String)("Added " + numClassSamples[j] + " instances of '" + this.loadedClassNames.get(j) + "'."));
        }
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImageProcessor labelImage, FeatureStack featureStack, String whiteClassName, String blackClassName, int numSamples) {
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        int blackClassIndex = 0;
        for (blackClassIndex = 0; blackClassIndex < this.getClassLabels().length && !blackClassName.equalsIgnoreCase(this.getClassLabel(blackClassIndex)); ++blackClassIndex) {
        }
        if (blackClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + blackClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList<Point> blackCoordinates = new ArrayList<Point>();
        ArrayList<Point> whiteCoordinates = new ArrayList<Point>();
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (labelImage.getPixelValue(x, y) > 0.0f) {
                    whiteCoordinates.add(new Point(x, y));
                    continue;
                }
                blackCoordinates.add(new Point(x, y));
            }
        }
        if (whiteCoordinates.isEmpty()) {
            IJ.log((String)"Error: no white pixels found!");
            return false;
        }
        if (blackCoordinates.isEmpty()) {
            IJ.log((String)"Error: no black pixels found!");
            return false;
        }
        Random rand = new Random();
        for (int i = 0; i < numSamples; ++i) {
            int randomBlack = rand.nextInt(blackCoordinates.size());
            int randomWhite = rand.nextInt(whiteCoordinates.size());
            this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)blackCoordinates.get((int)randomBlack)).x, ((Point)blackCoordinates.get((int)randomBlack)).y, blackClassIndex));
            this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)whiteCoordinates.get((int)randomWhite)).x, ((Point)whiteCoordinates.get((int)randomWhite)).y, whiteClassIndex));
        }
        IJ.log((String)("Added " + numSamples + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Added " + numSamples + " instances of '" + blackClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedLabeledData(ImageProcessor labelImage, FeatureStack featureStack, String[] classNames, int numSamples) {
        int i;
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int[] classIndex = new int[classNames.length];
        for (int i2 = 0; i2 < classIndex.length; ++i2) {
            classIndex[i2] = 0;
            while (classIndex[i2] < this.getClassLabels().length && !classNames[i2].equalsIgnoreCase(this.getClassLabel(classIndex[i2]))) {
                int n = i2;
                classIndex[n] = classIndex[n] + 1;
            }
            if (classIndex[i2] != this.getClassLabels().length) continue;
            IJ.log((String)("Error: class named '" + classNames[i2] + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i3;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i3 = 1; i3 <= featureStack.getSize(); ++i3) {
                String attString = featureStack.getSliceLabel(i3);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i3 = 0; i3 < 8; ++i3) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i3 + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i3 + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i3 = 0; i3 < this.numOfClasses; ++i3) {
                this.loadedClassNames.add(this.getClassLabel(i3));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList[] classCoordinates = new ArrayList[classNames.length];
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int val = (int)labelImage.getf(x, y);
                if (val < 0 || val >= classNames.length) continue;
                classCoordinates[val].add(new Point(x, y));
            }
        }
        Random rand = new Random();
        for (i = 0; i < numSamples; ++i) {
            for (int j = 0; j < classIndex.length; ++j) {
                int randomIndex = rand.nextInt(classCoordinates[j].size());
                this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)classCoordinates[j].get((int)randomIndex)).x, ((Point)classCoordinates[j].get((int)randomIndex)).y, classIndex[j]));
            }
        }
        for (i = 0; i < classNames.length; ++i) {
            IJ.log((String)("Added " + numSamples + " instances of '" + classNames[i] + "'."));
        }
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addLabeledData(ImageProcessor labelImage, FeatureStack featureStack, String[] classNames, int numSamples) {
        int i;
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int[] classIndex = new int[classNames.length];
        for (int i2 = 0; i2 < classIndex.length; ++i2) {
            classIndex[i2] = 0;
            while (classIndex[i2] < this.getClassLabels().length && !classNames[i2].equalsIgnoreCase(this.getClassLabel(classIndex[i2]))) {
                int n = i2;
                classIndex[n] = classIndex[n] + 1;
            }
            if (classIndex[i2] != this.getClassLabels().length) continue;
            IJ.log((String)("Error: class named '" + classNames[i2] + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i3;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i3 = 1; i3 <= featureStack.getSize(); ++i3) {
                String attString = featureStack.getSliceLabel(i3);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i3 = 0; i3 < 8; ++i3) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i3 + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i3 + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i3 = 0; i3 < this.numOfClasses; ++i3) {
                this.loadedClassNames.add(this.getClassLabel(i3));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        int size = labelImage.getWidth() * labelImage.getHeight();
        int[] numClassSamples = new int[classNames.length];
        Random rand = new Random();
        for (i = 0; i < numSamples; ++i) {
            int randomIndex = rand.nextInt(size);
            int c = (int)labelImage.getf(randomIndex);
            if (c < 0 || c >= classNames.length) continue;
            int x = randomIndex % labelImage.getWidth();
            int y = randomIndex / labelImage.getWidth();
            this.loadedTrainingData.add((Instance)featureStack.createInstance(x, y, classIndex[c]));
            int n = c;
            numClassSamples[n] = numClassSamples[n] + 1;
        }
        for (i = 0; i < classNames.length; ++i) {
            IJ.log((String)("Added " + numClassSamples[i] + " instances of '" + classNames[i] + "'."));
        }
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addLabeledData(ImageProcessor labelImage, FeatureStack featureStack, int[] classIndexToLabel, int numSamples) {
        int i;
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (classIndexToLabel.length != this.numOfClasses) {
            IJ.log((String)"Error: number of classes and class/label correspondences do not match.");
            return false;
        }
        HashMap<Integer, Integer> labelToClassIndex = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < classIndexToLabel.length; ++i2) {
            labelToClassIndex.put(classIndexToLabel[i2], i2);
        }
        if (null == this.loadedTrainingData) {
            int i3;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i3 = 1; i3 <= featureStack.getSize(); ++i3) {
                String attString = featureStack.getSliceLabel(i3);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i3 = 0; i3 < 8; ++i3) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i3 + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i3 + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i3 = 0; i3 < this.numOfClasses; ++i3) {
                this.loadedClassNames.add(this.getClassLabel(i3));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        int size = labelImage.getWidth() * labelImage.getHeight();
        int[] numClassSamples = new int[classIndexToLabel.length];
        Random rand = new Random();
        for (i = 0; i < numSamples; ++i) {
            int randomIndex = rand.nextInt(size);
            int c = (int)labelImage.getf(randomIndex);
            if (labelToClassIndex.get(c) == null) continue;
            int x = randomIndex % labelImage.getWidth();
            int y = randomIndex / labelImage.getWidth();
            this.loadedTrainingData.add((Instance)featureStack.createInstance(x, y, (Integer)labelToClassIndex.get(c)));
            int n = (Integer)labelToClassIndex.get(c);
            numClassSamples[n] = numClassSamples[n] + 1;
        }
        for (i = 0; i < classIndexToLabel.length; ++i) {
            IJ.log((String)("Added " + numClassSamples[i] + " instances of '" + this.classLabels[i] + "'."));
        }
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImageProcessor labelImage, ImageProcessor mask, FeatureStack featureStack, String whiteClassName, String blackClassName, int numSamples) {
        int x;
        int y;
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        int blackClassIndex = 0;
        for (blackClassIndex = 0; blackClassIndex < this.getClassLabels().length && !blackClassName.equalsIgnoreCase(this.getClassLabel(blackClassIndex)); ++blackClassIndex) {
        }
        if (blackClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + blackClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList<Point> blackCoordinates = new ArrayList<Point>();
        ArrayList<Point> whiteCoordinates = new ArrayList<Point>();
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        if (null != mask) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!(mask.getPixelValue(x, y) > 0.0f)) continue;
                    if (labelImage.getPixelValue(x, y) > 0.0f) {
                        whiteCoordinates.add(new Point(x, y));
                        continue;
                    }
                    blackCoordinates.add(new Point(x, y));
                }
            }
        } else {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (labelImage.getPixelValue(x, y) > 0.0f) {
                        whiteCoordinates.add(new Point(x, y));
                        continue;
                    }
                    blackCoordinates.add(new Point(x, y));
                }
            }
        }
        Random rand = new Random();
        for (int i = 0; i < numSamples; ++i) {
            int randomBlack = rand.nextInt(blackCoordinates.size());
            int randomWhite = rand.nextInt(whiteCoordinates.size());
            this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)blackCoordinates.get((int)randomBlack)).x, ((Point)blackCoordinates.get((int)randomBlack)).y, blackClassIndex));
            this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)whiteCoordinates.get((int)randomWhite)).x, ((Point)whiteCoordinates.get((int)randomWhite)).y, whiteClassIndex));
        }
        IJ.log((String)("Added " + numSamples + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Added " + numSamples + " instances of '" + blackClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedBinaryData(List<Point3f>[] classPoints, FeatureStackArray fsa, String whiteClassName, String blackClassName, int numSamples) {
        int i;
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        int blackClassIndex = 0;
        for (blackClassIndex = 0; blackClassIndex < this.getClassLabels().length && !blackClassName.equalsIgnoreCase(this.getClassLabel(blackClassIndex)); ++blackClassIndex) {
        }
        if (blackClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + blackClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= fsa.getNumOfFeatures(); ++i) {
                String attString = fsa.getLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (fsa.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        Random rand = new Random();
        for (i = 0; i < numSamples; ++i) {
            int randomBlack = rand.nextInt(classPoints[0].size());
            int randomWhite = rand.nextInt(classPoints[1].size());
            this.loadedTrainingData.add((Instance)fsa.get((int)classPoints[0].get((int)randomBlack).z).createInstance((int)classPoints[0].get((int)randomBlack).x, (int)classPoints[0].get((int)randomBlack).y, blackClassIndex));
            this.loadedTrainingData.add((Instance)fsa.get((int)classPoints[1].get((int)randomWhite).z).createInstance((int)classPoints[1].get((int)randomWhite).x, (int)classPoints[1].get((int)randomWhite).y, whiteClassIndex));
        }
        IJ.log((String)("Added " + numSamples + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Added " + numSamples + " instances of '" + blackClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addBinaryData(List<Point3f>[] classPoints, FeatureStackArray fsa, String whiteClassName, String blackClassName) {
        int i;
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        int blackClassIndex = 0;
        for (blackClassIndex = 0; blackClassIndex < this.getClassLabels().length && !blackClassName.equalsIgnoreCase(this.getClassLabel(blackClassIndex)); ++blackClassIndex) {
        }
        if (blackClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + blackClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i2;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i2 = 1; i2 <= fsa.getNumOfFeatures(); ++i2) {
                String attString = fsa.getLabel(i2);
                attributes.add(new Attribute(attString));
            }
            if (fsa.useNeighborhood()) {
                for (i2 = 0; i2 < 8; ++i2) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i2 + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i2 + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i2 = 0; i2 < this.numOfClasses; ++i2) {
                this.loadedClassNames.add(this.getClassLabel(i2));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        for (i = 0; i < classPoints[0].size(); ++i) {
            this.loadedTrainingData.add((Instance)fsa.get((int)classPoints[0].get((int)i).z).createInstance((int)classPoints[0].get((int)i).x, (int)classPoints[0].get((int)i).y, blackClassIndex));
        }
        for (i = 0; i < classPoints[1].size(); ++i) {
            this.loadedTrainingData.add((Instance)fsa.get((int)classPoints[1].get((int)i).z).createInstance((int)classPoints[1].get((int)i).x, (int)classPoints[1].get((int)i).y, whiteClassIndex));
        }
        IJ.log((String)("Added " + classPoints[1].size() + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Added " + classPoints[0].size() + " instances of '" + blackClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedBinaryData(List<Point3f>[] classPoints, FeatureStackArray fsa, ImagePlus weights, String whiteClassName, String blackClassName, int numSamples) {
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        int blackClassIndex = 0;
        for (blackClassIndex = 0; blackClassIndex < this.getClassLabels().length && !blackClassName.equalsIgnoreCase(this.getClassLabel(blackClassIndex)); ++blackClassIndex) {
        }
        if (blackClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + blackClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= fsa.getNumOfFeatures(); ++i) {
                String attString = fsa.getLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (fsa.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        int width = weights.getWidth();
        Random rand = new Random();
        for (int i = 0; i < numSamples; ++i) {
            int randomBlack = rand.nextInt(classPoints[0].size());
            int randomWhite = rand.nextInt(classPoints[1].size());
            int blackZ = (int)classPoints[0].get((int)randomBlack).z;
            int blackX = (int)classPoints[0].get((int)randomBlack).x;
            int blackY = (int)classPoints[0].get((int)randomBlack).y;
            DenseInstance blackInstance = fsa.get(blackZ).createInstance(blackX, blackY, blackClassIndex);
            blackInstance.setWeight((double)((float[])weights.getImageStack().getProcessor(blackZ + 1).getPixels())[blackX + blackY * width]);
            this.loadedTrainingData.add((Instance)blackInstance);
            int whiteZ = (int)classPoints[1].get((int)randomWhite).z;
            int whiteX = (int)classPoints[1].get((int)randomWhite).x;
            int whiteY = (int)classPoints[1].get((int)randomWhite).y;
            DenseInstance whiteInstance = fsa.get(whiteZ).createInstance(whiteX, whiteY, whiteClassIndex);
            whiteInstance.setWeight((double)((float[])weights.getImageStack().getProcessor(whiteZ + 1).getPixels())[whiteX + whiteY * width]);
            this.loadedTrainingData.add((Instance)whiteInstance);
        }
        IJ.log((String)("Added " + numSamples + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Added " + numSamples + " instances of '" + blackClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImageProcessor labelImage, ImageProcessor mask, ImageProcessor weights, FeatureStack featureStack, String whiteClassName, String blackClassName, int numSamples) {
        int x;
        int y;
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        int blackClassIndex = 0;
        for (blackClassIndex = 0; blackClassIndex < this.getClassLabels().length && !blackClassName.equalsIgnoreCase(this.getClassLabel(blackClassIndex)); ++blackClassIndex) {
        }
        if (blackClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + blackClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList<Point> blackCoordinates = new ArrayList<Point>();
        ArrayList<Point> whiteCoordinates = new ArrayList<Point>();
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        if (null != mask) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (!(mask.getPixelValue(x, y) > 0.0f)) continue;
                    if (labelImage.getPixelValue(x, y) > 0.0f) {
                        whiteCoordinates.add(new Point(x, y));
                        continue;
                    }
                    blackCoordinates.add(new Point(x, y));
                }
            }
        } else {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (labelImage.getPixelValue(x, y) > 0.0f) {
                        whiteCoordinates.add(new Point(x, y));
                        continue;
                    }
                    blackCoordinates.add(new Point(x, y));
                }
            }
        }
        Random rand = new Random();
        for (int i = 0; i < numSamples; ++i) {
            int randomBlack = rand.nextInt(blackCoordinates.size());
            int randomWhite = rand.nextInt(whiteCoordinates.size());
            DenseInstance blackSample = featureStack.createInstance(((Point)blackCoordinates.get((int)randomBlack)).x, ((Point)blackCoordinates.get((int)randomBlack)).y, blackClassIndex);
            blackSample.setWeight((double)weights.getPixelValue(((Point)blackCoordinates.get((int)randomBlack)).x, ((Point)blackCoordinates.get((int)randomBlack)).y));
            this.loadedTrainingData.add((Instance)blackSample);
            DenseInstance whiteSample = featureStack.createInstance(((Point)whiteCoordinates.get((int)randomWhite)).x, ((Point)whiteCoordinates.get((int)randomWhite)).y, whiteClassIndex);
            whiteSample.setWeight((double)weights.getPixelValue(((Point)whiteCoordinates.get((int)randomWhite)).x, ((Point)whiteCoordinates.get((int)randomWhite)).y));
            this.loadedTrainingData.add((Instance)whiteSample);
        }
        IJ.log((String)("Added " + numSamples + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Added " + numSamples + " instances of '" + blackClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public boolean addRandomData(ImagePlus labelImage, FeatureStack featureStack, String whiteClassName, int numSamples) {
        if (featureStack.getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        int whiteClassIndex = 0;
        for (whiteClassIndex = 0; whiteClassIndex < this.getClassLabels().length && !whiteClassName.equalsIgnoreCase(this.getClassLabel(whiteClassIndex)); ++whiteClassIndex) {
        }
        if (whiteClassIndex == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + whiteClassName + "' not found."));
            return false;
        }
        if (null == this.loadedTrainingData) {
            int i;
            IJ.log((String)"Initializing loaded data...");
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (i = 1; i <= featureStack.getSize(); ++i) {
                String attString = featureStack.getSliceLabel(i);
                attributes.add(new Attribute(attString));
            }
            if (featureStack.useNeighborhood()) {
                for (i = 0; i < 8; ++i) {
                    IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                    attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
                }
            }
            this.loadedClassNames = new ArrayList();
            for (i = 0; i < this.numOfClasses; ++i) {
                this.loadedClassNames.add(this.getClassLabel(i));
            }
            attributes.add(new Attribute("class", this.loadedClassNames));
            this.loadedTrainingData = new Instances("segment", attributes, 1);
            this.loadedTrainingData.setClassIndex(this.loadedTrainingData.numAttributes() - 1);
        }
        ArrayList<Point> whiteCoordinates = new ArrayList<Point>();
        int width = labelImage.getWidth();
        int height = labelImage.getHeight();
        ImageProcessor img = labelImage.getProcessor();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!(img.getPixelValue(x, y) > 0.0f)) continue;
                whiteCoordinates.add(new Point(x, y));
            }
        }
        Random rand = new Random();
        for (int i = 0; i < numSamples; ++i) {
            int randomWhite = rand.nextInt(whiteCoordinates.size());
            this.loadedTrainingData.add((Instance)featureStack.createInstance(((Point)whiteCoordinates.get((int)randomWhite)).x, ((Point)whiteCoordinates.get((int)randomWhite)).y, whiteClassIndex));
        }
        IJ.log((String)("Added " + numSamples + " instances of '" + whiteClassName + "'."));
        IJ.log((String)("Training dataset updated (" + this.loadedTrainingData.numInstances() + " instances, " + this.loadedTrainingData.numAttributes() + " attributes, " + this.loadedTrainingData.numClasses() + " classes)."));
        return true;
    }

    public FeatureStack getFeatureStack(int i) {
        return this.featureStackArray.get(i - 1);
    }

    public FeatureStackArray getFeatureStackArray() {
        return this.featureStackArray;
    }

    public Instances getTrainingInstances() {
        return this.loadedTrainingData;
    }

    public void setClassifier(AbstractClassifier cls) {
        this.classifier = cls;
    }

    public boolean setTrainHeader(Instances newHeader) {
        if (null == newHeader || this.adjustSegmentationStateToData(newHeader)) {
            this.trainHeader = newHeader;
            return true;
        }
        return false;
    }

    public boolean loadNewImage(ImagePlus newImage) {
        IJ.log((String)"Storing previous image instances...");
        if (this.featureStackArray.isEmpty() || this.updateFeatures) {
            IJ.log((String)"Creating feature stack...");
            if (!this.featureStackArray.updateFeaturesMT(this.featureStackToUpdateTrain)) {
                return false;
            }
            Arrays.fill(this.featureStackToUpdateTrain, false);
            if (null != this.trainHeader) {
                this.featureStackArray.reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        Instances data = this.createTrainingInstances();
        if (null != this.loadedTrainingData && null != data) {
            data.setClassIndex(data.numAttributes() - 1);
            IJ.log((String)"Merging data...");
            for (int i = 0; i < this.loadedTrainingData.numInstances(); ++i) {
                data.add(this.loadedTrainingData.instance(i));
            }
            IJ.log((String)"Finished");
        } else if (null == data) {
            data = this.loadedTrainingData;
        }
        this.loadedTrainingData = data;
        if (null != this.loadedTrainingData) {
            Attribute classAttribute = this.loadedTrainingData.classAttribute();
            Enumeration classValues = classAttribute.enumerateValues();
            this.loadedClassNames = new ArrayList();
            while (classValues.hasMoreElements()) {
                String className = ((String)classValues.nextElement()).trim();
                this.loadedClassNames.add(className);
            }
            IJ.log((String)("Number of accumulated examples: " + this.loadedTrainingData.numInstances()));
        } else {
            IJ.log((String)"Number of accumulated examples: 0");
        }
        IJ.log((String)"Updating image...");
        this.trainingImage = new ImagePlus("Advanced Weka Segmentation", newImage.getImageStack());
        this.featureStackArray = new FeatureStackArray(this.trainingImage.getImageStackSize(), this.minimumSigma, this.maximumSigma, this.useNeighbors, this.membraneThickness, this.membranePatchSize, this.enabledFeatures);
        IJ.log((String)"Removing previous markings...");
        this.examples = new Vector[this.trainingImage.getImageStackSize()];
        for (int i = 0; i < this.trainingImage.getImageStackSize(); ++i) {
            this.examples[i] = new Vector(100);
            for (int j = 0; j < 100; ++j) {
                this.examples[i].add(new ArrayList());
            }
            this.featureStackArray.set(new FeatureStack(this.trainingImage.getImageStack().getProcessor(i + 1)), i);
        }
        this.featureStackToUpdateTrain = new boolean[this.trainingImage.getImageStackSize()];
        this.featureStackToUpdateTest = new boolean[this.trainingImage.getImageStackSize()];
        Arrays.fill(this.featureStackToUpdateTest, true);
        this.updateFeatures = true;
        this.classifiedImage = null;
        IJ.log((String)("New image: " + newImage.getTitle() + " (" + this.trainingImage.getImageStackSize() + " slice(s))"));
        IJ.log((String)"Done");
        return true;
    }

    public boolean addCenterLinesBinaryData(ImagePlus labelImage, int n, String whiteClassName, String blackClassName) {
        if (this.featureStackArray.get(n).getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            this.featureStackArray.get(n).updateFeaturesMT();
            if (null != this.trainHeader) {
                this.featureStackArray.get(n).reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (labelImage.getWidth() != this.trainingImage.getWidth() || labelImage.getHeight() != this.trainingImage.getHeight()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImagePlus whiteIP = new ImagePlus("white", labelImage.getProcessor().duplicate());
        IJ.run((ImagePlus)whiteIP, (String)"Skeletonize", (String)"");
        if (!this.addBinaryData(whiteIP, this.featureStackArray.get(n), whiteClassName)) {
            IJ.log((String)"Error while loading white class center-lines data.");
            return false;
        }
        ImagePlus blackIP = new ImagePlus("black", labelImage.getProcessor().duplicate());
        IJ.run((ImagePlus)blackIP, (String)"Invert", (String)"");
        IJ.run((ImagePlus)blackIP, (String)"Skeletonize", (String)"");
        if (!this.addBinaryData(blackIP, this.featureStackArray.get(n), blackClassName)) {
            IJ.log((String)"Error while loading black class center-lines data.");
            return false;
        }
        return true;
    }

    public void filterFeatureStackByList() {
        if (null == this.featureNames) {
            return;
        }
        for (int i = 1; i <= this.featureStackArray.getNumOfFeatures(); ++i) {
            String featureName = this.featureStackArray.getLabel(i);
            if (this.featureNames.contains(featureName)) continue;
            for (int j = 0; j < this.featureStackArray.getSize(); ++j) {
                this.featureStackArray.get(j).removeFeature(featureName);
            }
            --i;
        }
    }

    public static void filterFeatureStackByList(ArrayList<String> featureNames, FeatureStack featureStack) {
        if (null == featureNames) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        IJ.log((String)"Filtering feature stack by selected attributes...");
        for (int i = 1; i <= featureStack.getSize(); ++i) {
            String featureName = featureStack.getSliceLabel(i);
            if (featureNames.contains(featureName)) continue;
            featureStack.removeFeature(featureName);
            --i;
        }
    }

    public boolean addBinaryData(ImagePlus labelImage, int n, String whiteClassName, String blackClassName) {
        if (this.featureStackArray.get(n).getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            this.featureStackArray.get(n).updateFeaturesMT();
            if (null != this.trainHeader) {
                this.featureStackArray.get(n).reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (labelImage.getWidth() != this.trainingImage.getWidth() || labelImage.getHeight() != this.trainingImage.getHeight()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImagePlus labelIP = new ImagePlus("labels", labelImage.getProcessor().duplicate());
        labelIP.getProcessor().threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP.getProcessor()).max / 2.0));
        if (!this.addBinaryData(labelIP, this.featureStackArray.get(n), whiteClassName, blackClassName)) {
            IJ.log((String)"Error while loading binary label data.");
            return false;
        }
        return true;
    }

    public boolean addBinaryData(ImagePlus inputImage, ImagePlus labelImage, String whiteClassName, String blackClassName) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImagePlus labelIP = new ImagePlus("labels", labelSlices.getProcessor(i).duplicate());
            labelIP.getProcessor().threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP.getProcessor()).max / 2.0));
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addBinaryData(labelIP, featureStack, whiteClassName, blackClassName)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addLabeledData(ImagePlus inputImage, ImagePlus labelImage) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImagePlus labelIP = new ImagePlus("labels", labelSlices.getProcessor(i).duplicate());
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addLabeledData(labelIP, featureStack)) continue;
            IJ.log((String)("Error while loading labeled data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImagePlus inputImage, ImagePlus labelImage, String whiteClassName, String blackClassName, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        FeatureStackArray featureStackArray = null;
        if (this.isProcessing3D) {
            FeatureStack3D fs3d = new FeatureStack3D(inputImage);
            fs3d.setMaximumSigma(this.maximumSigma);
            fs3d.setMinimumSigma(this.minimumSigma);
            fs3d.setEnableFeatures(this.enabled3Dfeatures);
            if (!fs3d.updateFeaturesMT()) {
                IJ.log((String)"Feature stack 3D was not updated.");
                IJ.showStatus((String)"Feature stack 3D was not updated.");
                return false;
            }
            featureStackArray = fs3d.getFeatureStackArray();
            if (null != this.trainHeader) {
                featureStackArray.reorderFeatures(this.trainHeader);
            }
        }
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            FeatureStack featureStack;
            ImageProcessor labelIP = labelSlices.getProcessor(i).duplicate();
            labelIP.threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP).max / 2.0));
            if (this.isProcessing3D) {
                featureStack = featureStackArray.get(i - 1);
            } else {
                featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
                featureStack.setEnabledFeatures(this.enabledFeatures);
                featureStack.setMembranePatchSize(this.membranePatchSize);
                featureStack.setMembraneSize(this.membraneThickness);
                featureStack.setMaximumSigma(this.maximumSigma);
                featureStack.setMinimumSigma(this.minimumSigma);
                featureStack.setUseNeighbors(this.useNeighbors);
                IJ.log((String)("Creating feature stack for slice " + i + "..."));
                featureStack.updateFeaturesMT();
                if (null != this.trainHeader) {
                    featureStack.reorderFeatures(this.trainHeader);
                }
                WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
                IJ.log((String)"Feature stack is now updated.");
            }
            if (this.addRandomBalancedBinaryData(labelIP, featureStack, whiteClassName, blackClassName, numSamples)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedLabeledData(ImagePlus inputImage, ImagePlus labelImage, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addRandomBalancedLabeledData(labelSlices.getProcessor(i), featureStack, numSamples)) continue;
            IJ.log((String)("Error while loading label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedLabeledData(ImagePlus inputImage, ImagePlus labelImage, int[] classIndexToLabel, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        if (classIndexToLabel.length != this.numOfClasses) {
            IJ.log((String)"Error: number of classes and class/label correspondences do not match.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addRandomBalancedLabeledData(labelSlices.getProcessor(i), classIndexToLabel, featureStack, numSamples)) continue;
            IJ.log((String)("Error while loading label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addLabeledData(ImagePlus inputImage, ImagePlus labelImage, String[] classNames, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addLabeledData(labelSlices.getProcessor(i), featureStack, classNames, numSamples)) continue;
            IJ.log((String)("Error while loading label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addLabeledData(ImagePlus inputImage, ImagePlus labelImage, int[] classIndexToLabel, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        if (classIndexToLabel.length != this.numOfClasses) {
            IJ.log((String)"Error: number of classes and class/label correspondences do not match.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addLabeledData(labelSlices.getProcessor(i), featureStack, classIndexToLabel, numSamples)) continue;
            IJ.log((String)("Error while loading label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedLabeledData(ImagePlus inputImage, ImagePlus labelImage, String[] classNames, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addRandomBalancedLabeledData(labelSlices.getProcessor(i), featureStack, classNames, numSamples)) continue;
            IJ.log((String)("Error while loading label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImagePlus inputImage, ImagePlus labelImage, String whiteClassName, String blackClassName, int numSamples, ImagePlus mask) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImageProcessor labelIP = labelSlices.getProcessor(i).duplicate();
            labelIP.threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP).max / 2.0));
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addRandomBalancedBinaryData(labelIP, null == mask ? null : mask.getImageStack().getProcessor(i), featureStack, whiteClassName, blackClassName, numSamples)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImagePlus inputImage, ImagePlus labelImage, String whiteClassName, String blackClassName, int numSamples, ImagePlus mask, ImagePlus weights) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImageProcessor labelIP = labelSlices.getProcessor(i).duplicate();
            labelIP.threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP).max / 2.0));
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addRandomBalancedBinaryData(labelIP, null == mask ? null : mask.getImageStack().getProcessor(i), weights.getImageStack().getProcessor(i), featureStack, whiteClassName, blackClassName, numSamples)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomData(ImagePlus inputImage, ImagePlus labelImage, String whiteClassName, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImagePlus labelIP = new ImagePlus("labels", labelSlices.getProcessor(i).duplicate());
            labelIP.getProcessor().threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP.getProcessor()).max / 2.0));
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.setEnabledFeatures(this.enabledFeatures);
            featureStack.setMembranePatchSize(this.membranePatchSize);
            featureStack.setMembraneSize(this.membraneThickness);
            featureStack.setMaximumSigma(this.maximumSigma);
            featureStack.setMinimumSigma(this.minimumSigma);
            IJ.log((String)("Creating feature stack for slice " + i + "..."));
            featureStack.updateFeaturesMT();
            if (null != this.trainHeader) {
                featureStack.reorderFeatures(this.trainHeader);
            }
            WekaSegmentation.filterFeatureStackByList(this.featureNames, featureStack);
            IJ.log((String)"Feature stack is now updated.");
            featureStack.setUseNeighbors(this.useNeighbors);
            if (this.addRandomData(labelIP, featureStack, whiteClassName, numSamples)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addRandomBalancedBinaryData(ImagePlus inputImage, ImagePlus labelImage, ImagePlus filters, String whiteClassName, String blackClassName, int numSamples) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImageProcessor labelIP = labelSlices.getProcessor(i).duplicate();
            labelIP.threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP).max / 2.0));
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.addFeaturesMT(filters);
            if (this.addRandomBalancedBinaryData(labelIP, featureStack, whiteClassName, blackClassName, numSamples)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addBinaryData(ImagePlus inputImage, ImagePlus labelImage, ImagePlus filters, String whiteClassName, String blackClassName) {
        if (labelImage.getWidth() != inputImage.getWidth() || labelImage.getHeight() != inputImage.getHeight() || labelImage.getImageStackSize() != inputImage.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImageStack inputSlices = inputImage.getImageStack();
        ImageStack labelSlices = labelImage.getImageStack();
        for (int i = 1; i <= inputSlices.getSize(); ++i) {
            ImagePlus labelIP = new ImagePlus("labels", labelSlices.getProcessor(i).duplicate());
            labelIP.getProcessor().threshold((int)Math.floor(ImageStatistics.getStatistics((ImageProcessor)labelIP.getProcessor()).max / 2.0));
            FeatureStack featureStack = new FeatureStack(new ImagePlus("slice " + i, inputSlices.getProcessor(i)));
            featureStack.addFeaturesMT(filters);
            if (this.addBinaryData(labelIP, featureStack, whiteClassName, blackClassName)) continue;
            IJ.log((String)("Error while loading binary label data from slice " + i));
            return false;
        }
        return true;
    }

    public boolean addErodedBinaryData(ImagePlus labelImage, int n, String whiteClassName, String blackClassName) {
        if (this.featureStackArray.get(n).getSize() < 2) {
            IJ.log((String)"Creating feature stack...");
            this.featureStackArray.get(n).updateFeaturesMT();
            if (null != this.trainHeader) {
                this.featureStackArray.get(n).reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            IJ.log((String)"Feature stack is now updated.");
        }
        if (labelImage.getWidth() != this.trainingImage.getWidth() || labelImage.getHeight() != this.trainingImage.getHeight()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return false;
        }
        ImagePlus whiteIP = new ImagePlus("white", labelImage.getProcessor().duplicate());
        IJ.run((ImagePlus)whiteIP, (String)"Erode", (String)"");
        if (!this.addBinaryData(whiteIP, this.featureStackArray.get(n), whiteClassName)) {
            IJ.log((String)"Error while loading white class center-lines data.");
            return false;
        }
        ImagePlus blackIP = new ImagePlus("black", labelImage.getProcessor().duplicate());
        IJ.run((ImagePlus)blackIP, (String)"Invert", (String)"");
        IJ.run((ImagePlus)blackIP, (String)"Erode", (String)"");
        if (!this.addBinaryData(blackIP, this.featureStackArray.get(n), blackClassName)) {
            IJ.log((String)"Error while loading black class center-lines data.");
            return false;
        }
        return true;
    }

    public void setLoadedTrainingData(Instances data) {
        this.loadedTrainingData = data;
    }

    public void useAllFeatures() {
        boolean[] enableFeatures = this.enabledFeatures;
        for (int i = 0; i < enableFeatures.length; ++i) {
            enableFeatures[i] = true;
        }
        this.featureStackArray.setEnabledFeatures(enableFeatures);
    }

    public void setProjectFolder(String projectFolder) {
        this.projectFolder = projectFolder;
    }

    public static Instances homogenizeTrainingData(Instances data) {
        return WekaSegmentation.balanceTrainingData(data);
    }

    public static Instances balanceTrainingData(Instances data) {
        Resample filter = new Resample();
        Instances filteredIns = null;
        filter.setBiasToUniformClass(1.0);
        try {
            filter.setInputFormat(data);
            filter.setNoReplacement(false);
            filter.setSampleSizePercent(100.0);
            filteredIns = Filter.useFilter((Instances)data, (Filter)filter);
        }
        catch (Exception e) {
            IJ.log((String)"Error when resampling input data!");
            e.printStackTrace();
        }
        return filteredIns;
    }

    public void homogenizeTrainingData() {
        this.balanceTrainingData();
    }

    public void balanceTrainingData() {
        Resample filter = new Resample();
        Instances filteredIns = null;
        filter.setBiasToUniformClass(1.0);
        try {
            filter.setInputFormat(this.loadedTrainingData);
            filter.setNoReplacement(false);
            filter.setSampleSizePercent(100.0);
            filteredIns = Filter.useFilter((Instances)this.loadedTrainingData, (Filter)filter);
        }
        catch (Exception e) {
            IJ.log((String)"Error when resampling input data!");
            e.printStackTrace();
        }
        this.loadedTrainingData = filteredIns;
    }

    public boolean selectAttributes() {
        if (null == this.loadedTrainingData) {
            IJ.error((String)"There is no data so select attributes from.");
            return false;
        }
        this.loadedTrainingData = WekaSegmentation.selectAttributes(this.loadedTrainingData);
        this.featureNames = new ArrayList();
        IJ.log((String)"Selected attributes:");
        for (int i = 0; i < this.loadedTrainingData.numAttributes(); ++i) {
            this.featureNames.add(this.loadedTrainingData.attribute(i).name());
            IJ.log((String)(i + 1 + ": " + this.featureNames.get(i)));
        }
        return true;
    }

    public static Instances selectAttributes(Instances data) {
        AttributeSelection filter = new AttributeSelection();
        Instances filteredIns = null;
        CfsSubsetEval evaluator = new CfsSubsetEval();
        evaluator.setMissingSeparate(true);
        filter.setEvaluator((ASEvaluation)evaluator);
        BestFirst search = new BestFirst();
        filter.setSearch((ASSearch)search);
        try {
            filter.setInputFormat(data);
            filteredIns = Filter.useFilter((Instances)data, (Filter)filter);
        }
        catch (Exception e) {
            IJ.log((String)"Error when resampling input data with selected attributes!");
            e.printStackTrace();
        }
        return filteredIns;
    }

    public double getTrainingError(boolean verbose) {
        if (null == this.trainHeader) {
            return -1.0;
        }
        double error = -1.0;
        try {
            Evaluation evaluation = new Evaluation(this.loadedTrainingData);
            evaluation.evaluateModel((Classifier)this.classifier, this.loadedTrainingData, new Object[0]);
            if (verbose) {
                IJ.log((String)evaluation.toSummaryString("\n=== Training set evaluation ===\n", false));
            }
            error = evaluation.errorRate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return error;
    }

    public double getTestError(ImagePlus image, ImagePlus labels, int whiteClassIndex, int blackClassIndex, boolean verbose) {
        IJ.showStatus((String)"Creating features for test image...");
        if (verbose) {
            IJ.log((String)("Creating features for test image " + image.getTitle() + "..."));
        }
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                classNames.add(this.getClassLabel(i));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        int height = image.getHeight();
        int width = image.getWidth();
        int depth = image.getStackSize();
        Instances testData = null;
        for (int z = 1; z <= depth; ++z) {
            ImagePlus testSlice = new ImagePlus(image.getImageStack().getSliceLabel(z), image.getImageStack().getProcessor(z));
            IJ.showStatus((String)("Creating features for test image (slice " + z + ")..."));
            if (verbose) {
                IJ.log((String)("Creating features for test image (slice " + z + ")..."));
            }
            FeatureStack testImageFeatures = new FeatureStack(testSlice);
            testImageFeatures.setEnabledFeatures(this.enabledFeatures);
            testImageFeatures.setMaximumSigma(this.maximumSigma);
            testImageFeatures.setMinimumSigma(this.minimumSigma);
            testImageFeatures.setMembranePatchSize(this.membranePatchSize);
            testImageFeatures.setMembraneSize(this.membraneThickness);
            testImageFeatures.updateFeaturesMT();
            if (null != this.trainHeader) {
                testImageFeatures.reorderFeatures(this.trainHeader);
            }
            testImageFeatures.setUseNeighbors(this.featureStackArray.useNeighborhood());
            WekaSegmentation.filterFeatureStackByList(this.featureNames, testImageFeatures);
            Instances data = testImageFeatures.createInstances(classNames);
            data.setClassIndex(data.numAttributes() - 1);
            if (verbose) {
                IJ.log((String)"Assigning classes based on the labels...");
            }
            ImageProcessor slice = labels.getImageStack().getProcessor(z);
            int n = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double newValue = slice.getPixel(x, y) > 0 ? (double)whiteClassIndex : (double)blackClassIndex;
                    data.get(n).setClassValue(newValue);
                    ++x;
                    ++n;
                }
            }
            if (null == testData) {
                testData = data;
                continue;
            }
            for (int i = 0; i < data.numInstances(); ++i) {
                testData.add(data.get(i));
            }
        }
        if (verbose) {
            IJ.log((String)"Evaluating test data...");
        }
        double error = -1.0;
        try {
            Evaluation evaluation = new Evaluation(testData);
            evaluation.evaluateModel((Classifier)this.classifier, testData, new Object[0]);
            if (verbose) {
                IJ.log((String)evaluation.toSummaryString("\n=== Test data evaluation ===\n", false));
                IJ.log((String)(evaluation.toClassDetailsString() + "\n"));
                IJ.log((String)evaluation.toMatrixString());
            }
            error = evaluation.errorRate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return error;
    }

    public int[][] getTestConfusionMatrix(ImagePlus image, ImagePlus expectedLabels, int whiteClassIndex, int blackClassIndex) {
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                classNames.add(this.getClassLabel(i));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        ImagePlus resultLabels = this.applyClassifier(image, 0, false);
        return this.getConfusionMatrix(resultLabels, expectedLabels, whiteClassIndex, blackClassIndex);
    }

    public int[][] getConfusionMatrix(ImagePlus proposedLabels, ImagePlus expectedLabels, int whiteClassIndex, int blackClassIndex) {
        int[][] confusionMatrix = new int[2][2];
        int height = proposedLabels.getHeight();
        int width = proposedLabels.getWidth();
        int depth = proposedLabels.getStackSize();
        for (int z = 1; z <= depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (expectedLabels.getImageStack().getProcessor(z).get(x, y) > 0) {
                        if (proposedLabels.getImageStack().getProcessor(z).get(x, y) > 0) {
                            int[] nArray = confusionMatrix[whiteClassIndex];
                            int n = whiteClassIndex;
                            nArray[n] = nArray[n] + 1;
                            continue;
                        }
                        int[] nArray = confusionMatrix[whiteClassIndex];
                        int n = blackClassIndex;
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    if (proposedLabels.getImageStack().getProcessor(z).get(x, y) > 0) {
                        int[] nArray = confusionMatrix[blackClassIndex];
                        int n = whiteClassIndex;
                        nArray[n] = nArray[n] + 1;
                        continue;
                    }
                    int[] nArray = confusionMatrix[blackClassIndex];
                    int n = blackClassIndex;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        return confusionMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] getConfusionMatrix(ImagePlus proposal, ImagePlus expectedLabels, double threshold) {
        int z;
        int[][] confusionMatrix = new int[2][2];
        int depth = proposal.getStackSize();
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<int[][]>> fu = new ArrayList<Future<int[][]>>();
        for (z = 1; z <= depth; ++z) {
            fu.add(exe.submit(WekaSegmentation.confusionMatrixBinarySlice(proposal.getImageStack().getProcessor(z), expectedLabels.getImageStack().getProcessor(z), threshold)));
        }
        for (z = 0; z < depth; ++z) {
            try {
                int[][] temp = (int[][])((Future)fu.get(z)).get();
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int[] nArray = confusionMatrix[i];
                        int n = j;
                        nArray[n] = nArray[n] + temp[i][j];
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                int[][] nArray = null;
                return nArray;
            }
            finally {
                exe.shutdown();
            }
        }
        return confusionMatrix;
    }

    public static Callable<int[][]> confusionMatrixBinarySlice(final ImageProcessor proposal, final ImageProcessor expectedLabels, final double threshold) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<int[][]>(){

            @Override
            public int[][] call() {
                int[][] confusionMatrix = new int[2][2];
                for (int y = 0; y < proposal.getHeight(); ++y) {
                    for (int x = 0; x < proposal.getWidth(); ++x) {
                        double pix;
                        double d = pix = (double)proposal.getPixelValue(x, y) > threshold ? 1.0 : 0.0;
                        if (expectedLabels.get(x, y) > 0) {
                            if (pix > 0.0) {
                                int[] nArray = confusionMatrix[1];
                                nArray[1] = nArray[1] + 1;
                                continue;
                            }
                            int[] nArray = confusionMatrix[1];
                            nArray[0] = nArray[0] + 1;
                            continue;
                        }
                        if (pix > 0.0) {
                            int[] nArray = confusionMatrix[0];
                            nArray[1] = nArray[1] + 1;
                            continue;
                        }
                        int[] nArray = confusionMatrix[0];
                        nArray[0] = nArray[0] + 1;
                    }
                }
                return confusionMatrix;
            }
        };
    }

    public int[][] getTestConfusionMatrix(ImagePlus image, ImagePlus filters, ImagePlus expectedLabels, int whiteClassIndex, int blackClassIndex) {
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                classNames.add(this.getClassLabel(i));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        ImagePlus resultLabels = this.applyClassifier(image, filters, 0, false);
        return this.getConfusionMatrix(resultLabels, expectedLabels, whiteClassIndex, blackClassIndex);
    }

    public double getTestError(ImagePlus image, ImagePlus labels, ImagePlus filters, int whiteClassIndex, int blackClassIndex, boolean verbose) {
        IJ.showStatus((String)"Creating features for test image...");
        if (verbose) {
            IJ.log((String)("Creating features for test image " + image.getTitle() + "..."));
        }
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                classNames.add(this.getClassLabel(i));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        int height = image.getHeight();
        int width = image.getWidth();
        int depth = image.getStackSize();
        Instances testData = null;
        for (int z = 1; z <= depth; ++z) {
            ImagePlus testSlice = new ImagePlus(image.getImageStack().getSliceLabel(z), image.getImageStack().getProcessor(z));
            IJ.showStatus((String)"Creating features for test image...");
            if (verbose) {
                IJ.log((String)("Creating features for test image " + z + "..."));
            }
            FeatureStack testImageFeatures = new FeatureStack(testSlice);
            testImageFeatures.addFeaturesMT(filters);
            Instances data = testImageFeatures.createInstances(classNames);
            data.setClassIndex(data.numAttributes() - 1);
            if (verbose) {
                IJ.log((String)"Assigning classes based on the labels...");
            }
            ImageProcessor slice = labels.getImageStack().getProcessor(z);
            int n = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double newValue = slice.getPixel(x, y) > 0 ? (double)whiteClassIndex : (double)blackClassIndex;
                    data.get(n).setClassValue(newValue);
                    ++x;
                    ++n;
                }
            }
            if (null == testData) {
                testData = data;
                continue;
            }
            for (int i = 0; i < data.numInstances(); ++i) {
                testData.add(data.get(i));
            }
        }
        if (verbose) {
            IJ.log((String)"Evaluating test data...");
        }
        double error = -1.0;
        try {
            Evaluation evaluation = new Evaluation(testData);
            evaluation.evaluateModel((Classifier)this.classifier, testData, new Object[0]);
            if (verbose) {
                IJ.log((String)evaluation.toSummaryString("\n=== Test data evaluation ===\n", false));
                IJ.log((String)(evaluation.toClassDetailsString() + "\n"));
                IJ.log((String)evaluation.toMatrixString());
            }
            error = evaluation.errorRate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return error;
    }

    public void udpateDataClassification(ImagePlus labels, String className1, String className2) {
        int classIndex1 = 0;
        for (classIndex1 = 0; classIndex1 < this.getClassLabels().length && !className1.equalsIgnoreCase(this.getClassLabel(classIndex1)); ++classIndex1) {
        }
        if (classIndex1 == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + className1 + "' not found."));
            return;
        }
        int classIndex2 = 0;
        for (classIndex2 = 0; classIndex2 < this.getClassLabels().length && !className2.equalsIgnoreCase(this.getClassLabel(classIndex2)); ++classIndex2) {
        }
        if (classIndex2 == this.getClassLabels().length) {
            IJ.log((String)("Error: class named '" + className2 + "' not found."));
            return;
        }
        WekaSegmentation.updateDataClassification(this.loadedTrainingData, labels, classIndex1, classIndex2);
    }

    public static void updateDataClassification(Instances data, ImagePlus labels, int classIndex1, int classIndex2) {
        int size = labels.getWidth() * labels.getHeight() * labels.getStackSize();
        if (size != data.numInstances()) {
            IJ.log((String)"Error: labels size does not match loaded training data set size.");
            return;
        }
        int width = labels.getWidth();
        int height = labels.getHeight();
        int depth = labels.getStackSize();
        int n = 0;
        for (int z = 1; z <= depth; ++z) {
            ImageProcessor slice = labels.getImageStack().getProcessor(z);
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    data.get(n).setClassValue(slice.getPixel(x, y) > 0 ? (double)classIndex1 : (double)classIndex2);
                    ++x;
                    ++n;
                }
            }
        }
    }

    public static void updateDataClassification(Instances data, ImagePlus labels, int classIndex1, int classIndex2, ArrayList<Point3f>[] mismatches) {
        int size = labels.getWidth() * labels.getHeight() * labels.getStackSize();
        if (size != data.numInstances()) {
            IJ.log((String)"Error: labels size does not match loaded training data set size.");
            return;
        }
        int width = labels.getWidth();
        int height = labels.getHeight();
        int depth = labels.getStackSize();
        int n = 0;
        for (int z = 1; z <= depth; ++z) {
            ImageProcessor slice = labels.getImageStack().getProcessor(z);
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    double newValue = slice.getPixel(x, y) > 0 ? (double)classIndex1 : (double)classIndex2;
                    data.get(n).setClassValue(newValue);
                    ++x;
                    ++n;
                }
            }
        }
    }

    public Instances readDataFromARFF(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8));
            try {
                Instances data = new Instances((Reader)reader);
                data.setClassIndex(data.numAttributes() - 1);
                reader.close();
                return data;
            }
            catch (IOException e) {
                IJ.showMessage((String)"IOException: wrong file format!");
            }
        }
        catch (FileNotFoundException e) {
            IJ.showMessage((String)"File not found!");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDataToARFF(Instances data, String filename) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            Instances header = new Instances(data, 0);
            out.write(header.toString());
            for (int i = 0; i < data.numInstances(); ++i) {
                out.write(data.get(i).toString() + "\n");
            }
        }
        catch (Exception e) {
            IJ.log((String)"Error: couldn't write instances into .ARFF file.");
            IJ.showMessage((String)"Exception while saving data as ARFF file");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean adjustSegmentationStateToData(Instances data) {
        boolean featuresChanged = false;
        Enumeration attributes = data.enumerateAttributes();
        String[] availableFeatures = this.isProcessing3D ? FeatureStack3D.availableFeatures : FeatureStack.availableFeatures;
        int numFeatures = availableFeatures.length;
        boolean[] usedFeatures = new boolean[numFeatures];
        this.featureNames = new ArrayList();
        float minSigma = Float.MAX_VALUE;
        float maxSigma = Float.MIN_VALUE;
        while (attributes.hasMoreElements()) {
            Attribute a = (Attribute)attributes.nextElement();
            this.featureNames.add(a.name());
            block12: for (int i = 0; i < numFeatures; ++i) {
                float sigma;
                String[] tokens;
                if (!a.name().startsWith(availableFeatures[i])) continue;
                usedFeatures[i] = true;
                if (!this.isProcessing3D) {
                    switch (i) {
                        case 4: {
                            int index = a.name().indexOf("s_") + 4;
                            int index2 = a.name().indexOf("_", index + 1);
                            int patchSize = Integer.parseInt(a.name().substring(index, index2));
                            if (patchSize != this.membranePatchSize) {
                                this.membranePatchSize = patchSize;
                                if (null != this.featureStackArray) {
                                    this.featureStackArray.setMembranePatchSize(patchSize);
                                }
                                featuresChanged = true;
                            }
                            index = a.name().lastIndexOf("_");
                            int thickness = Integer.parseInt(a.name().substring(index + 1));
                            if (thickness == this.membraneThickness) continue block12;
                            this.membraneThickness = thickness;
                            if (null != this.featureStackArray) {
                                this.featureStackArray.setMembraneSize(thickness);
                            }
                            featuresChanged = true;
                            break;
                        }
                        case 13: {
                            tokens = a.name().split("_");
                            this.membranePatchSize = Integer.parseInt(tokens[1]);
                            break;
                        }
                        case 18: 
                        case 19: {
                            tokens = a.name().split("_");
                            sigma = Float.parseFloat(tokens[1]);
                            if (sigma < minSigma) {
                                minSigma = sigma;
                            }
                            if (!(sigma > maxSigma)) continue block12;
                            maxSigma = sigma;
                            break;
                        }
                        case 14: 
                        case 17: {
                            tokens = a.name().split("_");
                            sigma = Float.parseFloat(tokens[2]);
                            if (sigma < minSigma) {
                                minSigma = sigma;
                            }
                            if (!(sigma > maxSigma)) continue block12;
                            maxSigma = sigma;
                            break;
                        }
                        case 10: {
                            tokens = a.name().split("_");
                            sigma = Float.parseFloat(tokens[3]);
                            if (sigma < minSigma) {
                                minSigma = sigma;
                            }
                            if (!(sigma > maxSigma)) continue block12;
                            maxSigma = sigma;
                            break;
                        }
                        case 11: 
                        case 12: {
                            break;
                        }
                        default: {
                            tokens = a.name().split("_");
                            for (int j = 0; j < tokens.length; ++j) {
                                if (tokens[j].indexOf(".") == -1) continue;
                                sigma = Float.parseFloat(tokens[j]);
                                if (sigma < minSigma) {
                                    minSigma = sigma;
                                }
                                if (!(sigma > maxSigma)) continue;
                                maxSigma = sigma;
                            }
                            continue block12;
                        }
                    }
                    continue;
                }
                switch (i) {
                    case 4: {
                        tokens = a.name().split("_");
                        sigma = Float.parseFloat(tokens[2]);
                        if (sigma < minSigma) {
                            minSigma = sigma;
                        }
                        if (!(sigma > maxSigma)) continue block12;
                        maxSigma = sigma;
                        continue block12;
                    }
                    default: {
                        tokens = a.name().split("_");
                        for (int j = 0; j < tokens.length; ++j) {
                            if (tokens[j].indexOf(".") == -1) continue;
                            sigma = Float.parseFloat(tokens[j]);
                            if (sigma < minSigma) {
                                minSigma = sigma;
                            }
                            if (!(sigma > maxSigma)) continue;
                            maxSigma = sigma;
                        }
                    }
                }
            }
        }
        if (minSigma == Float.MAX_VALUE || maxSigma == Float.MIN_VALUE) {
            IJ.log((String)"No sigmas selected.");
            minSigma = this.minimumSigma;
            maxSigma = this.maximumSigma;
        } else {
            IJ.log((String)("Field of view: max sigma = " + maxSigma + ", min sigma = " + minSigma));
        }
        if (!this.isProcessing3D) {
            IJ.log((String)("Membrane thickness: " + this.membraneThickness + ", patch size: " + this.membranePatchSize));
        }
        if (minSigma != this.minimumSigma && minSigma != 0.0f) {
            this.minimumSigma = minSigma;
            featuresChanged = true;
            if (null != this.featureStackArray) {
                this.featureStackArray.setMinimumSigma(minSigma);
            }
            if (this.isProcessing3D && null != this.fs3d) {
                this.fs3d.setMinimumSigma(minSigma);
            }
        }
        if (maxSigma != this.maximumSigma) {
            this.maximumSigma = maxSigma;
            featuresChanged = true;
            if (null != this.featureStackArray) {
                this.featureStackArray.setMaximumSigma(maxSigma);
            }
            if (this.isProcessing3D && null != this.fs3d) {
                this.fs3d.setMaximumSigma(maxSigma);
            }
        }
        Attribute classAttribute = data.classAttribute();
        Enumeration classValues = classAttribute.enumerateValues();
        this.loadedClassNames = new ArrayList();
        int j = 0;
        this.setNumOfClasses(0);
        while (classValues.hasMoreElements()) {
            String className = ((String)classValues.nextElement()).trim();
            this.loadedClassNames.add(className);
        }
        for (String className : this.loadedClassNames) {
            IJ.log((String)("Read class name: " + className));
            this.setClassLabel(j, className);
            this.addClass();
            ++j;
        }
        if (null != this.featureStackArray) {
            boolean[] oldEnableFeatures = this.isProcessing3D ? this.fs3d.getEnabledFeatures() : this.featureStackArray.getEnabledFeatures();
            for (int i = 0; i < numFeatures; ++i) {
                if (usedFeatures[i] == oldEnableFeatures[i]) continue;
                featuresChanged = true;
            }
        } else {
            featuresChanged = true;
        }
        if (featuresChanged) {
            this.setEnabledFeatures(usedFeatures);
            this.setFeaturesDirty();
        }
        return true;
    }

    public String createHeaderName(boolean bool3d, boolean boolRGB) {
        String dim = bool3d ? "3D" : "2D";
        String mode = boolRGB ? "RGB" : "grayscale";
        return "TWS-" + dim + "-" + Weka_Segmentation.PLUGIN_VERSION + "-" + mode;
    }

    public Instances createTrainingInstances() {
        ArrayList<String> classes;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 1; i <= this.featureStackArray.getNumOfFeatures(); ++i) {
            String attString = this.featureStackArray.getLabel(i);
            attributes.add(new Attribute(attString));
        }
        if (null == this.loadedTrainingData) {
            classes = new ArrayList();
            for (int i = 0; i < this.numOfClasses; ++i) {
                for (int n = 0; n < this.trainingImage.getImageStackSize(); ++n) {
                    if (classes.contains(this.getClassLabel(i))) continue;
                    classes.add(this.getClassLabel(i));
                }
            }
        } else {
            classes = this.loadedClassNames;
        }
        attributes.add(new Attribute("class", classes));
        boolean colorFeatures = this.trainingImage.getType() == 4;
        String headerName = this.createHeaderName(this.isProcessing3D, colorFeatures);
        Instances trainingData = new Instances(headerName, attributes, 1);
        trainingData.setClassIndex(this.featureStackArray.getNumOfFeatures());
        IJ.log((String)"Training input:");
        for (int classIndex = 0; classIndex < this.numOfClasses; ++classIndex) {
            int nl = 0;
            for (int sliceNum = 1; sliceNum <= this.trainingImage.getImageStackSize(); ++sliceNum) {
                for (int j = 0; j < this.examples[sliceNum - 1].get(classIndex).size(); ++j) {
                    Roi r = this.examples[sliceNum - 1].get(classIndex).get(j);
                    if (r instanceof PolygonRoi && r.getType() == 7) {
                        if (r.getStrokeWidth() == 1.0f) {
                            nl += this.addThinFreeLineSamples(trainingData, classIndex, sliceNum, r);
                            continue;
                        }
                        nl += this.addThickFreeLineInstances(trainingData, colorFeatures, classIndex, sliceNum, r);
                        continue;
                    }
                    if (r instanceof Line) {
                        nl += this.addLineInstances(trainingData, colorFeatures, classIndex, sliceNum, r);
                        continue;
                    }
                    if (r.getType() == 0 && r.getCornerDiameter() == 0) {
                        nl += this.addRectangleRoiInstances(trainingData, classIndex, sliceNum, r);
                        continue;
                    }
                    nl += this.addShapeRoiInstances(trainingData, classIndex, sliceNum, r);
                }
            }
            IJ.log((String)("# of pixels selected as " + this.getClassLabel(classIndex) + ": " + nl));
        }
        if (trainingData.numInstances() == 0) {
            return null;
        }
        return trainingData;
    }

    private int addThinFreeLineSamples(Instances trainingData, int classIndex, int sliceNum, Roi r) {
        int numInstances = 0;
        int[] x = r.getPolygon().xpoints;
        int[] y = r.getPolygon().ypoints;
        int n = r.getPolygon().npoints;
        for (int i = 0; i < n; ++i) {
            double[] values = new double[this.featureStackArray.getNumOfFeatures() + 1];
            for (int z = 1; z <= this.featureStackArray.getNumOfFeatures(); ++z) {
                values[z - 1] = this.featureStackArray.get(sliceNum - 1).getProcessor(z).getPixelValue(x[i], y[i]);
            }
            values[this.featureStackArray.getNumOfFeatures()] = classIndex;
            trainingData.add((Instance)new DenseInstance(1.0, values));
            ++numInstances;
        }
        return numInstances;
    }

    private int addShapeRoiInstances(Instances trainingData, int classIndex, int sliceNum, Roi r) {
        int lastY;
        int numInstances = 0;
        ShapeRoi shapeRoi = new ShapeRoi(r);
        Rectangle rect = shapeRoi.getBounds();
        int lastX = rect.x + rect.width;
        if (lastX >= this.trainingImage.getWidth()) {
            lastX = this.trainingImage.getWidth() - 1;
        }
        if ((lastY = rect.y + rect.height) >= this.trainingImage.getHeight()) {
            lastY = this.trainingImage.getHeight() - 1;
        }
        int firstX = Math.max(rect.x, 0);
        int firstY = Math.max(rect.y, 0);
        FeatureStack fs = this.featureStackArray.get(sliceNum - 1);
        ByteProcessor bp = new ByteProcessor(rect.width, rect.height);
        bp.setValue(255.0);
        shapeRoi.setLocation(0, 0);
        bp.fill((Roi)shapeRoi);
        int x = firstX;
        int rectX = 0;
        while (x < lastX) {
            int y = firstY;
            int rectY = 0;
            while (y < lastY) {
                if (bp.getf(rectX, rectY) > 0.0f) {
                    trainingData.add((Instance)fs.createInstance(x, y, classIndex));
                    ++numInstances;
                }
                ++y;
                ++rectY;
            }
            ++x;
            ++rectX;
        }
        return numInstances;
    }

    private int addRectangleRoiInstances(Instances trainingData, int classIndex, int sliceNum, Roi r) {
        int numInstances = 0;
        Rectangle rect = r.getBounds();
        int x0 = rect.x;
        int y0 = rect.y;
        int lastX = x0 + rect.width;
        int lastY = y0 + rect.height;
        FeatureStack fs = this.featureStackArray.get(sliceNum - 1);
        for (int x = x0; x < lastX; ++x) {
            for (int y = y0; y < lastY; ++y) {
                trainingData.add((Instance)fs.createInstance(x, y, classIndex));
                ++numInstances;
            }
        }
        return numInstances;
    }

    private int addLineInstances(Instances trainingData, boolean colorFeatures, int classIndex, int sliceNum, Roi r) {
        int numInstances = 0;
        double dx = ((Line)r).x2d - ((Line)r).x1d;
        double dy = ((Line)r).y2d - ((Line)r).y1d;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double x = ((Line)r).x1d;
        double y = ((Line)r).y1d;
        for (int i = 0; i < n; ++i) {
            if (x >= 0.0 && x < (double)this.featureStackArray.get(sliceNum - 1).getWidth() && y >= 0.0 && y < (double)this.featureStackArray.get(sliceNum - 1).getHeight()) {
                int z;
                double[] values = new double[this.featureStackArray.getNumOfFeatures() + 1];
                if (colorFeatures) {
                    for (z = 1; z <= this.featureStackArray.getNumOfFeatures(); ++z) {
                        values[z - 1] = this.featureStackArray.get(sliceNum - 1).getProcessor(z).getInterpolatedPixel(x, y);
                    }
                } else {
                    for (z = 1; z <= this.featureStackArray.getNumOfFeatures(); ++z) {
                        values[z - 1] = this.featureStackArray.get(sliceNum - 1).getProcessor(z).getInterpolatedValue(x, y);
                    }
                }
                values[this.featureStackArray.getNumOfFeatures()] = classIndex;
                trainingData.add((Instance)new DenseInstance(1.0, values));
                ++numInstances;
            }
            x += xinc;
            y += yinc;
        }
        return numInstances;
    }

    private int addThickFreeLineInstances(Instances trainingData, boolean colorFeatures, int classIndex, int sliceNum, Roi r) {
        int width = Math.round(r.getStrokeWidth());
        FloatPolygon p = r.getFloatPolygon();
        int n = p.npoints;
        int numInstances = 0;
        double x2 = p.xpoints[0] - (p.xpoints[1] - p.xpoints[0]);
        double y2 = p.ypoints[0] - (p.ypoints[1] - p.ypoints[0]);
        for (int i = 0; i < n; ++i) {
            double x1 = x2;
            double y1 = y2;
            x2 = p.xpoints[i];
            y2 = p.ypoints[i];
            double dx = x2 - x1;
            double dy = y1 - y2;
            double length = (float)Math.sqrt(dx * dx + dy * dy);
            double x = x2 - (dy /= length) * (double)width / 2.0;
            double y = y2 - (dx /= length) * (double)width / 2.0;
            int n2 = width;
            do {
                if (x >= 0.0 && x < (double)this.featureStackArray.get(sliceNum - 1).getWidth() && y >= 0.0 && y < (double)this.featureStackArray.get(sliceNum - 1).getHeight()) {
                    int z;
                    double[] values = new double[this.featureStackArray.getNumOfFeatures() + 1];
                    if (colorFeatures) {
                        for (z = 1; z <= this.featureStackArray.getNumOfFeatures(); ++z) {
                            values[z - 1] = this.featureStackArray.get(sliceNum - 1).getProcessor(z).getInterpolatedPixel(x, y);
                        }
                    } else {
                        for (z = 1; z <= this.featureStackArray.getNumOfFeatures(); ++z) {
                            values[z - 1] = this.featureStackArray.get(sliceNum - 1).getProcessor(z).getInterpolatedValue(x, y);
                        }
                    }
                    values[this.featureStackArray.getNumOfFeatures()] = classIndex;
                    trainingData.add((Instance)new DenseInstance(1.0, values));
                    ++numInstances;
                }
                x += dy;
                y += dx;
            } while (--n2 > 0);
        }
        return numInstances;
    }

    public Callable<Instances> createInstances(final ArrayList<String> classNames, final FeatureStack featureStack) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<Instances>(){

            @Override
            public Instances call() {
                return featureStack.createInstances(classNames);
            }
        };
    }

    public boolean trainClassifier() {
        long end;
        if (Thread.currentThread().isInterrupted()) {
            IJ.log((String)"Classifier training was interrupted.");
            return false;
        }
        int nonEmpty = 0;
        int sliceWithTraces = -1;
        if (null != this.trainingImage) {
            block3: for (int i = 0; i < this.numOfClasses; ++i) {
                for (int j = 0; j < this.trainingImage.getImageStackSize(); ++j) {
                    if (this.examples[j].get(i).isEmpty()) continue;
                    ++nonEmpty;
                    sliceWithTraces = j;
                    continue block3;
                }
            }
        }
        if (nonEmpty < 2 && null == this.loadedTrainingData) {
            IJ.showMessage((String)"Cannot train without at least 2 sets of examples!");
            return false;
        }
        if (nonEmpty > 1 && this.featureStackArray.isEmpty() || this.updateFeatures) {
            IJ.showStatus((String)"Creating feature stack...");
            IJ.log((String)"Creating feature stack...");
            long start = System.currentTimeMillis();
            this.featureStackArray.setReference(sliceWithTraces);
            if (!this.isProcessing3D && !this.featureStackArray.updateFeaturesMT(this.featureStackToUpdateTrain)) {
                IJ.log((String)"Feature stack was not updated.");
                IJ.showStatus((String)"Feature stack was not updated.");
                return false;
            }
            if (this.isProcessing3D) {
                if (!this.fs3d.updateFeaturesMT()) {
                    IJ.log((String)"Feature stack 3D was not updated.");
                    IJ.showStatus((String)"Feature stack 3D was not updated.");
                    return false;
                }
                this.featureStackArray = this.fs3d.getFeatureStackArray();
            }
            Arrays.fill(this.featureStackToUpdateTrain, false);
            if (null != this.trainHeader) {
                this.featureStackArray.reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            long end2 = System.currentTimeMillis();
            IJ.log((String)("Feature stack array is now updated (" + this.featureStackArray.getSize() + " slice(s) with " + this.featureStackArray.getNumOfFeatures() + " feature(s), took " + (end2 - start) + "ms)."));
            double memory = 0.0;
            for (int i = 0; i < this.featureStackArray.getSize(); ++i) {
                FeatureStack featureStack = this.featureStackArray.get(i);
                ImageStack imageStack = featureStack.getStack();
                int bitDepth = imageStack.getBitDepth();
                int size = imageStack.getSize();
                int height = imageStack.getHeight();
                int width = imageStack.getWidth();
                memory += (double)(size * height * width * bitDepth);
            }
            IJ.log((String)("Feature stack array size is " + (memory /= 8.0E9) + " giga-byte"));
        }
        IJ.showStatus((String)"Creating training instances...");
        Instances data = null;
        if (nonEmpty < 1) {
            IJ.log((String)"Training from loaded data only...");
        } else {
            long start = System.currentTimeMillis();
            this.traceTrainingData = data = this.createTrainingInstances();
            end = System.currentTimeMillis();
            IJ.log((String)("Creating training data took: " + (end - start) + "ms"));
        }
        if (this.loadedTrainingData != null && data != null) {
            IJ.log((String)"Merging data...");
            for (int i = 0; i < this.loadedTrainingData.numInstances(); ++i) {
                data.add(this.loadedTrainingData.instance(i));
            }
            IJ.log((String)("Finished: total number of instances = " + data.numInstances()));
        } else if (data == null) {
            data = this.loadedTrainingData;
            IJ.log((String)"Taking loaded data as only data...");
        }
        if (null == data) {
            IJ.log((String)"WTF");
        }
        this.trainHeader = new Instances(data, 0);
        if (this.balanceClasses) {
            long start = System.currentTimeMillis();
            IJ.showStatus((String)"Balancing classes distribution...");
            IJ.log((String)"Balancing classes distribution...");
            data = WekaSegmentation.balanceTrainingData(data);
            end = System.currentTimeMillis();
            IJ.log((String)("Done. Balancing classes distribution took: " + (end - start) + "ms"));
        }
        IJ.showStatus((String)"Training classifier...");
        IJ.log((String)"Training classifier...");
        if (Thread.currentThread().isInterrupted()) {
            IJ.log((String)"Classifier training was interrupted.");
            return false;
        }
        long start = System.currentTimeMillis();
        try {
            this.classifier.buildClassifier(data);
        }
        catch (InterruptedException ie) {
            IJ.log((String)"Classifier construction was interrupted.");
            return false;
        }
        catch (Exception e) {
            IJ.showMessage((String)e.getMessage());
            e.printStackTrace();
            return false;
        }
        IJ.log((String)this.classifier.toString());
        end = System.currentTimeMillis();
        IJ.log((String)("Finished training in " + (end - start) + "ms"));
        return true;
    }

    public ImagePlus applyClassifier(ImagePlus imp) {
        return this.applyClassifier(imp, 0, false);
    }

    public ImagePlus applyClassifier(final ImagePlus imp, int numThreads, final boolean probabilityMaps) {
        if (numThreads == 0) {
            numThreads = Prefs.getThreads();
        }
        if (this.isProcessing3D) {
            long start = System.currentTimeMillis();
            FeatureStack3D fs3d = new FeatureStack3D(imp);
            fs3d.setMaximumSigma(this.maximumSigma);
            fs3d.setMinimumSigma(this.minimumSigma);
            fs3d.setEnableFeatures(this.enabled3Dfeatures);
            fs3d.updateFeaturesMT();
            FeatureStackArray fsa = fs3d.getFeatureStackArray();
            if (null != this.trainHeader) {
                fsa.reorderFeatures(this.trainHeader);
            }
            long end = System.currentTimeMillis();
            IJ.log((String)("Feature stack array is now updated (" + imp.getImageStackSize() + " slice(s) with " + fsa.getNumOfFeatures() + " feature(s), took " + (end - start) + "ms)."));
            ImagePlus result = this.applyClassifier(fsa, numThreads, probabilityMaps);
            if (probabilityMaps) {
                result.setDimensions(this.numOfClasses, imp.getNSlices(), imp.getNFrames());
                if (imp.getNSlices() * imp.getNFrames() > 1) {
                    result.setOpenAsHyperStack(true);
                }
            }
            result.setCalibration(imp.getCalibration());
            fs3d = null;
            fsa = null;
            System.gc();
            return result;
        }
        int numSliceThreads = Math.min(imp.getStackSize(), numThreads);
        int numClasses = this.numOfClasses;
        int numChannels = probabilityMaps ? numClasses : 1;
        IJ.log((String)("Processing slices of " + imp.getTitle() + " in " + numSliceThreads + " thread(s)..."));
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                classNames.add(this.getClassLabel(i));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        final ImagePlus[] classifiedSlices = new ImagePlus[imp.getStackSize()];
        int numFurtherThreads = (int)Math.ceil((double)(numThreads - numSliceThreads) / (double)numSliceThreads) + 1;
        class ApplyClassifierThread
        extends Thread {
            private final int startSlice;
            private final int numSlices;
            private final int numFurtherThreads;
            private final ArrayList<String> classNames;

            public ApplyClassifierThread(int startSlice, int numSlices, int numFurtherThreads, ArrayList<String> classNames) {
                this.startSlice = startSlice;
                this.numSlices = numSlices;
                this.numFurtherThreads = numFurtherThreads;
                this.classNames = classNames;
            }

            @Override
            public void run() {
                for (int i = this.startSlice; i < this.startSlice + this.numSlices; ++i) {
                    ImagePlus slice = new ImagePlus(imp.getImageStack().getSliceLabel(i), imp.getImageStack().getProcessor(i));
                    IJ.showStatus((String)"Creating features...");
                    IJ.log((String)("Creating features for slice " + i + "..."));
                    FeatureStack sliceFeatures = new FeatureStack(slice);
                    sliceFeatures.setEnabledFeatures(enabledFeatures);
                    sliceFeatures.setMaximumSigma(maximumSigma);
                    sliceFeatures.setMinimumSigma(minimumSigma);
                    sliceFeatures.setMembranePatchSize(membranePatchSize);
                    sliceFeatures.setMembraneSize(membraneThickness);
                    sliceFeatures.updateFeaturesMT(this.numFurtherThreads);
                    if (null != trainHeader) {
                        sliceFeatures.reorderFeatures(trainHeader);
                    }
                    WekaSegmentation.filterFeatureStackByList(featureNames, sliceFeatures);
                    Instances sliceData = sliceFeatures.createInstances(this.classNames);
                    sliceData.setClassIndex(sliceData.numAttributes() - 1);
                    IJ.log((String)("Classifying slice " + i + " in " + this.numFurtherThreads + " thread(s)..."));
                    ImagePlus classImage = this.applyClassifier(sliceData, slice.getWidth(), slice.getHeight(), this.numFurtherThreads, probabilityMaps);
                    if (null == classImage) {
                        IJ.log((String)"Error while applying classifier!");
                        return;
                    }
                    classImage.setCalibration(imp.getCalibration());
                    classImage.setTitle("classified_" + slice.getTitle());
                    classifiedSlices[i - 1] = classImage;
                    sliceFeatures = null;
                    sliceData = null;
                    System.gc();
                }
            }
        }
        ApplyClassifierThread[] threads = new ApplyClassifierThread[numSliceThreads];
        int[] numSlicesPerThread = new int[numSliceThreads];
        for (int i = 0; i < imp.getImageStackSize(); ++i) {
            int n = i % numSliceThreads;
            numSlicesPerThread[n] = numSlicesPerThread[n] + 1;
        }
        int aux = 0;
        for (int i = 0; i < numSliceThreads; ++i) {
            int startSlice = aux + 1;
            aux += numSlicesPerThread[i];
            IJ.log((String)("Starting thread " + i + " processing " + numSlicesPerThread[i] + " slices, starting with " + startSlice));
            threads[i] = new ApplyClassifierThread(startSlice, numSlicesPerThread[i], numFurtherThreads, classNames);
            threads[i].start();
        }
        ImageStack classified = new ImageStack(imp.getWidth(), imp.getHeight());
        for (ApplyClassifierThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < imp.getStackSize(); ++i) {
            for (int c = 0; c < numChannels; ++c) {
                classified.addSlice(probabilityMaps ? this.getClassLabel(c) : "", classifiedSlices[i].getStack().getProcessor(c + 1));
            }
        }
        ImagePlus result = new ImagePlus("Classification result", classified);
        if (probabilityMaps) {
            result.setDimensions(this.numOfClasses, imp.getNSlices(), imp.getNFrames());
            if (imp.getNSlices() * imp.getNFrames() > 1) {
                result.setOpenAsHyperStack(true);
            }
        }
        result.setCalibration(imp.getCalibration());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus applyClassifierMT(ImagePlus imp, int numThreads, boolean probabilityMaps) {
        int i;
        int i2;
        if (numThreads == 0) {
            numThreads = Prefs.getThreads();
        }
        int numClasses = this.numOfClasses;
        int numChannels = probabilityMaps ? numClasses : 1;
        IJ.log((String)("Classifying data from image " + imp.getTitle() + " using " + numThreads + " thread(s)..."));
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i3 = 0; i3 < this.numOfClasses; ++i3) {
                classNames.add(this.getClassLabel(i3));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (i2 = 1; i2 <= this.featureStackArray.getNumOfFeatures(); ++i2) {
            String attString = this.featureStackArray.getLabel(i2);
            attributes.add(new Attribute(attString));
        }
        if (this.featureStackArray.useNeighborhood()) {
            for (i2 = 0; i2 < 8; ++i2) {
                IJ.log((String)("Adding extra attribute original_neighbor_" + (i2 + 1) + "..."));
                attributes.add(new Attribute(new String("original_neighbor_" + (i2 + 1))));
            }
        }
        attributes.add(new Attribute("class", classNames));
        String headerName = this.createHeaderName(this.isProcessing3D, imp.getType() == 4);
        Instances dataInfo = new Instances(headerName, attributes, 1);
        dataInfo.setClassIndex(dataInfo.numAttributes() - 1);
        long start = System.currentTimeMillis();
        if (this.exe.isShutdown()) {
            this.exe = Executors.newFixedThreadPool(numThreads);
        }
        final AtomicInteger counter = new AtomicInteger();
        int height = imp.getHeight();
        int width = imp.getWidth();
        int pad = (int)this.maximumSigma;
        int numOfRows = height * imp.getImageStackSize() / numThreads;
        Future[] fu = new Future[numThreads];
        ArrayList<int[]> imagePad = new ArrayList<int[]>();
        ArrayList[] list = new ArrayList[numThreads];
        for (int i4 = 0; i4 < numThreads; ++i4) {
            list[i4] = new ArrayList();
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            int firstRow = i4 * numOfRows;
            int lastRow = i4 < numThreads - 1 ? (i4 + 1) * numOfRows - 1 : height * imp.getImageStackSize() - 1;
            int r = firstRow;
            int rowsToDo = lastRow - firstRow + 1;
            while (r < lastRow) {
                int slice = r / height;
                int begin = r - slice * height;
                int end = begin + rowsToDo > height ? height - 1 : begin + rowsToDo - 1;
                ImageProcessor sliceImage = imp.getImageStack().getProcessor(slice + 1);
                int paddedBegin = begin - pad;
                int paddedEnd = end + pad;
                sliceImage.setRoi(new Rectangle(0, paddedBegin, width, paddedEnd - paddedBegin + 1));
                ImageProcessor im = sliceImage.crop();
                ImagePlus ip = new ImagePlus("slice-" + slice + "-" + begin, im);
                list[i4].add(ip);
                int padTop = paddedBegin >= 0 ? pad : pad + paddedBegin;
                int padBottom = paddedEnd < height ? pad : pad - (paddedEnd - height + 1);
                imagePad.add(new int[]{slice, padTop, padBottom, end - begin + 1});
                int rowsDone = end - begin + 1;
                r += rowsDone;
                rowsToDo -= rowsDone;
            }
        }
        AbstractClassifier[] classifierCopy = new AbstractClassifier[numThreads];
        IJ.log((String)"Creating classifier copy for each thread...");
        for (i = 0; i < numThreads; ++i) {
            try {
                if (this.classifier instanceof FastRandomForest || this.classifier instanceof RandomForest) {
                    classifierCopy[i] = this.classifier;
                    continue;
                }
                classifierCopy[i] = (AbstractClassifier)AbstractClassifier.makeCopy((Classifier)this.classifier);
                continue;
            }
            catch (Exception e) {
                IJ.log((String)"Error: classifier could not be copied to classify in a multi-thread way.");
                e.printStackTrace();
                return null;
            }
        }
        for (i = 0; i < numThreads; ++i) {
            fu[i] = this.exe.submit(this.classifyListOfImages(list[i], dataInfo, classifierCopy[i], counter, probabilityMaps));
        }
        final int numInstances = imp.getHeight() * imp.getWidth() * imp.getStackSize();
        ScheduledExecutorService monitor = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> task = monitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                IJ.showProgress((int)counter.get(), (int)numInstances);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        ArrayList<ImagePlus> classifiedImages = new ArrayList<ImagePlus>();
        for (int i5 = 0; i5 < numThreads; ++i5) {
            try {
                ArrayList result = (ArrayList)fu[i5].get();
                for (Object ip : result) {
                    classifiedImages.add((ImagePlus)ip);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ImagePlus end = null;
                return end;
            }
            catch (OutOfMemoryError err) {
                IJ.log((String)"ERROR: applyClassifierMT run out of memory. Please, use a smaller input image or fewer features.");
                err.printStackTrace();
                ImagePlus end = null;
                return end;
            }
            finally {
                task.cancel(true);
                monitor.shutdownNow();
                IJ.showProgress((double)1.0);
            }
        }
        ImageStack classified = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int i6 = 0; i6 < imp.getStackSize(); ++i6) {
            if (numChannels > 1) {
                for (int c = 0; c < numChannels; ++c) {
                    classified.addSlice(this.getClassLabel(c), (ImageProcessor)new FloatProcessor(width, height));
                }
                continue;
            }
            classified.addSlice("", (ImageProcessor)new ByteProcessor(width, height));
        }
        int n = 0;
        int raw = 0;
        for (ImagePlus ip : classifiedImages) {
            raw %= height;
            int[] coord = (int[])imagePad.get(n);
            int beginPad = coord[1];
            int endPad = coord[2];
            int size = coord[3];
            for (int c = 0; c < numChannels; ++c) {
                ImageProcessor target = classified.getProcessor(coord[0] * numChannels + c + 1);
                ImageProcessor source = ip.getImageStack().getProcessor(c + 1);
                source.setRoi(new Rectangle(0, beginPad, width, ip.getHeight() - endPad));
                source = source.crop();
                target.copyBits(source, 0, raw, 0);
            }
            raw += size;
            ++n;
        }
        ImagePlus result = new ImagePlus("Classification result", classified);
        if (probabilityMaps) {
            result.setDimensions(this.numOfClasses, imp.getNSlices(), imp.getNFrames());
            if (imp.getNSlices() * imp.getNFrames() > 1) {
                result.setOpenAsHyperStack(true);
            }
        }
        long end = System.currentTimeMillis();
        IJ.log((String)("Whole image classification took " + (end - start) + " ms."));
        return result;
    }

    public Callable<ImagePlus> classifySlice(final ImagePlus slice, final Instances dataInfo, final AbstractClassifier classifier, final AtomicInteger counter, final boolean probabilityMaps) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ImagePlus>(){

            @Override
            public ImagePlus call() {
                IJ.showStatus((String)"Creating features...");
                IJ.log((String)("Creating features of slice " + slice.getTitle() + "..."));
                FeatureStack sliceFeatures = new FeatureStack(slice);
                sliceFeatures.setEnabledFeatures(WekaSegmentation.this.enabledFeatures);
                sliceFeatures.setMaximumSigma(WekaSegmentation.this.maximumSigma);
                sliceFeatures.setMinimumSigma(WekaSegmentation.this.minimumSigma);
                sliceFeatures.setMembranePatchSize(WekaSegmentation.this.membranePatchSize);
                sliceFeatures.setMembraneSize(WekaSegmentation.this.membraneThickness);
                if (!sliceFeatures.updateFeaturesST()) {
                    IJ.log((String)"Classifier execution was interrupted.");
                    return null;
                }
                if (null != WekaSegmentation.this.trainHeader) {
                    sliceFeatures.reorderFeatures(WekaSegmentation.this.trainHeader);
                }
                WekaSegmentation.filterFeatureStackByList(WekaSegmentation.this.featureNames, sliceFeatures);
                int width = slice.getWidth();
                int height = slice.getHeight();
                int numClasses = dataInfo.numClasses();
                ImageStack classificationResult = new ImageStack(width, height);
                int numInstances = width * height;
                double[][] probArray = probabilityMaps ? new double[numClasses][numInstances] : new double[1][numInstances];
                IJ.log((String)("Classifying slice " + slice.getTitle() + "..."));
                int extra = sliceFeatures.useNeighborhood() ? 8 : 0;
                double[] values = new double[sliceFeatures.getSize() + 1 + extra];
                ReusableDenseInstance ins = new ReusableDenseInstance(1.0, values);
                ins.setDataset(dataInfo);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        try {
                            if (0 == (x + y * width) % 4000) {
                                if (Thread.currentThread().isInterrupted()) {
                                    return null;
                                }
                                counter.addAndGet(4000);
                            }
                            sliceFeatures.setInstance(x, y, 0, ins, values);
                            if (probabilityMaps) {
                                double[] prob = classifier.distributionForInstance((Instance)ins);
                                for (int k = 0; k < numClasses; ++k) {
                                    probArray[k][x + y * width] = prob[k];
                                }
                                continue;
                            }
                            probArray[0][x + y * width] = classifier.classifyInstance((Instance)ins);
                            continue;
                        }
                        catch (Exception e) {
                            IJ.showMessage((String)"Could not apply Classifier!");
                            e.printStackTrace();
                            return null;
                        }
                    }
                }
                if (probabilityMaps) {
                    for (int k = 0; k < numClasses; ++k) {
                        classificationResult.addSlice("class-" + (k + 1), (ImageProcessor)new FloatProcessor(width, height, probArray[k]));
                    }
                } else {
                    classificationResult.addSlice("result", (ImageProcessor)new FloatProcessor(width, height, probArray[0]));
                }
                return new ImagePlus("classified-slice", classificationResult);
            }
        };
    }

    public Callable<ArrayList<ImagePlus>> classifyListOfImages(final ArrayList<ImagePlus> images, final Instances dataInfo, final AbstractClassifier classifier, final AtomicInteger counter, final boolean probabilityMaps) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<ArrayList<ImagePlus>>(){

            @Override
            public ArrayList<ImagePlus> call() {
                ArrayList<ImagePlus> result = new ArrayList<ImagePlus>();
                for (ImagePlus image : images) {
                    IJ.showStatus((String)"Creating features...");
                    IJ.log((String)("Creating features of slice " + image.getTitle() + ", size = " + image.getWidth() + "x" + image.getHeight() + "..."));
                    FeatureStack sliceFeatures = new FeatureStack(image);
                    sliceFeatures.setEnabledFeatures(WekaSegmentation.this.enabledFeatures);
                    sliceFeatures.setMaximumSigma(WekaSegmentation.this.maximumSigma);
                    sliceFeatures.setMinimumSigma(WekaSegmentation.this.minimumSigma);
                    sliceFeatures.setMembranePatchSize(WekaSegmentation.this.membranePatchSize);
                    sliceFeatures.setMembraneSize(WekaSegmentation.this.membraneThickness);
                    if (!sliceFeatures.updateFeaturesST()) {
                        IJ.log((String)"Classifier execution was interrupted.");
                        return null;
                    }
                    if (null != WekaSegmentation.this.trainHeader) {
                        sliceFeatures.reorderFeatures(WekaSegmentation.this.trainHeader);
                    }
                    WekaSegmentation.filterFeatureStackByList(WekaSegmentation.this.featureNames, sliceFeatures);
                    int width = image.getWidth();
                    int height = image.getHeight();
                    int numClasses = dataInfo.numClasses();
                    ImageStack classificationResult = new ImageStack(width, height);
                    int numInstances = width * height;
                    double[][] probArray = probabilityMaps ? new double[numClasses][numInstances] : new double[1][numInstances];
                    IJ.log((String)("Classifying slice " + image.getTitle() + "..."));
                    int extra = sliceFeatures.useNeighborhood() ? 8 : 0;
                    double[] values = new double[sliceFeatures.getSize() + 1 + extra];
                    ReusableDenseInstance ins = new ReusableDenseInstance(1.0, values);
                    ins.setDataset(dataInfo);
                    for (int i = 0; i < numInstances; ++i) {
                        for (int x = 0; x < width; ++x) {
                            for (int y = 0; y < height; ++y) {
                                try {
                                    if (0 == (x + y * width) % 4000) {
                                        if (Thread.currentThread().isInterrupted()) {
                                            return null;
                                        }
                                        counter.addAndGet(4000);
                                    }
                                    sliceFeatures.setInstance(x, y, 0, ins, values);
                                    if (probabilityMaps) {
                                        double[] prob = classifier.distributionForInstance((Instance)ins);
                                        for (int k = 0; k < numClasses; ++k) {
                                            probArray[k][x + y * width] = prob[k];
                                        }
                                        continue;
                                    }
                                    probArray[0][x + y * width] = classifier.classifyInstance((Instance)ins);
                                    continue;
                                }
                                catch (Exception e) {
                                    IJ.showMessage((String)"Could not apply Classifier!");
                                    e.printStackTrace();
                                    return null;
                                }
                            }
                        }
                    }
                    if (probabilityMaps) {
                        for (int k = 0; k < numClasses; ++k) {
                            classificationResult.addSlice("class-" + (k + 1), (ImageProcessor)new FloatProcessor(width, height, probArray[k]));
                        }
                    } else {
                        classificationResult.addSlice("result", (ImageProcessor)new FloatProcessor(width, height, probArray[0]));
                    }
                    result.add(new ImagePlus("classified-image-" + image.getTitle(), classificationResult));
                }
                return result;
            }
        };
    }

    public ImagePlus applyClassifier(ImagePlus imp, ImagePlus filters, int numThreads, boolean probabilityMaps) {
        return this.applyClassifier(imp, new FeatureStackArray(imp, filters), numThreads, probabilityMaps);
    }

    public ImagePlus applyClassifier(final ImagePlus imp, FeatureStackArray fsa, int numThreads, final boolean probabilityMaps) {
        if (numThreads == 0) {
            numThreads = Prefs.getThreads();
        }
        int numSliceThreads = Math.min(imp.getStackSize(), numThreads);
        int numClasses = this.numOfClasses;
        int numChannels = probabilityMaps ? numClasses : 1;
        IJ.log((String)("Processing slices of " + imp.getTitle() + " in " + numSliceThreads + " thread(s)..."));
        ArrayList<Object> classNames = new ArrayList();
        if (null == this.loadedClassNames) {
            for (int i = 0; i < this.numOfClasses; ++i) {
                classNames.add(this.getClassLabel(i));
            }
        } else {
            classNames = this.loadedClassNames;
        }
        final ImagePlus[] classifiedSlices = new ImagePlus[imp.getStackSize()];
        int numFurtherThreads = (int)Math.ceil((double)(numThreads - numSliceThreads) / (double)numSliceThreads) + 1;
        class ApplyClassifierThread
        extends Thread {
            private final int startSlice;
            private final int numSlices;
            private final int numFurtherThreads;
            private final ArrayList<String> classNames;
            private final FeatureStackArray fsa;

            public ApplyClassifierThread(int startSlice, int numSlices, int numFurtherThreads, ArrayList<String> classNames, FeatureStackArray fsa) {
                this.startSlice = startSlice;
                this.numSlices = numSlices;
                this.numFurtherThreads = numFurtherThreads;
                this.classNames = classNames;
                this.fsa = fsa;
            }

            @Override
            public void run() {
                for (int i = this.startSlice; i < this.startSlice + this.numSlices; ++i) {
                    ImagePlus slice = new ImagePlus(imp.getImageStack().getSliceLabel(i), imp.getImageStack().getProcessor(i));
                    Instances sliceData = this.fsa.get(i - 1).createInstances(this.classNames);
                    sliceData.setClassIndex(sliceData.numAttributes() - 1);
                    IJ.log((String)("Classifying slice " + i + " in " + this.numFurtherThreads + " thread(s)..."));
                    ImagePlus classImage = this.applyClassifier(sliceData, slice.getWidth(), slice.getHeight(), this.numFurtherThreads, probabilityMaps);
                    if (null == classImage) {
                        IJ.log((String)"Error while applying classifier!");
                        return;
                    }
                    classImage.setTitle("classified_" + slice.getTitle());
                    if (probabilityMaps) {
                        classImage.setProcessor(classImage.getProcessor().duplicate());
                    } else {
                        classImage.setProcessor(classImage.getProcessor().convertToByte(false).duplicate());
                    }
                    classifiedSlices[i - 1] = classImage;
                }
            }
        }
        ApplyClassifierThread[] threads = new ApplyClassifierThread[numSliceThreads];
        int[] numSlicesPerThread = new int[numSliceThreads];
        for (int i = 0; i < imp.getImageStackSize(); ++i) {
            int n = i % numSliceThreads;
            numSlicesPerThread[n] = numSlicesPerThread[n] + 1;
        }
        int aux = 0;
        for (int i = 0; i < numSliceThreads; ++i) {
            int startSlice = aux + 1;
            aux += numSlicesPerThread[i];
            IJ.log((String)("Starting thread " + i + " processing " + numSlicesPerThread[i] + " slices, starting with " + startSlice));
            threads[i] = new ApplyClassifierThread(startSlice, numSlicesPerThread[i], numFurtherThreads, classNames, fsa);
            threads[i].start();
        }
        ImageStack classified = new ImageStack(imp.getWidth(), imp.getHeight());
        for (ApplyClassifierThread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < imp.getStackSize(); ++i) {
            for (int c = 0; c < numChannels; ++c) {
                classified.addSlice(probabilityMaps ? this.getClassLabel(c) : "", classifiedSlices[i].getStack().getProcessor(c + 1));
            }
        }
        ImagePlus result = new ImagePlus("Classification result", classified);
        if (probabilityMaps) {
            result.setDimensions(this.numOfClasses, imp.getNSlices(), imp.getNFrames());
            if (imp.getNSlices() * imp.getNFrames() > 1) {
                result.setOpenAsHyperStack(true);
            }
        }
        result.setCalibration(this.trainingImage.getCalibration());
        return result;
    }

    public void applyClassifier(boolean classify) {
        if (null == this.trainingImage) {
            IJ.log((String)"Error: no training image has been loaded!");
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            IJ.log((String)"Classification was interrupted by the user.");
            return;
        }
        this.applyClassifier(0, classify);
    }

    public void applyClassifier(int numThreads, boolean classify) {
        if (null == this.trainingImage) {
            IJ.log((String)"Error: no training image has been loaded!");
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            IJ.log((String)"Training was interrupted by the user.");
            return;
        }
        if (numThreads == 0) {
            numThreads = Prefs.getThreads();
        }
        boolean allUsed = true;
        if (!this.isProcessing3D) {
            for (int j = 0; j < this.featureStackToUpdateTest.length; ++j) {
                if (!this.featureStackToUpdateTest[j]) continue;
                allUsed = false;
                break;
            }
        }
        if (!allUsed || this.featureStackArray.isEmpty() || this.updateFeatures) {
            IJ.showStatus((String)"Creating feature stack...");
            IJ.log((String)"Creating feature stack...");
            long start = System.currentTimeMillis();
            if (!this.isProcessing3D && !this.featureStackArray.updateFeaturesMT(this.featureStackToUpdateTest)) {
                IJ.log((String)"Feature stack was not updated.");
                IJ.showStatus((String)"Feature stack was not updated.");
                return;
            }
            if (this.isProcessing3D) {
                if (!this.fs3d.updateFeaturesMT()) {
                    IJ.log((String)"Feature stack 3D was not updated.");
                    IJ.showStatus((String)"Feature stack 3D was not updated.");
                    return;
                }
                this.featureStackArray = this.fs3d.getFeatureStackArray();
            }
            Arrays.fill(this.featureStackToUpdateTest, false);
            if (null != this.trainHeader) {
                this.featureStackArray.reorderFeatures(this.trainHeader);
            }
            this.filterFeatureStackByList();
            this.updateFeatures = false;
            long end = System.currentTimeMillis();
            IJ.log((String)("Feature stack array is now updated (" + this.featureStackArray.getSize() + " slice(s) with " + this.featureStackArray.getNumOfFeatures() + " features, took " + (end - start) + "ms)."));
        }
        IJ.log((String)("Classifying whole image using " + numThreads + " thread(s)..."));
        try {
            this.classifiedImage = this.applyClassifier(this.featureStackArray, numThreads, classify);
            if (null != this.trainingImage) {
                this.classifiedImage.setCalibration(this.trainingImage.getCalibration());
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error while classifying whole image! ");
            ex.printStackTrace();
        }
        IJ.log((String)"Finished segmentation of whole image.\n");
    }

    public ImagePlus applyClassifier(ImagePlus imp, int[] tilesPerDim, int numThreads, boolean probabilityMaps) {
        int expectedDims;
        int n = expectedDims = this.isProcessing3D ? 3 : 2;
        if (tilesPerDim.length != expectedDims) {
            IJ.log((String)("Error in applyClassifier: expected dimensions were " + expectedDims + " but " + tilesPerDim.length + " were found in the array of tiles per dimension."));
            return null;
        }
        int numTiles = tilesPerDim[0] * tilesPerDim[1];
        if (this.isProcessing3D) {
            numTiles *= tilesPerDim[2];
        }
        long start = System.currentTimeMillis();
        IJ.log((String)("Classifying " + imp.getTitle() + " using " + numTiles + " tiles..."));
        int[] impDims = new int[tilesPerDim.length];
        impDims[0] = imp.getWidth();
        impDims[1] = imp.getHeight();
        if (this.isProcessing3D) {
            impDims[2] = imp.getNSlices();
        }
        int[] tileSize = new int[tilesPerDim.length];
        tileSize[0] = imp.getWidth() / tilesPerDim[0];
        tileSize[1] = imp.getHeight() / tilesPerDim[1];
        if (this.isProcessing3D) {
            tileSize[2] = imp.getNSlices() / tilesPerDim[2];
        }
        int[] origin = this.isProcessing3D ? new int[3] : new int[2];
        int[] cropDims = new int[tilesPerDim.length];
        int nClasses = this.getNumOfClasses();
        ImageStack classified = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int i = 0; i < imp.getStackSize(); ++i) {
            if (probabilityMaps) {
                for (int c = 0; c < nClasses; ++c) {
                    classified.addSlice(this.getClassLabel(c), (ImageProcessor)new FloatProcessor(imp.getWidth(), imp.getHeight()));
                }
                continue;
            }
            classified.addSlice("", (ImageProcessor)new ByteProcessor(imp.getWidth(), imp.getHeight()));
        }
        ImagePlus result = new ImagePlus("Classification result", classified);
        if (probabilityMaps) {
            result.setDimensions(this.numOfClasses, imp.getNSlices(), imp.getNFrames());
            if (imp.getNSlices() * imp.getNFrames() > 1) {
                result.setOpenAsHyperStack(true);
            }
        }
        result.setCalibration(imp.getCalibration());
        int numZ = this.isProcessing3D ? tilesPerDim[2] : 1;
        for (int i = 0; i < tilesPerDim[0]; ++i) {
            for (int j = 0; j < tilesPerDim[1]; ++j) {
                origin[0] = tileSize[0] * i;
                origin[1] = tileSize[1] * j;
                cropDims[0] = i == tilesPerDim[0] - 1 ? impDims[0] - origin[0] : tileSize[0];
                cropDims[1] = j == tilesPerDim[1] - 1 ? impDims[1] - origin[1] : tileSize[1];
                for (int k = 0; k < numZ; ++k) {
                    if (this.isProcessing3D) {
                        origin[2] = tileSize[2] * k;
                        cropDims[2] = k == tilesPerDim[2] - 1 ? impDims[2] - origin[2] : tileSize[2];
                    }
                    ImagePlus tileResult = this.applyClassifier(imp, origin, cropDims, numThreads, probabilityMaps);
                    Utils.insertImage(tileResult, result, origin);
                }
            }
        }
        if (probabilityMaps) {
            result.resetDisplayRange();
            result.setTitle("Probability maps");
        }
        long end = System.currentTimeMillis();
        IJ.log((String)("Finished classification of " + imp.getTitle() + " using " + numTiles + " tiles in " + (end - start) + "ms."));
        return result;
    }

    public ImagePlus applyClassifier(ImagePlus imp, int[] origin, int[] cropDims, int numThreads, boolean probabilityMaps) {
        int expectedDims;
        int n = expectedDims = this.isProcessing3D ? 3 : 2;
        if (origin.length != expectedDims) {
            IJ.log((String)"Apply Classifier: Wrong cropping and image dimensions!");
            IJ.log((String)("Origin: (" + origin[0] + ", " + origin[1] + (this.isProcessing3D ? ", " + origin[2] : "") + ")."));
            IJ.log((String)("Cropping dimensions: " + cropDims[0] + ", " + cropDims[1] + (this.isProcessing3D ? ", " + cropDims[2] : ".")));
            return null;
        }
        int[] impDims = new int[cropDims.length];
        impDims[0] = imp.getWidth();
        impDims[1] = imp.getHeight();
        if (this.isProcessing3D) {
            impDims[2] = imp.getNSlices();
        }
        int[] lastCoord = new int[cropDims.length];
        for (int i = 0; i < lastCoord.length; ++i) {
            lastCoord[i] = origin[i] + cropDims[i] - 1;
            if (origin[i] >= 0 && cropDims[i] > 0 && lastCoord[i] < impDims[i]) continue;
            IJ.log((String)"Apply Classifier: Wrong cropping size!");
            IJ.log((String)("Origin: (" + origin[0] + ", " + origin[1] + (this.isProcessing3D ? ", " + origin[2] : "") + ")."));
            IJ.log((String)("Cropping dimensions: " + cropDims[0] + ", " + cropDims[1] + (this.isProcessing3D ? ", " + cropDims[2] : ".")));
            return null;
        }
        int[][] pad = new int[cropDims.length][2];
        for (int i = 0; i < pad.length; ++i) {
            pad[i][0] = origin[i] - (int)this.maximumSigma < 0 ? 0 : (int)this.maximumSigma;
            pad[i][1] = origin[i] + cropDims[i] + (int)this.maximumSigma >= impDims[i] ? 0 : (int)this.maximumSigma;
        }
        imp.setRoi(origin[0] - pad[0][0], origin[1] - pad[1][0], pad[0][0] + cropDims[0] + pad[0][1], pad[1][0] + cropDims[1] + pad[1][1]);
        int initSlice = 1;
        int endSlice = 1;
        if (this.isProcessing3D) {
            initSlice = origin[2] - pad[2][0] + 1;
            endSlice = origin[2] + cropDims[2] + pad[2][1];
            imp.setSlice(initSlice);
        }
        Duplicator dup = new Duplicator();
        ImagePlus cropImage = dup.run(imp, initSlice, endSlice);
        cropImage.setTitle(imp.getShortTitle() + "-crop-" + origin[0] + "-" + origin[1]);
        ImagePlus result = this.applyClassifier(cropImage, numThreads, probabilityMaps);
        result.setRoi(pad[0][0], pad[1][0], cropDims[0], cropDims[1]);
        ImagePlus croppedRes = this.isProcessing3D ? dup.run(result, 1, result.getNChannels(), 1 + pad[2][0], 1 + pad[2][0] + cropDims[2], 1, 1) : dup.run(result, 1, result.getNChannels(), 1, 1, 1, 1);
        croppedRes.setTitle(result.getTitle());
        croppedRes.setCalibration(result.getCalibration());
        return croppedRes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instances updateWholeImageData() {
        Instances wholeImageData = null;
        IJ.showStatus((String)"Reading whole image data...");
        IJ.log((String)"Reading whole image data...");
        long start = System.currentTimeMillis();
        ArrayList<String> classNames = null;
        if (null != this.loadedClassNames) {
            classNames = this.loadedClassNames;
        } else {
            classNames = new ArrayList();
            for (int j = 0; j < this.trainingImage.getImageStackSize(); ++j) {
                for (int i = 0; i < this.numOfClasses; ++i) {
                    if (this.examples[j].get(i).size() <= 0 || classNames.contains(this.getClassLabel(i))) continue;
                    classNames.add(this.getClassLabel(i));
                }
            }
        }
        int numProcessors = Prefs.getThreads();
        ExecutorService exe = Executors.newFixedThreadPool(numProcessors);
        ArrayList<Future<Instances>> futures = new ArrayList<Future<Instances>>();
        try {
            for (int z = 1; z <= this.trainingImage.getImageStackSize(); ++z) {
                IJ.log((String)("Creating feature vectors for slice number " + z + "..."));
                futures.add(exe.submit(this.createInstances(classNames, this.featureStackArray.get(z - 1))));
            }
            Instances[] data = new Instances[futures.size()];
            for (int z = 1; z <= this.trainingImage.getImageStackSize(); ++z) {
                data[z - 1] = (Instances)((Future)futures.get(z - 1)).get();
                data[z - 1].setClassIndex(data[z - 1].numAttributes() - 1);
            }
            for (int n = 0; n < data.length; ++n) {
                if (null == wholeImageData) {
                    wholeImageData = data[n];
                    continue;
                }
                this.mergeDataInPlace(wholeImageData, data[n]);
            }
            IJ.log((String)("Total dataset: " + wholeImageData.numInstances() + " instances, " + wholeImageData.numAttributes() + " attributes."));
            long end = System.currentTimeMillis();
            IJ.log((String)("Creating whole image data took: " + (end - start) + "ms"));
        }
        catch (InterruptedException e) {
            IJ.log((String)"The data update was interrupted by the user.");
            IJ.showStatus((String)"The data update was interrupted by the user.");
            IJ.showProgress((double)1.0);
            exe.shutdownNow();
            Instances instances = null;
            return instances;
        }
        catch (Exception ex) {
            IJ.log((String)"Error when updating data for the whole image test set.");
            ex.printStackTrace();
            exe.shutdownNow();
            Instances instances = null;
            return instances;
        }
        finally {
            exe.shutdown();
        }
        return wholeImageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus applyClassifier(Instances data, int w, int h, int numThreads, boolean probabilityMaps) {
        if (numThreads == 0) {
            numThreads = Prefs.getThreads();
        }
        int numClasses = data.numClasses();
        final int numInstances = data.numInstances();
        int numChannels = probabilityMaps ? numClasses : 1;
        int numSlices = numChannels * numInstances / (w * h);
        IJ.showStatus((String)"Classifying image...");
        long start = System.currentTimeMillis();
        ExecutorService exe = Executors.newFixedThreadPool(numThreads);
        double[][][] results = new double[numThreads][][];
        Instances[] partialData = new Instances[numThreads];
        int partialSize = numInstances / numThreads;
        Future[] fu = new Future[numThreads];
        final AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < numThreads; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                exe.shutdown();
                return null;
            }
            partialData[i] = i == numThreads - 1 ? new Instances(data, i * partialSize, numInstances - i * partialSize) : new Instances(data, i * partialSize, partialSize);
            AbstractClassifier classifierCopy = null;
            try {
                classifierCopy = this.classifier instanceof FastRandomForest || this.classifier instanceof RandomForest ? this.classifier : (AbstractClassifier)AbstractClassifier.makeCopy((Classifier)this.classifier);
            }
            catch (Exception e) {
                IJ.log((String)"Error: classifier could not be copied to classify in a multi-thread way.");
                e.printStackTrace();
            }
            fu[i] = exe.submit(WekaSegmentation.classifyInstances(partialData[i], classifierCopy, counter, probabilityMaps));
        }
        ScheduledExecutorService monitor = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> task = monitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                IJ.showProgress((int)counter.get(), (int)numInstances);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        for (int i = 0; i < numThreads; ++i) {
            try {
                results[i] = (double[][])fu[i].get();
                continue;
            }
            catch (InterruptedException e) {
                ImagePlus imagePlus = null;
                return imagePlus;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                ImagePlus imagePlus = null;
                return imagePlus;
            }
            finally {
                exe.shutdown();
                task.cancel(true);
                monitor.shutdownNow();
                IJ.showProgress((double)1.0);
            }
        }
        exe.shutdown();
        double[][] classificationResult = new double[numChannels][numInstances];
        for (int i = 0; i < numThreads; ++i) {
            for (int c = 0; c < numChannels; ++c) {
                System.arraycopy(results[i][c], 0, classificationResult[c], i * partialSize, results[i][c].length);
            }
        }
        IJ.showProgress((double)1.0);
        long end = System.currentTimeMillis();
        IJ.log((String)("Classifying whole image data took: " + (end - start) + "ms"));
        double[] classifiedSlice = new double[w * h];
        ImageStack classStack = new ImageStack(w, h);
        for (int i = 0; i < numSlices / numChannels; ++i) {
            for (int c = 0; c < numChannels; ++c) {
                System.arraycopy(classificationResult[c], i * (w * h), classifiedSlice, 0, w * h);
                FloatProcessor classifiedSliceProcessor = new FloatProcessor(w, h, classifiedSlice);
                if (!probabilityMaps) {
                    classifiedSliceProcessor = classifiedSliceProcessor.convertToByte(false);
                }
                classStack.addSlice(probabilityMaps ? this.getClassLabel(c) : "", (ImageProcessor)classifiedSliceProcessor);
            }
        }
        ImagePlus classImg = new ImagePlus(probabilityMaps ? "Probability maps" : "Classification result", classStack);
        return classImg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus applyClassifier(FeatureStackArray fsa, int numThreads, boolean probabilityMaps) {
        AbstractClassifier classifierCopy;
        int i;
        if (numThreads == 0) {
            numThreads = Prefs.getThreads();
        }
        if (fsa.isOldColorFormat()) {
            IJ.log((String)"Using old color format...");
        }
        ArrayList<String> classNames = null;
        if (null != this.loadedClassNames) {
            classNames = this.loadedClassNames;
        } else {
            classNames = new ArrayList();
            for (int i2 = 0; i2 < this.numOfClasses; ++i2) {
                if (classNames.contains(this.getClassLabel(i2))) continue;
                classNames.add(this.getClassLabel(i2));
            }
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (i = 1; i <= fsa.getNumOfFeatures(); ++i) {
            String attString = fsa.getLabel(i);
            attributes.add(new Attribute(attString));
        }
        if (fsa.useNeighborhood()) {
            for (i = 0; i < 8; ++i) {
                IJ.log((String)("Adding extra attribute original_neighbor_" + (i + 1) + "..."));
                attributes.add(new Attribute(new String("original_neighbor_" + (i + 1))));
            }
        }
        attributes.add(new Attribute("class", classNames));
        String headerName = this.createHeaderName(this.isProcessing3D, fsa.isRGB());
        Instances dataInfo = new Instances(headerName, attributes, 1);
        dataInfo.setClassIndex(dataInfo.numAttributes() - 1);
        int numClasses = classNames.size();
        final int numInstances = fsa.getSize() * fsa.getWidth() * fsa.getHeight();
        int numChannels = probabilityMaps ? numClasses : 1;
        int numSlices = numChannels * numInstances / (fsa.getWidth() * fsa.getHeight());
        IJ.showStatus((String)"Classifying image...");
        long start = System.currentTimeMillis();
        this.exe = Executors.newFixedThreadPool(numThreads);
        double[][][] results = new double[numThreads][][];
        int partialSize = numInstances / numThreads;
        Future[] fu = new Future[numThreads];
        final AtomicInteger counter = new AtomicInteger();
        for (int i3 = 0; i3 < numThreads; ++i3) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            int first = i3 * partialSize;
            int size = i3 == numThreads - 1 ? numInstances - i3 * partialSize : partialSize;
            classifierCopy = null;
            try {
                classifierCopy = this.classifier instanceof FastRandomForest || this.classifier instanceof RandomForest ? this.classifier : (AbstractClassifier)AbstractClassifier.makeCopy((Classifier)this.classifier);
            }
            catch (Exception e) {
                IJ.log((String)"Error: classifier could not be copied to classify in a multi-thread way.");
                e.printStackTrace();
            }
            fu[i3] = this.exe.submit(WekaSegmentation.classifyInstances(fsa, dataInfo, first, size, classifierCopy, counter, probabilityMaps));
        }
        ScheduledExecutorService monitor = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> task = monitor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                IJ.showProgress((int)counter.get(), (int)numInstances);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        try {
            for (int i4 = 0; i4 < numThreads; ++i4) {
                results[i4] = (double[][])fu[i4].get();
            }
        }
        catch (InterruptedException e) {
            classifierCopy = null;
            return classifierCopy;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            classifierCopy = null;
            return classifierCopy;
        }
        catch (OutOfMemoryError err) {
            IJ.log((String)"ERROR: applyClassifier run out of memory. Please, use a smaller input image or fewer features.");
            err.printStackTrace();
            classifierCopy = null;
            return classifierCopy;
        }
        finally {
            this.exe.shutdown();
            task.cancel(true);
            monitor.shutdownNow();
            IJ.showProgress((double)1.0);
        }
        double[][] classificationResult = new double[numChannels][numInstances];
        for (int i5 = 0; i5 < numThreads; ++i5) {
            for (int c = 0; c < numChannels; ++c) {
                System.arraycopy(results[i5][c], 0, classificationResult[c], i5 * partialSize, results[i5][c].length);
            }
        }
        IJ.showProgress((double)1.0);
        long end = System.currentTimeMillis();
        IJ.log((String)("Classifying whole image data took: " + (end - start) + "ms"));
        double[] classifiedSlice = new double[fsa.getWidth() * fsa.getHeight()];
        ImageStack classStack = new ImageStack(fsa.getWidth(), fsa.getHeight());
        for (int i6 = 0; i6 < numSlices / numChannels; ++i6) {
            for (int c = 0; c < numChannels; ++c) {
                System.arraycopy(classificationResult[c], i6 * (fsa.getWidth() * fsa.getHeight()), classifiedSlice, 0, fsa.getWidth() * fsa.getHeight());
                FloatProcessor classifiedSliceProcessor = new FloatProcessor(fsa.getWidth(), fsa.getHeight(), classifiedSlice);
                if (!probabilityMaps) {
                    classifiedSliceProcessor = classifiedSliceProcessor.convertToByte(false);
                }
                classStack.addSlice(probabilityMaps ? this.getClassLabel(c) : "", (ImageProcessor)classifiedSliceProcessor);
            }
        }
        ImagePlus classImg = new ImagePlus(probabilityMaps ? "Probability maps" : "Classification result", classStack);
        return classImg;
    }

    private static Callable<double[][]> classifyInstances(final FeatureStackArray fsa, final Instances dataInfo, final int first, final int numInstances, final AbstractClassifier classifier, final AtomicInteger counter, final boolean probabilityMaps) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<double[][]>(){

            @Override
            public double[][] call() {
                int width = fsa.getWidth();
                int height = fsa.getHeight();
                int sliceSize = width * height;
                int numClasses = dataInfo.numClasses();
                double[][] classificationResult = probabilityMaps ? new double[numClasses][numInstances] : new double[1][numInstances];
                int extra = fsa.useNeighborhood() ? 8 : 0;
                double[] values = new double[fsa.getNumOfFeatures() + 1 + extra];
                ReusableDenseInstance ins = new ReusableDenseInstance(1.0, values);
                ins.setDataset(dataInfo);
                for (int i = 0; i < numInstances; ++i) {
                    try {
                        if (0 == i % 4000) {
                            if (Thread.currentThread().isInterrupted()) {
                                return null;
                            }
                            counter.addAndGet(4000);
                        }
                        int absolutePos = first + i;
                        int slice = absolutePos / sliceSize;
                        int localPos = absolutePos - slice * sliceSize;
                        int x = localPos % width;
                        int y = localPos / width;
                        fsa.get(slice).setInstance(x, y, 0, ins, values);
                        if (probabilityMaps) {
                            double[] prob = classifier.distributionForInstance((Instance)ins);
                            for (int k = 0; k < numClasses; ++k) {
                                classificationResult[k][i] = prob[k];
                            }
                            continue;
                        }
                        classificationResult[0][i] = classifier.classifyInstance((Instance)ins);
                        continue;
                    }
                    catch (Exception e) {
                        IJ.showMessage((String)"Could not apply Classifier!");
                        e.printStackTrace();
                        return null;
                    }
                }
                return classificationResult;
            }
        };
    }

    private static Callable<double[][]> classifyInstances(final Instances data, final AbstractClassifier classifier, final AtomicInteger counter, final boolean probabilityMaps) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        return new Callable<double[][]>(){

            @Override
            public double[][] call() {
                int numInstances = data.numInstances();
                int numClasses = data.numClasses();
                double[][] classificationResult = probabilityMaps ? new double[numClasses][numInstances] : new double[1][numInstances];
                for (int i = 0; i < numInstances; ++i) {
                    try {
                        if (0 == i % 4000) {
                            if (Thread.currentThread().isInterrupted()) {
                                return null;
                            }
                            counter.addAndGet(4000);
                        }
                        if (probabilityMaps) {
                            double[] prob = classifier.distributionForInstance(data.get(i));
                            for (int k = 0; k < numClasses; ++k) {
                                classificationResult[k][i] = prob[k];
                            }
                            continue;
                        }
                        classificationResult[0][i] = classifier.classifyInstance(data.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        IJ.showMessage((String)"Could not apply Classifier!");
                        e.printStackTrace();
                        return null;
                    }
                }
                return classificationResult;
            }
        };
    }

    public boolean setFeatures(ArrayList<String> featureNames) {
        if (null == featureNames) {
            return false;
        }
        this.featureNames = featureNames;
        int numFeatures = FeatureStack.availableFeatures.length;
        boolean[] usedFeatures = new boolean[numFeatures];
        for (String name : featureNames) {
            for (int i = 0; i < numFeatures; ++i) {
                if (!name.startsWith(FeatureStack.availableFeatures[i])) continue;
                usedFeatures[i] = true;
            }
        }
        this.featureStackArray.setEnabledFeatures(usedFeatures);
        return true;
    }

    public void setMembraneThickness(int thickness) {
        this.membraneThickness = thickness;
        this.featureStackArray.setMembraneSize(thickness);
    }

    public int getMembraneThickness() {
        return this.membraneThickness;
    }

    public void setMembranePatchSize(int patchSize) {
        this.membranePatchSize = patchSize;
        this.featureStackArray.setMembranePatchSize(patchSize);
    }

    public int getMembranePatchSize() {
        return this.membranePatchSize;
    }

    public void setMaximumSigma(float sigma) {
        this.maximumSigma = sigma;
        if (null != this.featureStackArray) {
            this.featureStackArray.setMaximumSigma(sigma);
        }
        if (this.isProcessing3D && null != this.fs3d) {
            this.fs3d.setMaximumSigma(sigma);
        }
    }

    public float getMaximumSigma() {
        return this.maximumSigma;
    }

    public void setMinimumSigma(float sigma) {
        this.minimumSigma = sigma;
        this.featureStackArray.setMinimumSigma(sigma);
        if (this.isProcessing3D) {
            this.fs3d.setMinimumSigma(sigma);
        }
    }

    public float getMinimumSigma() {
        return this.minimumSigma;
    }

    public int getNumOfTrees() {
        return this.numOfTrees;
    }

    public int getNumRandomFeatures() {
        return this.randomFeatures;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setDoHomogenizeClasses(boolean homogenizeClasses) {
        this.balanceClasses = homogenizeClasses;
    }

    public boolean doHomogenizeClasses() {
        return this.balanceClasses;
    }

    public void setDoClassBalance(boolean balanceClasses) {
        this.balanceClasses = balanceClasses;
    }

    public boolean doClassBalance() {
        return this.balanceClasses;
    }

    public void setUpdateFeatures(boolean updateFeatures) {
        this.updateFeatures = updateFeatures;
    }

    public void setFeaturesDirty() {
        this.updateFeatures = true;
        if (this.isProcessing3D || null == this.featureStackArray) {
            return;
        }
        Arrays.fill(this.featureStackToUpdateTrain, false);
        Arrays.fill(this.featureStackToUpdateTest, true);
        for (int indexSlice = 0; indexSlice < this.trainingImage.getImageStackSize(); ++indexSlice) {
            for (int indexClass = 0; indexClass < this.numOfClasses; ++indexClass) {
                if (this.examples[indexSlice].get(indexClass).isEmpty()) continue;
                this.featureStackToUpdateTrain[indexSlice] = true;
                this.featureStackToUpdateTest[indexSlice] = false;
                break;
            }
            this.featureStackArray.get(indexSlice).setStack(null);
        }
        this.featureStackArray.resetReference();
        this.trainHeader = null;
        this.featureNames = null;
    }

    public boolean updateClassifier(int newNumTrees, int newRandomFeatures, int newMaxDepth) {
        if (newNumTrees < 1 || newRandomFeatures < 0) {
            return false;
        }
        this.numOfTrees = newNumTrees;
        this.randomFeatures = newRandomFeatures;
        this.maxDepth = newMaxDepth;
        this.rf.setNumTrees(this.numOfTrees);
        this.rf.setNumFeatures(this.randomFeatures);
        this.rf.setMaxDepth(this.maxDepth);
        return true;
    }

    public void setEnabledFeatures(boolean[] newFeatures) {
        if (this.isProcessing3D) {
            this.enabled3Dfeatures = newFeatures;
            if (null != this.fs3d) {
                this.fs3d.setEnableFeatures(newFeatures);
            }
        } else {
            this.enabledFeatures = newFeatures;
        }
        if (null != this.featureStackArray) {
            this.featureStackArray.setEnabledFeatures(newFeatures);
        }
    }

    public boolean[] getEnabledFeatures() {
        if (this.isProcessing3D) {
            return this.fs3d.getEnabledFeatures();
        }
        return this.enabledFeatures;
    }

    public void mergeDataInPlace(Instances first, Instances second) {
        for (int i = 0; i < second.numInstances(); ++i) {
            first.add(second.get(i));
        }
    }

    public void shutDownNow() {
        this.featureStackArray.shutDownNow();
        this.exe.shutdownNow();
    }

    public void setFeatureStackArray(FeatureStackArray fsa) {
        this.featureStackArray = fsa;
        this.featureStackToUpdateTrain = new boolean[this.featureStackArray.getSize()];
        this.featureStackToUpdateTest = new boolean[this.featureStackArray.getSize()];
        Arrays.fill(this.featureStackToUpdateTest, false);
        this.updateFeatures = false;
        this.useNeighbors = fsa.useNeighborhood();
    }

    public void setLoadedClassNames(ArrayList<String> classNames) {
        this.loadedClassNames = classNames;
    }

    public void saveFeatureStack(int slice, String dir, String fileWithExt) {
        if (this.featureStackArray.isEmpty() || this.featureStackArray.getReferenceSliceIndex() == -1) {
            IJ.showStatus((String)"Creating feature stack...");
            IJ.log((String)"Creating feature stack...");
            if (!this.isProcessing3D) {
                this.featureStackArray.updateFeaturesMT();
            } else {
                this.fs3d.updateFeaturesMT();
                this.featureStackArray = this.fs3d.getFeatureStackArray();
            }
            if (null != this.trainHeader) {
                this.featureStackArray.reorderFeatures(this.trainHeader);
            } else {
                IJ.log((String)"Train header is null");
            }
        }
        if (null == dir || null == fileWithExt) {
            return;
        }
        String fileName = dir + fileWithExt.substring(0, fileWithExt.length() - 4) + String.format("%04d", slice) + ".tif";
        if (!this.featureStackArray.get(slice - 1).saveStackAsTiff(fileName)) {
            IJ.error((String)"Error", (String)"Feature stack could not be saved");
            return;
        }
        IJ.log((String)("Saved feature stack for slice " + slice + " as " + fileName));
    }

    public void setClassLabels(String[] classLabels) {
        this.classLabels = classLabels;
    }

    public String[] getClassLabels() {
        return this.classLabels;
    }

    public boolean isProcessing3D() {
        return this.isProcessing3D;
    }

    public String getModelVersion() {
        if (null != this.trainHeader) {
            String relationName = this.trainHeader.relationName();
            if (relationName.startsWith("segment")) {
                return "segment";
            }
            StringTokenizer st = new StringTokenizer(relationName, "-");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.startsWith("v")) continue;
                return token;
            }
            return relationName;
        }
        return null;
    }

    private static class LoadedClassifier {
        private AbstractClassifier newClassifier = null;
        private Instances newHeader = null;

        private LoadedClassifier() {
        }
    }
}

