/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image;

import org.scijava.meta.POM;
import org.scijava.meta.Versions;

public class About {
    private static String about(Class<?> c, String groupId, String artifactId) {
        String projectURL;
        POM pom = POM.pom(c, (String)groupId, (String)artifactId);
        String version = Versions.of(c, (String)groupId, (String)artifactId);
        StringBuilder sb = new StringBuilder();
        String projectName = pom.projectName();
        if (projectName != null && !projectName.isEmpty()) {
            sb.append(projectName);
        } else {
            sb.append(groupId + ":" + artifactId);
        }
        if (version != null && !version.isEmpty()) {
            sb.append(" v" + version);
        }
        sb.append("\n");
        String licenseName = pom.cdata("//project/licenses/license/name");
        if (licenseName != null && !licenseName.isEmpty()) {
            sb.append("Project license: " + licenseName + "\n");
        }
        if ((projectURL = pom.projectURL()) != null && !projectURL.isEmpty()) {
            sb.append("Project website: " + projectURL);
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        System.out.println(About.about(About.class, "org.scijava", "scijava-ops-image"));
    }
}

