/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.pearsons;

import java.util.function.BiFunction;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.IterablePair;
import net.imglib2.util.Pair;

public class DefaultPearsons<T extends RealType<T>, U extends RealType<U>>
implements BiFunction<Iterable<T>, Iterable<U>, Double> {
    @Override
    public Double apply(Iterable<T> image1, Iterable<U> image2) {
        return this.fastPearsons((Iterable<Pair<T, U>>)new IterablePair(image1, image2));
    }

    private double fastPearsons(Iterable<Pair<T, U>> samples) {
        Accumulator acc = new Accumulator(samples);
        int count = acc.getCount();
        double invCount = 1.0 / (double)count;
        double pearsons1 = acc.getXY() - acc.getX() * acc.getY() * invCount;
        double pearsons2 = acc.getXX() - acc.getX() * acc.getX() * invCount;
        double pearsons3 = acc.getYY() - acc.getY() * acc.getY() * invCount;
        double pearsonsR = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
        DefaultPearsons.checkForSanity(pearsonsR, count);
        return pearsonsR;
    }

    private static void checkForSanity(double value, int iterations) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("A numerical problem occurred: the input data is unsuitable for this algorithm. Possibly too few pixels (in range were: " + iterations + ").");
        }
    }

    private class Accumulator {
        private double x;
        private double y;
        private double xx;
        private double xy;
        private double yy;
        private int count;

        public Accumulator(Iterable<Pair<T, U>> samples) {
            this(samples, false, 0.0, 0.0);
        }

        protected Accumulator(Iterable<Pair<T, U>> samples, boolean subtract, double xDiff, double yDiff) {
            for (Pair sample : samples) {
                double value1 = ((RealType)sample.getA()).getRealDouble();
                double value2 = ((RealType)sample.getB()).getRealDouble();
                if (subtract) {
                    value1 -= xDiff;
                    value2 -= yDiff;
                }
                this.x += value1;
                this.y += value2;
                this.xx += value1 * value1;
                this.xy += value1 * value2;
                this.yy += value2 * value2;
                ++this.count;
            }
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getXX() {
            return this.xx;
        }

        public double getXY() {
            return this.xy;
        }

        public double getYY() {
            return this.yy;
        }

        public int getCount() {
            return this.count;
        }
    }
}

