/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import java.math.BigDecimal;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.function.Computers;

public final class ConvertComplexTypes<C extends ComplexType<C>, T extends IntegerType<T>> {
    public final Computers.Arity1<C, BitType> complexToBit = (input, output) -> output.set(input.getRealDouble() != 0.0);
    public final Computers.Arity1<T, BitType> integerToBit = (input, output) -> output.set(input.getIntegerLong() != 0L);
    public final Computers.Arity1<C, Unsigned2BitType> complexToUint2 = (input, output) -> output.set((long)input.getRealDouble());
    public final Computers.Arity1<T, Unsigned2BitType> integerToUint2 = (input, output) -> output.set(input.getIntegerLong());
    public final Computers.Arity1<C, Unsigned4BitType> complexToUint4 = (input, output) -> output.set((long)input.getRealDouble());
    public final Computers.Arity1<T, Unsigned4BitType> integerToUint4 = (input, output) -> output.set(input.getIntegerLong());
    public final Computers.Arity1<C, ByteType> complexToInt8 = (input, output) -> output.set((byte)input.getRealDouble());
    public final Computers.Arity1<T, ByteType> integerToInt8 = (input, output) -> output.set((byte)input.getIntegerLong());
    public final Computers.Arity1<C, UnsignedByteType> complexToUint8 = (input, output) -> output.set((int)input.getRealDouble());
    public final Computers.Arity1<T, UnsignedByteType> integerToUint8 = (input, output) -> output.set(input.getInteger());
    public final Computers.Arity1<C, Unsigned12BitType> complexToUint12 = (input, output) -> output.set((long)input.getRealDouble());
    public final Computers.Arity1<T, Unsigned12BitType> integerToUint12 = (input, output) -> output.set(input.getIntegerLong());
    public final Computers.Arity1<C, ShortType> complexToInt16 = (input, output) -> output.set((short)input.getRealDouble());
    public final Computers.Arity1<T, ShortType> integerToInt16 = (input, output) -> output.set((short)input.getIntegerLong());
    public final Computers.Arity1<C, UnsignedShortType> complexToUint16 = (input, output) -> output.set((int)input.getRealDouble());
    public final Computers.Arity1<T, UnsignedShortType> integerToUint16 = (input, output) -> output.set(input.getInteger());
    public final Computers.Arity1<C, IntType> complexToInt32 = (input, output) -> output.set((int)input.getRealDouble());
    public final Computers.Arity1<T, IntType> integerToInt32 = (input, output) -> output.set(input.getInteger());
    public final Computers.Arity1<C, UnsignedIntType> complexToUint32 = (input, output) -> output.set((long)input.getRealDouble());
    public final Computers.Arity1<T, UnsignedIntType> integerToUint32 = (input, output) -> output.set(input.getIntegerLong());
    public final Computers.Arity1<C, LongType> complexToInt64 = (input, output) -> output.set((long)input.getRealDouble());
    public final Computers.Arity1<T, LongType> integerToInt64 = (input, output) -> output.set(input.getIntegerLong());
    public final Computers.Arity1<C, UnsignedLongType> complexToUint64 = (input, output) -> {
        BigDecimal bd = BigDecimal.valueOf(input.getRealDouble());
        BigDecimal r = bd.remainder(BigDecimal.ONE);
        if (r.compareTo(BigDecimal.ZERO) == 0) {
            output.set(bd.toBigIntegerExact().longValue());
        } else {
            output.set(bd.toBigInteger().longValue());
        }
    };
    public final Computers.Arity1<T, UnsignedLongType> integerToUint64 = (input, output) -> output.set(input.getIntegerLong());
    public final Computers.Arity1<C, Unsigned128BitType> complexToUint128 = (input, output) -> {
        BigDecimal bd = BigDecimal.valueOf(input.getRealDouble());
        BigDecimal r = bd.remainder(BigDecimal.ONE);
        if (r.compareTo(BigDecimal.ZERO) == 0) {
            output.set(bd.toBigIntegerExact());
        } else {
            output.set(bd.toBigInteger());
        }
    };
    public final Computers.Arity1<T, Unsigned128BitType> integerToUint128 = (input, output) -> output.set(input.getBigInteger());
    public final Computers.Arity1<C, FloatType> complexToFloat32 = (input, output) -> output.set(input.getRealFloat());
    public final Computers.Arity1<C, ComplexFloatType> complexToCfloat32 = (input, output) -> output.set(input.getRealFloat(), input.getImaginaryFloat());
    public final Computers.Arity1<C, DoubleType> complexToFloat64 = (input, output) -> output.set(input.getRealDouble());
    public final Computers.Arity1<C, ComplexDoubleType> complexToCfloat64 = (input, output) -> output.set(input.getRealDouble(), input.getImaginaryDouble());
}

