/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.function.Inplaces;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;
import org.scijava.progress.Progress;

public class PadAndRichardsonLucyTV<I extends RealType<I> & NativeType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K> & NativeType<K>, C extends ComplexType<C> & NativeType<C>>
implements Functions.Arity10<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, O, C, Integer, Boolean, Boolean, Float, long[], OutOfBoundsFactory<I, RandomAccessibleInterval<I>>, RandomAccessibleInterval<O>> {
    @OpDependency(name="deconvolve.richardsonLucyUpdate")
    private Computers.Arity3<RandomAccessibleInterval<O>, Float, RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> updateOp;
    private float regularizationFactor;
    private Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> computeEstimateOp = this.getComputeEstimateOp();
    @OpDependency(name="deconvolve.normalizationFactor")
    private Inplaces.Arity5_1<RandomAccessibleInterval<O>, Dimensions, Dimensions, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>> normalizer;
    @OpDependency(name="deconvolve.firstGuess")
    private Functions.Arity3<RandomAccessibleInterval<I>, O, Dimensions, RandomAccessibleInterval<O>> firstGuess;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, O, RandomAccessibleInterval<O>> outputCreator;
    @OpDependency(name="filter.padInputFFTMethods")
    private Functions.Arity4<RandomAccessibleInterval<I>, Dimensions, Boolean, OutOfBoundsFactory<I, RandomAccessibleInterval<I>>, RandomAccessibleInterval<I>> padOp;
    @OpDependency(name="filter.padShiftKernelFFTMethods")
    private BiFunction<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> padKernelOp;
    @OpDependency(name="filter.createFFTOutput")
    private Functions.Arity3<Dimensions, C, Boolean, RandomAccessibleInterval<C>> createOp;
    @OpDependency(name="deconvolve.richardsonLucy", hints={"progress.TRACK"})
    private Computers.Arity12<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, Boolean, Boolean, C, Integer, Boolean, Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>>, List<Inplaces.Arity1<RandomAccessibleInterval<O>>>, RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> richardsonLucyOp;
    private Boolean nonCirculant;
    private Integer maxIterations;

    public Computers.Arity2<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> createFilterComputer(RandomAccessibleInterval<I> raiExtendedInput, RandomAccessibleInterval<K> raiExtendedKernel, RandomAccessibleInterval<C> fftImg, RandomAccessibleInterval<C> fftKernel, boolean accelerate, RandomAccessibleInterval<O> output) {
        ComplexType complexType = (ComplexType)((ComplexType)Util.getTypeFromInterval(fftImg)).createVariable();
        if (this.nonCirculant.booleanValue()) {
            Inplaces.Arity1 normalizerSimplified = io -> this.normalizer.mutate(io, (Object)raiExtendedInput, (Object)raiExtendedKernel, (Object)fftImg, (Object)fftKernel);
            ArrayList<Inplaces.Arity1> list = new ArrayList<Inplaces.Arity1>();
            list.add(normalizerSimplified);
            Function<RandomAccessibleInterval, RandomAccessibleInterval> fg = in -> (RandomAccessibleInterval)this.firstGuess.apply(in, (Object)((RealType)Util.getTypeFromInterval((Interval)output)), (Object)raiExtendedInput);
            return (input, kernel, out) -> this.richardsonLucyOp.compute(input, kernel, (Object)fftImg, (Object)fftKernel, (Object)true, (Object)true, (Object)complexType, (Object)this.maxIterations, (Object)accelerate, this.computeEstimateOp, (Object)list, (Object)((RandomAccessibleInterval)fg.apply(raiExtendedInput)), out);
        }
        return (input, kernel, out) -> this.richardsonLucyOp.compute(input, kernel, (Object)fftImg, (Object)fftKernel, (Object)true, (Object)true, (Object)complexType, (Object)this.maxIterations, (Object)accelerate, this.computeEstimateOp, null, null, out);
    }

    public void computeFilter(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> output, long[] paddedSize, C complexType, boolean accelerate) {
        RandomAccessibleInterval fftInput = (RandomAccessibleInterval)this.createOp.apply((Object)new FinalDimensions(paddedSize), complexType, (Object)true);
        RandomAccessibleInterval fftKernel = (RandomAccessibleInterval)this.createOp.apply((Object)new FinalDimensions(paddedSize), complexType, (Object)true);
        Computers.Arity2<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> filter = this.createFilterComputer(input, kernel, fftInput, fftKernel, accelerate, output);
        filter.compute(input, kernel, output);
    }

    public RandomAccessibleInterval<O> apply(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, O outType, C complexType, Integer maxIterations, @Nullable Boolean nonCirculant, @Nullable Boolean accelerate, Float regularizationFactor, @Nullable long[] borderSize, @Nullable OutOfBoundsFactory<I, RandomAccessibleInterval<I>> obfInput) {
        int d;
        this.nonCirculant = nonCirculant == null ? (nonCirculant = Boolean.valueOf(false)) : nonCirculant;
        Progress.defineTotal((long)0L, (long)1L);
        if (obfInput == null) {
            obfInput = nonCirculant != false ? new OutOfBoundsConstantValueFactory((Object)((RealType)((RealType)Util.getTypeFromInterval(input)).createVariable())) : new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        }
        if (accelerate == null) {
            accelerate = false;
        }
        this.maxIterations = maxIterations;
        this.regularizationFactor = regularizationFactor.floatValue();
        RandomAccessibleInterval<O> output = this.outputCreator.apply((Dimensions)input, outType);
        int numDimensions = input.numDimensions();
        long[] paddedSize = new long[numDimensions];
        if (borderSize == null) {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = (int)input.dimension(d) + (int)kernel.dimension(d) - 1;
            }
        } else {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = Math.max(kernel.dimension(d) + 2L * borderSize[d], input.dimension(d) + 2L * borderSize[d]);
            }
        }
        RandomAccessibleInterval paddedInput = (RandomAccessibleInterval)this.padOp.apply(input, (Object)new FinalDimensions(paddedSize), (Object)true, obfInput);
        RandomAccessibleInterval<K> paddedKernel = this.padKernelOp.apply(kernel, (Dimensions)new FinalDimensions(paddedSize));
        this.computeFilter(paddedInput, paddedKernel, output, paddedSize, complexType, accelerate);
        return output;
    }

    protected Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> getComputeEstimateOp() {
        return (in, out) -> this.updateOp.compute(in, (Object)Float.valueOf(this.regularizationFactor), null, out);
    }
}

