/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class RichardsonLucyCorrection<I extends RealType<I>, O extends RealType<O>, C extends ComplexType<C>>
implements Computers.Arity4<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<O>> {
    private RandomAccessibleInterval<C> fftBuffer;
    private RandomAccessibleInterval<C> fftKernel;
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, O, Img<O>> create;
    @OpDependency(name="copy.rai")
    private Function<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> copy;
    private BiConsumer<RandomAccessibleInterval<O>, RandomAccessibleInterval<I>> divide = (denomResult, numer) -> LoopBuilder.setImages((RandomAccessibleInterval)denomResult, (RandomAccessibleInterval)numer).multiThreaded().forEachChunk(chunk -> {
        RealType tmp = (RealType)((RealType)Util.getTypeFromInterval((Interval)denomResult)).createVariable();
        chunk.forEachPixel((d, n) -> {
            if (d.getRealFloat() > 0.0f) {
                tmp.setReal(n.getRealFloat());
                tmp.div(d);
                d.set((Type)tmp);
            } else {
                d.setZero();
            }
        });
        return null;
    });
    @OpDependency(name="filter.correlate")
    private Computers.Arity6<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, Boolean, Boolean, RandomAccessibleInterval<O>> correlateOp;

    public void compute(RandomAccessibleInterval<I> observed, RandomAccessibleInterval<O> reblurred, RandomAccessibleInterval<C> fftBuffer, RandomAccessibleInterval<C> fftKernel, RandomAccessibleInterval<O> correction) {
        this.divide.accept(reblurred, observed);
        this.correlateOp.compute(reblurred, null, fftBuffer, fftKernel, (Object)true, (Object)false, correction);
    }
}

