/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;
import org.scijava.ops.spi.OpDependency;

public class DefaultDifferenceEntropy<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    private static final double EPSILON = Double.MIN_NORMAL;
    @OpDependency(name="features.haralick.coocPXMinusY")
    private Function<double[][], double[]> coocPXMinusYFunc;

    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double[] pxminusy = this.coocPXMinusYFunc.apply(matrix);
        int nrGrayLevels = matrix.length;
        double res = 0.0;
        for (int k = 0; k < nrGrayLevels; ++k) {
            res += pxminusy[k] * Math.log(pxminusy[k] + Double.MIN_NORMAL);
        }
        DoubleType output = new DoubleType();
        output.set(-res);
        return output;
    }
}

