/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.fft;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.fft2.FFTMethods;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class FFTs {
    private FFTs() {
    }

    public static <T extends RealType<T>, C extends ComplexType<C>> void compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<C> output) {
        FFTMethods.realToComplex(input, output, (int)0, (boolean)false);
        for (int d = 1; d < input.numDimensions(); ++d) {
            FFTMethods.complexToComplex(output, (int)d, (boolean)true, (boolean)false);
        }
    }

    public static <T extends RealType<T>, C extends ComplexType<C>> RandomAccessibleInterval<C> transformComplexType(@OpDependency(name="filter.padInputFFTMethods") Functions.Arity4<RandomAccessibleInterval<T>, Dimensions, Boolean, OutOfBoundsFactory<T, RandomAccessibleInterval<T>>, RandomAccessibleInterval<T>> padOp, @OpDependency(name="filter.createFFTOutput") Functions.Arity3<Dimensions, C, Boolean, RandomAccessibleInterval<C>> createOp, @OpDependency(name="filter.fft") Computers.Arity1<RandomAccessibleInterval<T>, RandomAccessibleInterval<C>> fftOp, RandomAccessibleInterval<T> input, C fftType, @Nullable long[] borderSize, @Nullable Boolean fast) {
        if (fast == null) {
            fast = true;
        }
        long[] paddedSize = new long[input.numDimensions()];
        for (int d = 0; d < input.numDimensions(); ++d) {
            paddedSize[d] = input.dimension(d);
            if (borderSize == null) continue;
            int n = d;
            paddedSize[n] = paddedSize[n] + borderSize[d];
        }
        FinalDimensions paddedDimensions = new FinalDimensions(paddedSize);
        RandomAccessibleInterval output = (RandomAccessibleInterval)createOp.apply((Object)paddedDimensions, fftType, (Object)fast);
        RandomAccessibleInterval paddedInput = (RandomAccessibleInterval)padOp.apply(input, (Object)paddedDimensions, (Object)fast, null);
        fftOp.compute((Object)paddedInput, (Object)output);
        return output;
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<ComplexFloatType> transformComplexType(@OpDependency(name="filter.fft") Functions.Arity4<RandomAccessibleInterval<T>, ComplexFloatType, long[], Boolean, RandomAccessibleInterval<ComplexFloatType>> fftOp, RandomAccessibleInterval<T> input, @Nullable long[] borderSize, @Nullable Boolean fast) {
        return (RandomAccessibleInterval)fftOp.apply(input, (Object)new ComplexFloatType(), (Object)borderSize, (Object)fast);
    }

    public static <T> Img<T> createFFTMethodsOutput(@OpDependency(name="create.img") BiFunction<Dimensions, T, Img<T>> creator, Dimensions paddedDimensions, T outType, @Nullable Boolean fast) {
        if (fast == null) {
            fast = true;
        }
        Dimensions dims = FFTs.getFFTDimensionsRealToComplex(fast, paddedDimensions);
        return creator.apply(dims, (Dimensions)outType);
    }

    public static void dimensionsRealToComplex(boolean fast, Dimensions inputDimensions, long[] paddedDimensions, long[] fftDimensions) {
        if (fast) {
            FFTMethods.dimensionsRealToComplexFast((Dimensions)inputDimensions, (long[])paddedDimensions, (long[])fftDimensions);
        } else {
            FFTMethods.dimensionsRealToComplexSmall((Dimensions)inputDimensions, (long[])paddedDimensions, (long[])fftDimensions);
        }
    }

    public static Dimensions getFFTDimensionsRealToComplex(boolean fast, Dimensions inputDimensions) {
        long[] paddedSize = new long[inputDimensions.numDimensions()];
        long[] fftSize = new long[inputDimensions.numDimensions()];
        FFTs.dimensionsRealToComplex(fast, inputDimensions, paddedSize, fftSize);
        return new FinalDimensions(fftSize);
    }
}

