/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.tubeness;

import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.HessianMatrix;
import net.imglib2.algorithm.linalg.eigen.TensorEigenValues;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.scijava.concurrent.Parallelization;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultTubeness<T extends RealType<T>>
implements Computers.Arity3<RandomAccessibleInterval<T>, Double, double[], IterableInterval<DoubleType>> {
    @OpDependency(name="create.imgFactory")
    private Function<Dimensions, ImgFactory<DoubleType>> createFactoryOp;
    @OpDependency(name="transform.project")
    private Computers.Arity3<RandomAccessibleInterval<DoubleType>, Computers.Arity1<Iterable<DoubleType>, DoubleType>, Integer, IterableInterval<DoubleType>> projector;

    public void compute(RandomAccessibleInterval<T> input, Double sigma, double[] calibration, IterableInterval<DoubleType> tubeness) {
        int numDimensions = input.numDimensions();
        double[] sigmas = new double[numDimensions];
        for (int d = 0; d < sigmas.length; ++d) {
            double cal = d < calibration.length ? calibration[d] : 1.0;
            sigmas[d] = sigma / cal;
        }
        long[] gradientDims = new long[numDimensions + 1];
        long[] hessianDims = new long[numDimensions + 1];
        for (int d = 0; d < numDimensions; ++d) {
            hessianDims[d] = input.dimension(d);
            gradientDims[d] = input.dimension(d);
        }
        hessianDims[numDimensions] = numDimensions * (numDimensions + 1) / 2;
        gradientDims[numDimensions] = numDimensions;
        FinalDimensions hessianDimensions = FinalDimensions.wrap((long[])hessianDims);
        FinalDimensions gradientDimensions = FinalDimensions.wrap((long[])gradientDims);
        ImgFactory<DoubleType> factory = this.createFactoryOp.apply((Dimensions)hessianDimensions);
        Img hessian = factory.create((Dimensions)hessianDimensions, (Object)new DoubleType());
        Img gradient = factory.create((Dimensions)gradientDimensions, (Object)new DoubleType());
        Img gaussian = factory.create(input, (Object)new DoubleType());
        int nThreads = Runtime.getRuntime().availableProcessors();
        try {
            Object method;
            ExecutorService es = Parallelization.getExecutorService();
            HessianMatrix.calculateMatrix((RandomAccessible)Views.extendBorder(input), (RandomAccessibleInterval)gaussian, (RandomAccessibleInterval)gradient, (RandomAccessibleInterval)hessian, (OutOfBoundsFactory)new OutOfBoundsBorderFactory(), (int)nThreads, (ExecutorService)es, (double[])new double[]{sigma});
            RandomAccessibleInterval evs = TensorEigenValues.calculateEigenValuesSymmetric((RandomAccessibleInterval)hessian, (RandomAccessibleInterval)TensorEigenValues.createAppropriateResultImg((RandomAccessibleInterval)hessian, factory, (RealType)new DoubleType()), (int)nThreads, (ExecutorService)es);
            switch (numDimensions) {
                case 2: {
                    method = new Tubeness2D(sigma);
                    break;
                }
                case 3: {
                    method = new Tubeness3D(sigma);
                    break;
                }
                default: {
                    System.err.println("Cannot compute tubeness for " + numDimensions + "D images.");
                    return;
                }
            }
            this.projector.compute((Object)evs, method, (Object)numDimensions, tubeness);
            return;
        }
        catch (InterruptedException | ExecutionException | IncompatibleTypeException e) {
            e.printStackTrace();
            return;
        }
    }

    private static final class Tubeness3D
    implements Computers.Arity1<Iterable<DoubleType>, DoubleType> {
        private final double sigma;

        public Tubeness3D(double sigma) {
            this.sigma = sigma;
        }

        public void compute(Iterable<DoubleType> input, DoubleType output) {
            Iterator<DoubleType> it = input.iterator();
            it.next();
            double val1 = it.next().get();
            double val2 = it.next().get();
            if (val1 >= 0.0 || val2 >= 0.0) {
                output.setZero();
            } else {
                output.set(this.sigma * this.sigma * Math.sqrt(val1 * val2));
            }
        }
    }

    private static final class Tubeness2D
    implements Computers.Arity1<Iterable<DoubleType>, DoubleType> {
        private final double sigma;

        public Tubeness2D(double sigma) {
            this.sigma = sigma;
        }

        public void compute(Iterable<DoubleType> input, DoubleType output) {
            Iterator<DoubleType> it = input.iterator();
            it.next();
            double val = it.next().get();
            if (val >= 0.0) {
                output.setZero();
            } else {
                output.set(this.sigma * this.sigma * Math.abs(val));
            }
        }
    }
}

