/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.function.Function;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.OpDependency;

public class DefaultEccentricity
implements Computers.Arity1<Polygon2D, DoubleType> {
    @OpDependency(name="geom.minorAxis")
    private Function<Polygon2D, DoubleType> minorAxisFunc;
    @OpDependency(name="geom.majorAxis")
    private Function<Polygon2D, DoubleType> majorAxisFunc;

    public void compute(Polygon2D input, DoubleType eccentricity) {
        double a = this.majorAxisFunc.apply(input).get() / 2.0;
        double b = this.minorAxisFunc.apply(input).get() / 2.0;
        eccentricity.set(Math.sqrt(1.0 - Math.pow(b / a, 2.0)));
    }
}

