/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.image.geom.GeomUtils;

public class DefaultPerimeterLength
implements Computers.Arity1<Polygon2D, DoubleType> {
    public void compute(Polygon2D input, DoubleType boundarySize) {
        double perimeter = 0.0;
        List<RealLocalizable> vertices = GeomUtils.vertices(input);
        int size = vertices.size();
        for (int i = 0; i < size; ++i) {
            int nexti = (i + 1) % size;
            double dx2 = vertices.get(nexti).getDoublePosition(0) - vertices.get(i).getDoublePosition(0);
            double dy2 = vertices.get(nexti).getDoublePosition(1) - vertices.get(i).getDoublePosition(1);
            perimeter += Math.sqrt(dx2 * dx2 + dy2 * dy2);
        }
        boundarySize.set(perimeter);
    }
}

